/*
 * Decompiled with CFR 0.152.
 */
package mascoptLib.lpSolver.Impl;

import java.util.Iterator;
import java.util.Vector;
import mascoptLib.lpSolver.Impl.LpExprImpl;
import mascoptLib.lpSolver.Impl.LpIntegerVariableImpl;
import mascoptLib.lpSolver.Impl.LpLinearExprImpl;
import mascoptLib.lpSolver.interfaces.LpIntegerVariable;
import mascoptLib.lpSolver.interfaces.LpLinearIntegerExpr;

public class LpLinearIntegerExprImpl
extends LpLinearExprImpl
implements LpLinearIntegerExpr {
    private Vector<LpExprImpl.LpIntTermImpl> sumOfTerm = new Vector();
    private int constant = 0;

    public Iterator<LpExprImpl.LpIntTermImpl> termIterator() {
        return this.sumOfTerm.iterator();
    }

    @Override
    public int size() {
        return this.sumOfTerm.size();
    }

    @Override
    public void addExpr(LpLinearIntegerExpr expr) {
        Iterator<LpExprImpl.LpIntTermImpl> termIt = ((LpLinearIntegerExprImpl)expr).termIterator();
        while (termIt.hasNext()) {
            LpExprImpl.LpIntTermImpl currentTerm = termIt.next();
            this.addTerm((int)currentTerm.getCoef(), currentTerm.getVar());
        }
    }

    @Override
    public void addTerm(int coef, LpIntegerVariable var) {
        if (coef == 0) {
            return;
        }
        LpExprImpl.LpIntTermImpl currentTerm = ((LpIntegerVariableImpl)var).getRef(this);
        if (currentTerm != null) {
            currentTerm.addToCoef(coef);
            return;
        }
        currentTerm = new LpExprImpl.LpIntTermImpl((LpExprImpl)this, coef, (LpIntegerVariableImpl)var);
        this.sumOfTerm.add(currentTerm);
        ((LpIntegerVariableImpl)var).addRef(this, currentTerm);
    }

    @Override
    public void clear() {
        int i = 0;
        while (i < this.sumOfTerm.size()) {
            this.sumOfTerm.get(i).getVar().removeRef(this);
            ++i;
        }
        this.sumOfTerm.clear();
    }

    @Override
    public Iterator<LpIntegerVariable> iterator() {
        return new VarIterator(this.sumOfTerm.iterator());
    }

    public boolean constains(LpExprImpl.LpIntTermImpl term) {
        return this.sumOfTerm.contains(term);
    }

    @Override
    public void remove(LpIntegerVariable var) {
        LpExprImpl.LpIntTermImpl term = ((LpIntegerVariableImpl)var).removeRef(this);
        if (term != null) {
            this.sumOfTerm.remove(term);
        }
    }

    @Override
    public void setConstant(int constant) {
        this.constant = constant;
    }

    @Override
    public int getConstant() {
        return this.constant;
    }

    private class VarIterator
    implements Iterator<LpIntegerVariable> {
        private Iterator<LpExprImpl.LpIntTermImpl> realIt;

        public VarIterator(Iterator<LpExprImpl.LpIntTermImpl> realIt) {
            this.realIt = realIt;
        }

        @Override
        public boolean hasNext() {
            return this.realIt.hasNext();
        }

        @Override
        public LpIntegerVariable next() {
            return this.realIt.next().getVar();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

