/*
 * Decompiled with CFR 0.152.
 */
package mascoptLib.numeric;

import bridge.abstractClasses.AbstractScalar;
import mascoptLib.numeric.MascoptAbstractMP;
import mascoptLib.numeric.MascoptAbstractScalar;
import mascoptLib.numeric.MascoptInteger;
import mascoptLib.numeric.MascoptMPDecimal;

public class MascoptDouble
extends MascoptAbstractScalar {
    private static final long serialVersionUID = -6403433182429557343L;
    double value;

    public MascoptDouble(double value) {
        this.value = value;
    }

    public MascoptDouble(String value) {
        this.value = Double.parseDouble(value);
    }

    @Override
    public int compareTo(AbstractScalar arg0) {
        if (arg0 instanceof MascoptAbstractMP) {
            return new MascoptMPDecimal(this.value).compareTo(arg0);
        }
        if (this.value == arg0.doubleValue()) {
            return 0;
        }
        return this.value - arg0.doubleValue() < 0.0 ? -1 : 1;
    }

    @Override
    public AbstractScalar zero() {
        return new MascoptDouble(0.0);
    }

    @Override
    public AbstractScalar add(AbstractScalar c) {
        if (!(c instanceof MascoptDouble) && !(c instanceof MascoptInteger)) {
            throw new IllegalArgumentException("Cannot add a " + c.getClass() + " to a MascoptDouble");
        }
        this.value += c.doubleValue();
        return this;
    }

    @Override
    public AbstractScalar subtract(AbstractScalar c) {
        if (!(c instanceof MascoptDouble) && !(c instanceof MascoptInteger)) {
            throw new IllegalArgumentException("Cannot subtract a " + c.getClass() + " to a MascoptDouble");
        }
        this.value -= c.doubleValue();
        return this;
    }

    @Override
    public AbstractScalar multiply(AbstractScalar c) {
        if (!(c instanceof MascoptDouble) && !(c instanceof MascoptInteger)) {
            throw new IllegalArgumentException("Cannot multiply a MascoptDouble by a " + c.getClass());
        }
        this.value *= c.doubleValue();
        return this;
    }

    @Override
    public AbstractScalar divide(AbstractScalar c) {
        if (!(c instanceof MascoptDouble) && !(c instanceof MascoptInteger)) {
            throw new IllegalArgumentException("Cannot divide a  MascoptDouble by a " + c.getClass());
        }
        this.value /= c.doubleValue();
        return this;
    }

    @Override
    public AbstractScalar negate() {
        this.value = -this.value;
        return this;
    }

    @Override
    public byte byteValue() {
        return (byte)this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return (float)this.value;
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public long longValue() {
        return (long)this.value;
    }

    @Override
    public short shortValue() {
        return (short)this.value;
    }

    @Override
    public AbstractScalar abs() {
        this.value = Math.abs(this.value);
        return this;
    }

    @Override
    public AbstractScalar exp() {
        this.value = Math.exp(this.value);
        return this;
    }

    @Override
    public AbstractScalar log() {
        this.value = Math.log(this.value);
        return this;
    }

    @Override
    public AbstractScalar log10() {
        this.value = Math.log10(this.value);
        return this;
    }

    @Override
    public AbstractScalar pow(AbstractScalar c) {
        this.value = Math.pow(this.value, c.doubleValue());
        return this;
    }

    @Override
    public AbstractScalar sqrt() {
        this.value = Math.sqrt(this.value);
        return this;
    }

    @Override
    public String toString() {
        return "" + this.value;
    }

    @Override
    public MascoptDouble clone() {
        return (MascoptDouble)super.clone();
    }

    public boolean equals(Object o) {
        return ((MascoptAbstractScalar)o).doubleValue() == this.value;
    }

    public int hashCode() {
        return (int)this.value;
    }
}

