/*
 * Decompiled with CFR 0.152.
 */
package mascoptLib.numeric;

import bridge.abstractClasses.AbstractScalar;
import mascoptLib.numeric.MascoptAbstractMP;
import mascoptLib.numeric.MascoptAbstractScalar;
import mascoptLib.numeric.MascoptMPDecimal;

public class MascoptInteger
extends MascoptAbstractScalar {
    private static final long serialVersionUID = -7818741353659052574L;
    private int value;

    public MascoptInteger(int value) {
        this.value = value;
    }

    public MascoptInteger(String value) {
        this.value = Integer.parseInt(value);
    }

    @Override
    public int compareTo(AbstractScalar arg0) {
        if (arg0 instanceof MascoptAbstractMP) {
            return new MascoptMPDecimal(this.value).compareTo(arg0);
        }
        if (this.value == arg0.intValue()) {
            return 0;
        }
        return (double)this.value - arg0.doubleValue() < 0.0 ? -1 : 1;
    }

    @Override
    public AbstractScalar zero() {
        return new MascoptInteger(0);
    }

    @Override
    public AbstractScalar add(AbstractScalar c) {
        if (!(c instanceof MascoptInteger)) {
            throw new IllegalArgumentException("Cannot add a " + c.getClass() + " to a MascoptInteger");
        }
        this.value += c.intValue();
        return this;
    }

    @Override
    public AbstractScalar subtract(AbstractScalar c) {
        if (!(c instanceof MascoptInteger)) {
            throw new IllegalArgumentException("Cannot subtract a " + c.getClass() + " to a MascoptInteger");
        }
        this.value -= c.intValue();
        return this;
    }

    @Override
    public AbstractScalar multiply(AbstractScalar c) {
        if (!(c instanceof MascoptInteger)) {
            throw new IllegalArgumentException("Cannot multiply a MascoptInteger by a " + c.getClass());
        }
        this.value *= c.intValue();
        return this;
    }

    @Override
    public AbstractScalar divide(AbstractScalar c) {
        if (!(c instanceof MascoptInteger)) {
            throw new IllegalArgumentException("Cannot divide a  MascoptInteger by a " + c.getClass());
        }
        this.value /= c.intValue();
        return this;
    }

    @Override
    public AbstractScalar negate() {
        this.value = -this.value;
        return this;
    }

    @Override
    public byte byteValue() {
        return (byte)this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public int intValue() {
        return this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public short shortValue() {
        return (short)this.value;
    }

    @Override
    public AbstractScalar abs() {
        this.value = Math.abs(this.value);
        return this;
    }

    @Override
    public AbstractScalar exp() throws Exception {
        throw new RuntimeException("Can't call exp on an MascoptInteger");
    }

    @Override
    public AbstractScalar log() throws Exception {
        throw new RuntimeException("Can't call exp on an MascoptInteger");
    }

    @Override
    public AbstractScalar log10() throws Exception {
        throw new RuntimeException("Can't call exp on an MascoptInteger");
    }

    @Override
    public AbstractScalar pow(AbstractScalar c) {
        if (!(c instanceof MascoptInteger)) {
            throw new IllegalArgumentException("exponent must be MascoptInteger");
        }
        this.value = (int)Math.pow(this.value, c.intValue());
        return this;
    }

    @Override
    public AbstractScalar sqrt() throws Exception {
        throw new RuntimeException("Can't call exp on an MascoptInteger");
    }

    @Override
    public String toString() {
        return "" + this.value;
    }

    @Override
    public MascoptInteger clone() {
        return (MascoptInteger)super.clone();
    }

    public boolean equals(Object o) {
        return ((MascoptAbstractScalar)o).doubleValue() == (double)this.value;
    }

    public int hashCode() {
        return this.value;
    }
}

