/*
 * Decompiled with CFR 0.152.
 */
package mascoptTools;

import java.util.HashMap;
import java.util.Iterator;
import mascoptLib.core.MascoptFixedSet;
import mascoptLib.core.MascoptGraph;
import mascoptLib.core.MascoptSet;
import mascoptLib.core.MascoptVertex;
import mascoptLib.core.MascoptVertexSet;
import mascoptTools.mTools;

public class mAlgos {
    public static MascoptVertexSet MaximalIndependentSetGreedy(MascoptGraph G_) {
        MascoptGraph G = mTools.copyMGraph(G_);
        MascoptVertexSet S = new MascoptVertexSet();
        MascoptVertexSet M = new MascoptVertexSet();
        while (!((MascoptFixedSet)G.vertexSet()).isEmpty()) {
            for (MascoptVertex v : M) {
                G.removeVertex(v);
            }
            MascoptVertex x = mTools.getMinDegVertex(G);
            if (x == null) continue;
            S.add(x);
            M.add(x);
            for (MascoptVertex y : G.neighborhood(x)) {
                M.add(y);
            }
        }
        return S;
    }

    public static MascoptVertexSet MaximumIndependentSetBruteForce(MascoptGraph G) {
        MascoptVertexSet S = new MascoptVertexSet();
        long ncomb = (long)Math.pow(2.0, ((MascoptFixedSet)G.vertexSet()).size());
        Object[] V = ((MascoptFixedSet)G.vertexSet()).toArray();
        long i = 0L;
        while (i < ncomb) {
            MascoptVertexSet Sp = new MascoptVertexSet();
            String comb = Long.toBinaryString(i);
            int k = 0;
            while (k < comb.length()) {
                if (comb.charAt(k) == '1') {
                    Sp.add((MascoptVertex)V[k]);
                }
                ++k;
            }
            if (mTools.isIndependentSet(G, Sp) && Sp.size() > S.size()) {
                S = Sp;
            }
            ++i;
        }
        return S;
    }

    public static MascoptVertexSet MaximumIndependentSetMM(MascoptGraph G, MascoptVertexSet S) {
        if (!((MascoptFixedSet)G.vertexSet()).isEmpty()) {
            MascoptVertex v = mTools.getMinDegVertex(G);
            MascoptVertexSet Nv = new MascoptVertexSet();
            Nv.addAll(G.neighborhood(v));
            Nv.add(v);
            MascoptVertexSet Smax = new MascoptVertexSet();
            for (MascoptVertex u : Nv) {
                MascoptGraph Gp = mTools.copyMGraph(G);
                MascoptVertexSet Nu = new MascoptVertexSet();
                Nu.addAll(G.neighborhood(u));
                Nu.add(u);
                MascoptVertexSet Stemp = new MascoptVertexSet();
                MascoptVertexSet Su = new MascoptVertexSet();
                Su.addAll(S);
                Su.add(u);
                for (MascoptVertex nu : Nu) {
                    Gp.removeVertex(nu);
                }
                Stemp = mAlgos.MaximumIndependentSetMM(Gp, Su);
                if (Stemp.size() <= Smax.size()) continue;
                Smax = Stemp;
            }
            return Smax;
        }
        return S;
    }

    public static MascoptVertexSet MaximumIndependentSetDegMaX(MascoptGraph G) {
        int degmax = mTools.getMaxDeg(G);
        MascoptVertexSet S = new MascoptVertexSet();
        if (degmax >= 3) {
            MascoptVertex x = mTools.getMaxDegVertex(G);
            MascoptVertexSet Nx = G.neighborhood(x);
            Nx.add(x);
            MascoptGraph Gp = mTools.copyMGraph(G);
            for (MascoptVertex nx : Nx) {
                Gp.removeVertex(nx);
            }
            S = mAlgos.MaximumIndependentSetDegMaX(Gp);
            S.add(x);
            MascoptVertexSet S_ = new MascoptVertexSet();
            MascoptGraph Gpp = mTools.copyMGraph(G);
            Gpp.removeVertex(x);
            S_ = mAlgos.MaximumIndependentSetDegMaX(Gpp);
            if (S_.size() > S.size()) {
                S = S_;
            }
        } else {
            S = mAlgos.MaximalIndependentSetGreedy(G);
        }
        return S;
    }

    public static int MaximumIndependentSetFGKNb(MascoptGraph G) {
        int Vsize = ((MascoptFixedSet)G.vertexSet()).size();
        if (Vsize <= 1) {
            return Vsize;
        }
        MascoptVertexSet C = mTools.getConnectedComponent(G);
        if (!C.isEmpty() && C.size() < Vsize) {
            MascoptGraph GC = mTools.copyMGraph(G);
            MascoptGraph G_C = mTools.copyMGraph(G);
            ((MascoptSet)GC.vertexSet()).retainAll(C);
            ((MascoptSet)G_C.vertexSet()).removeAll(C);
            return mAlgos.MaximumIndependentSetFGKNb(GC) + mAlgos.MaximumIndependentSetFGKNb(G_C);
        }
        MascoptVertex v = mTools.getDominatedVertex(G);
        if (v != null) {
            MascoptGraph G_v = mTools.copyMGraph(G);
            G_v.removeVertex(v);
            return mAlgos.MaximumIndependentSetFGKNb(G_v);
        }
        boolean deg2 = false;
        MascoptVertex x = null;
        Iterator itr = ((MascoptSet)G.vertexSet()).iterator();
        while (!deg2 && itr.hasNext()) {
            x = (MascoptVertex)itr.next();
            if (G.neighborhood(x).size() != 2) continue;
            deg2 = true;
        }
        if (deg2) {
            return 1 + mAlgos.MaximumIndependentSetFGKNb(mTools.getFoldingGraph(G, x, new HashMap<MascoptVertex, MascoptVertexSet>()));
        }
        MascoptVertexSet Mdeg = mTools.getAllMaxDegVertex(G);
        MascoptVertex d = null;
        int ENv = Integer.MAX_VALUE;
        for (MascoptVertex y : Mdeg) {
            int ENy = mTools.getNbEdges(G, G.neighborhood(y));
            if (ENy >= ENv) continue;
            ENv = ENy;
            d = y;
        }
        MascoptGraph G_v_Mv = mTools.copyMGraph(G);
        MascoptGraph G_Nv = mTools.copyMGraph(G);
        G_v_Mv.removeVertex(d);
        ((MascoptSet)G_v_Mv.vertexSet()).removeAll(mTools.getMirrors(G, d));
        ((MascoptSet)G_Nv.vertexSet()).removeAll(G.neighborhood(d));
        G_Nv.removeVertex(d);
        return Math.max(mAlgos.MaximumIndependentSetFGKNb(G_v_Mv), 1 + mAlgos.MaximumIndependentSetFGKNb(G_Nv));
    }

    public static MascoptVertexSet MaximumIndependentSetFGK(MascoptGraph G) {
        int Vsize = ((MascoptFixedSet)G.vertexSet()).size();
        if (Vsize <= 1) {
            return G.vertexSet();
        }
        MascoptVertexSet C = mTools.getConnectedComponent(G);
        if (!C.isEmpty() && C.size() < Vsize) {
            MascoptGraph GC = mTools.copyMGraph(G);
            MascoptGraph G_C = mTools.copyMGraph(G);
            ((MascoptSet)GC.vertexSet()).retainAll(C);
            ((MascoptSet)G_C.vertexSet()).removeAll(C);
            MascoptVertexSet U = new MascoptVertexSet();
            U.addAll(mAlgos.MaximumIndependentSetFGK(GC));
            U.addAll(mAlgos.MaximumIndependentSetFGK(G_C));
            return U;
        }
        MascoptVertex v = mTools.getDominatedVertex(G);
        if (v != null) {
            MascoptGraph G_v = mTools.copyMGraph(G);
            G_v.removeVertex(v);
            return mAlgos.MaximumIndependentSetFGK(G_v);
        }
        boolean deg2 = false;
        MascoptVertex x = null;
        Iterator itr = ((MascoptSet)G.vertexSet()).iterator();
        while (!deg2 && itr.hasNext()) {
            x = (MascoptVertex)itr.next();
            if (G.neighborhood(x).size() != 2) continue;
            deg2 = true;
        }
        if (deg2) {
            MascoptVertexSet uF = new MascoptVertexSet();
            HashMap<MascoptVertex, MascoptVertexSet> vftable = new HashMap<MascoptVertex, MascoptVertexSet>();
            MascoptVertexSet F = mAlgos.MaximumIndependentSetFGK(mTools.getFoldingGraph(G, x, vftable));
            boolean fold = false;
            for (MascoptVertex f : F) {
                if (vftable.containsKey(f)) {
                    uF.addAll(vftable.get(f));
                    fold = true;
                    continue;
                }
                uF.add(f);
            }
            if (!fold) {
                uF.add(x);
            }
            return uF;
        }
        MascoptVertexSet Mdeg = mTools.getAllMaxDegVertex(G);
        MascoptVertex d = null;
        int ENv = Integer.MAX_VALUE;
        for (MascoptVertex y : Mdeg) {
            int ENy = mTools.getNbEdges(G, G.neighborhood(y));
            if (ENy >= ENv) continue;
            ENv = ENy;
            d = y;
        }
        MascoptGraph G_v_Mv = mTools.copyMGraph(G);
        MascoptGraph G_Nv = mTools.copyMGraph(G);
        G_v_Mv.removeVertex(d);
        ((MascoptSet)G_v_Mv.vertexSet()).removeAll(mTools.getMirrors(G, d));
        ((MascoptSet)G_Nv.vertexSet()).removeAll(G.neighborhood(d));
        G_Nv.removeVertex(d);
        MascoptVertexSet S1 = mAlgos.MaximumIndependentSetFGK(G_v_Mv);
        MascoptVertexSet S2 = mAlgos.MaximumIndependentSetFGK(G_Nv);
        S2.add(d);
        if (S1.size() > S2.size()) {
            return S1;
        }
        return S2;
    }
}

