/*
 * Decompiled with CFR 0.152.
 */
package mascoptTools;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.Stack;
import mascoptLib.core.MascoptEdge;
import mascoptLib.core.MascoptEdgeSet;
import mascoptLib.core.MascoptFixedSet;
import mascoptLib.core.MascoptGraph;
import mascoptLib.core.MascoptSet;
import mascoptLib.core.MascoptVertex;
import mascoptLib.core.MascoptVertexSet;

public class mTools {
    public static MascoptGraph copyMGraph(MascoptGraph G) {
        MascoptGraph newG = new MascoptGraph(new MascoptEdgeSet(new MascoptVertexSet()));
        for (MascoptVertex x : G.vertexSet()) {
            newG.addVertex(x);
        }
        for (MascoptEdge e : G.edgeSet()) {
            newG.addEdge(e);
        }
        return newG;
    }

    public static MascoptVertex getVertexbyName(String vname, MascoptGraph G) {
        MascoptVertex v = null;
        for (MascoptVertex x : G.vertexSet()) {
            if (!x.getName().equals(vname)) continue;
            v = x;
            break;
        }
        return v;
    }

    public static MascoptVertex getMinDegVertex(MascoptGraph G) {
        int deg = Integer.MAX_VALUE;
        MascoptVertex v = null;
        for (MascoptVertex x : G.vertexSet()) {
            if (G.neighborhood(x).size() >= deg) continue;
            v = x;
            deg = G.neighborhood(x).size();
        }
        return v;
    }

    public static MascoptVertexSet getAllMinDegVertex(MascoptGraph G) {
        MascoptVertexSet allDM = new MascoptVertexSet();
        int degmin = mTools.getMinDeg(G);
        for (MascoptVertex x : G.vertexSet()) {
            if (G.neighborhood(x).size() != degmin) continue;
            allDM.add(x);
        }
        return allDM;
    }

    public static MascoptVertex getMaxDegVertex(MascoptGraph G) {
        int deg = 0;
        MascoptVertex v = null;
        for (MascoptVertex x : G.vertexSet()) {
            if (G.neighborhood(x).size() <= deg) continue;
            v = x;
            deg = G.neighborhood(x).size();
        }
        return v;
    }

    public static MascoptVertexSet getAllMaxDegVertex(MascoptGraph G) {
        MascoptVertexSet allDM = new MascoptVertexSet();
        int degmax = mTools.getMaxDeg(G);
        for (MascoptVertex x : G.vertexSet()) {
            if (G.neighborhood(x).size() != degmax) continue;
            allDM.add(x);
        }
        return allDM;
    }

    public static int getMaxDeg(MascoptGraph G) {
        int deg = 0;
        for (MascoptVertex x : G.vertexSet()) {
            if (G.neighborhood(x).size() <= deg) continue;
            deg = G.neighborhood(x).size();
        }
        return deg;
    }

    public static int getMinDeg(MascoptGraph G) {
        int deg = Integer.MAX_VALUE;
        for (MascoptVertex x : G.vertexSet()) {
            if (G.neighborhood(x).size() >= deg) continue;
            deg = G.neighborhood(x).size();
        }
        return deg;
    }

    public static int getNbEdges(MascoptGraph G, MascoptVertexSet A) {
        int nbe = 0;
        for (MascoptEdge e : G.edgeSet()) {
            if (!A.contains(e.getVertices()[0]) || !A.contains(e.getVertices()[1])) continue;
            ++nbe;
        }
        return nbe;
    }

    public static MascoptVertexSet getNeighborhood(MascoptGraph G, MascoptVertex v, int dist) {
        MascoptVertexSet N = new MascoptVertexSet();
        MascoptVertexSet done = new MascoptVertexSet();
        N.addAll(G.neighborhood(v));
        done.addAll(N);
        done.add(v);
        int i = 1;
        while (i < dist) {
            MascoptVertexSet Nn = new MascoptVertexSet();
            for (MascoptVertex x : N) {
                Sets.difference(G.neighborhood(x), done).copyInto(Nn);
            }
            done.addAll(Nn);
            N = Nn;
            ++i;
        }
        return N;
    }

    public static MascoptVertexSet getConnectedComponent(MascoptGraph G) {
        MascoptVertexSet C = new MascoptVertexSet();
        Stack<MascoptVertex> stack = new Stack<MascoptVertex>();
        if (!((MascoptFixedSet)G.vertexSet()).isEmpty()) {
            MascoptVertex v = (MascoptVertex)((MascoptSet)G.vertexSet()).iterator().next();
            C.add(v);
            stack.add(v);
            while (!stack.isEmpty()) {
                MascoptVertex x = (MascoptVertex)stack.pop();
                MascoptVertexSet nT = new MascoptVertexSet();
                Sets.difference(G.neighborhood(x), C).copyInto(nT);
                stack.addAll(nT);
                C.addAll(nT);
            }
        }
        return C;
    }

    public static MascoptGraph getFoldingGraph(MascoptGraph G, MascoptVertex v, HashMap<MascoptVertex, MascoptVertexSet> fold) {
        int j;
        MascoptGraph Gv = mTools.copyMGraph(G);
        ArrayList<MascoptVertex> newv = new ArrayList<MascoptVertex>();
        MascoptVertexSet Nv = G.neighborhood(v);
        ArrayList<MascoptVertex> Nvlist = new ArrayList<MascoptVertex>(Nv);
        int i = 0;
        while (i < Nvlist.size() - 1) {
            j = i + 1;
            while (j < Nvlist.size()) {
                MascoptVertex uj;
                MascoptVertex ui = Nvlist.get(i);
                if (!mTools.isEdge(G, ui, uj = Nvlist.get(j))) {
                    MascoptVertex uij = new MascoptVertex();
                    uij.setName(String.valueOf(ui.getName()) + " " + uj.getName());
                    Gv.addVertex(uij);
                    MascoptVertexSet vfolded = new MascoptVertexSet();
                    vfolded.add(ui);
                    vfolded.add(uj);
                    fold.put(uij, vfolded);
                    for (MascoptVertex nui : G.neighborhood(ui)) {
                        if (mTools.isEdge(Gv, uij, nui)) continue;
                        Gv.addEdge(new MascoptEdge(uij, nui));
                    }
                    for (MascoptVertex nuj : G.neighborhood(uj)) {
                        if (mTools.isEdge(Gv, uij, nuj)) continue;
                        Gv.addEdge(new MascoptEdge(uij, nuj));
                    }
                    newv.add(uij);
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < newv.size() - 1) {
            j = i + 1;
            while (j < newv.size()) {
                if (!mTools.isEdge(G, (MascoptVertex)newv.get(i), (MascoptVertex)newv.get(j))) {
                    Gv.addEdge(new MascoptEdge((MascoptVertex)newv.get(i), (MascoptVertex)newv.get(j)));
                }
                ++j;
            }
            ++i;
        }
        for (MascoptVertex x : Nv) {
            Gv.removeVertex(x);
        }
        Gv.removeVertex(v);
        return Gv;
    }

    public static MascoptVertexSet getMirrors(MascoptGraph G, MascoptVertex v) {
        MascoptVertexSet Mv = new MascoptVertexSet();
        MascoptVertexSet U = new MascoptVertexSet();
        MascoptVertexSet Nv = G.neighborhood(v);
        U = mTools.getNeighborhood(G, v, 2);
        for (MascoptVertex u : U) {
            MascoptVertexSet C = new MascoptVertexSet();
            Sets.difference(Nv, G.neighborhood(u)).copyInto(C);
            if (!mTools.isClique(G, C)) continue;
            Mv.add(u);
        }
        return Mv;
    }

    public static MascoptVertex getDominatedVertex(MascoptGraph G) {
        MascoptVertex v = null;
        ArrayList<MascoptVertexSet> N = new ArrayList<MascoptVertexSet>();
        for (MascoptVertex x : G.vertexSet()) {
            MascoptVertexSet Nx = G.neighborhood(x);
            Nx.setName(x.getName());
            Nx.add(x);
            N.add(Nx);
        }
        mTools.quickSortSet(N, 0, N.size() - 1);
        boolean vfound = false;
        int i = N.size() - 1;
        while (i > 0 && !vfound) {
            MascoptVertexSet Nv = N.get(i);
            int j = 0;
            while (j < i && !vfound) {
                MascoptVertexSet Nw = N.get(j);
                if (Nv.containsAll(Nw)) {
                    v = mTools.getVertexbyName(Nv.getName(), G);
                    vfound = true;
                }
                ++j;
            }
            --i;
        }
        return v;
    }

    public static boolean isIndependentSet(MascoptGraph G, MascoptVertexSet S) {
        boolean b = true;
        Iterator itr = S.iterator();
        while (b && itr.hasNext()) {
            MascoptVertex v = (MascoptVertex)itr.next();
            if (Sets.intersection(S, G.neighborhood(v)).isEmpty()) continue;
            b = false;
        }
        return b;
    }

    public static boolean isEdge(MascoptGraph G, MascoptVertex v1, MascoptVertex v2) {
        return G.neighborhood(v1).contains(v2);
    }

    public static boolean isClique(MascoptGraph G, MascoptVertexSet K) {
        boolean b = true;
        if (K.isEmpty() || K.size() == 1) {
            return true;
        }
        ArrayList<MascoptVertexSet> N = new ArrayList<MascoptVertexSet>();
        for (MascoptVertex v : K) {
            MascoptVertexSet Nv = G.neighborhood(v);
            Nv.add(v);
            N.add(Nv);
        }
        MascoptVertexSet Ni = (MascoptVertexSet)N.get(0);
        int i = 1;
        while (b && i < N.size()) {
            MascoptVertexSet temp = new MascoptVertexSet();
            Sets.intersection(Ni, (Set)N.get(i)).copyInto(temp);
            Ni = temp;
            if (!Ni.containsAll(K)) {
                b = false;
            }
            ++i;
        }
        return b;
    }

    public static void quickSortSet(ArrayList<MascoptVertexSet> tab, int p, int r) {
        if (p < r) {
            int q = mTools.partitionSet(tab, p, r);
            mTools.quickSortSet(tab, p, q);
            mTools.quickSortSet(tab, q + 1, r);
        }
    }

    private static int partitionSet(ArrayList<MascoptVertexSet> tab, int p, int r) {
        int pivot = tab.get(p).size();
        int i = p - 1;
        int j = r + 1;
        while (true) {
            if (tab.get(--j).size() > pivot) {
                continue;
            }
            while (tab.get(++i).size() < pivot) {
            }
            if (i >= j) break;
            MascoptVertexSet temp = new MascoptVertexSet();
            temp.addAll(tab.get(i));
            temp.setName(tab.get(i).getName());
            tab.set(i, tab.get(j));
            tab.set(j, temp);
        }
        return j;
    }
}

