/*
 * Decompiled with CFR 0.152.
 */
package mascopttest;

import JungAGAPE.Tools;
import edu.uci.ics.jung.algorithms.layout.FRLayout;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.UndirectedSparseGraph;
import edu.uci.ics.jung.io.PajekNetReader;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.DefaultModalGraphMouse;
import edu.uci.ics.jung.visualization.decorators.ToStringLabeller;
import java.awt.Color;
import java.io.IOException;
import javax.swing.JFrame;
import org.apache.commons.collections15.FactoryUtils;

public class GraphDraw {
    public static void main(String[] args) throws IOException {
        Graph<String, Integer> g = Tools.readNet("GenGraphs/ER/ERgraph_n5p0.4.net");
        JFrame jf = new JFrame();
        System.out.println(g.getVertexCount());
        System.out.println(g.getEdgeCount());
        VisualizationViewer<String, Integer> vv = new VisualizationViewer<String, Integer>(new FRLayout<String, Integer>(g));
        vv.getRenderContext().setVertexLabelTransformer(new ToStringLabeller());
        DefaultModalGraphMouse graphMouse = new DefaultModalGraphMouse();
        vv.setGraphMouse(graphMouse);
        vv.addKeyListener(graphMouse.getModeKeyListener());
        vv.setBackground(Color.white);
        jf.getContentPane().add(vv);
        jf.setDefaultCloseOperation(3);
        jf.pack();
        jf.setVisible(true);
        System.out.println("V size: " + g.getVertexCount());
        System.out.println("E size: " + g.getEdgeCount());
        System.out.println();
    }

    public static Graph getGraph() throws IOException {
        PajekNetReader pnr = new PajekNetReader(FactoryUtils.instantiateFactory(Object.class));
        UndirectedSparseGraph g = new UndirectedSparseGraph();
        pnr.load("test.net", g);
        return g;
    }
}

