/*
 * Decompiled with CFR 0.152.
 */
package mascopttest;

import java.io.FileNotFoundException;
import java.util.logging.Level;
import java.util.logging.Logger;
import mascoptLib.core.MascoptFixedSet;
import mascoptLib.core.MascoptGraph;
import mascoptLib.core.MascoptVertexSet;
import mascoptLib.io.reader.mgl.dom.MGLDOMReader;
import mascoptTools.mAlgos;
import mascoptTools.mGraphGen;

public class TestTools {
    public static void main(String[] args) {
        MGLDOMReader mglR = null;
        try {
            mglR = new MGLDOMReader("ERgraphs/ERgraph_n15p0.1.mgl");
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(TestTools.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (SecurityException ex) {
            Logger.getLogger(TestTools.class.getName()).log(Level.SEVERE, null, ex);
        }
        mglR.parse();
        MascoptGraph G = (MascoptGraph)mglR.getGraphs().next();
        long t = 0L;
        System.out.println("V size: " + ((MascoptFixedSet)G.vertexSet()).size());
        System.out.println("E size: " + ((MascoptFixedSet)G.edgeSet()).size());
        System.out.println();
        int[][] B = mGraphGen.getBMatrix(G, 10);
        System.out.println(TestTools.MtoString(B));
        MascoptVertexSet A = new MascoptVertexSet();
        MascoptVertexSet S = new MascoptVertexSet();
        System.out.println("Stable Maximum ( V3 FGK09)");
        t = System.nanoTime();
        S = mAlgos.MaximumIndependentSetFGK(G);
        t = System.nanoTime() - t;
        System.out.println(TestTools.printTime(t));
        System.out.println(String.valueOf(S.size()) + " : " + S);
    }

    public static String printTime(long t) {
        String r = "";
        int div = 0;
        double tt = t;
        while (tt > 1000.0) {
            tt /= 1000.0;
            ++div;
        }
        r = Double.toString(tt);
        switch (div) {
            case 0: {
                r = String.valueOf(r) + " ns";
                break;
            }
            case 1: {
                r = String.valueOf(r) + " \u00b5s";
                break;
            }
            case 2: {
                r = String.valueOf(r) + " ms";
                break;
            }
            case 3: {
                r = String.valueOf(r) + " s";
            }
        }
        if (div >= 3 && tt >= 60.0) {
            r = String.valueOf(r) + " (" + (tt /= 60.0) + " mins)";
        }
        return r;
    }

    public static String MtoString(int[][] M) {
        String str = "";
        int i = 0;
        while (i < M.length) {
            int j = 0;
            while (j < M[0].length) {
                str = String.valueOf(str) + M[i][j] + " ";
                ++j;
            }
            str = String.valueOf(str) + "\n";
            ++i;
        }
        return str;
    }
}

