/*
 * Decompiled with CFR 0.152.
 */
package mc;

import JungAGAPE.Tools;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import edu.uci.ics.jung.algorithms.layout.KKLayout;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.UndirectedSparseGraph;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.DefaultModalGraphMouse;
import edu.uci.ics.jung.visualization.decorators.ToStringLabeller;
import java.awt.Color;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Stack;
import javax.swing.JFrame;
import mc.Link;
import mc.Node;
import org.apache.commons.collections15.Factory;

public class mcPb {
    static final String C = "C";
    static final String M = "M";
    static final String B = "B";
    static int capB = 2;
    static int nbC = 3;
    static int nbM = 3;
    static Set<Node> done = new HashSet<Node>();
    static Stack<Node> toDo = new Stack();
    static Factory<Link> edgeFactory = new Factory<Link>(){
        int c = 0;

        @Override
        public Link create() {
            ++this.c;
            return new Link(this.c);
        }
    };

    public static void main(String[] args) {
        UndirectedSparseGraph<Node, Link> G = new UndirectedSparseGraph<Node, Link>();
        mcPb.initGraph(G);
        Iterator itr = G.getVertices().iterator();
        Node p = (Node)itr.next();
        toDo.push(p);
        mcPb.Move(G);
        System.out.println(G);
        Tools.writeNet(G, "MC.net");
        JFrame jf = new JFrame();
        KKLayout<Node, Link> KKl = new KKLayout<Node, Link>(G);
        KKl.setLengthFactor(3.0);
        VisualizationViewer<Node, Link> vv = new VisualizationViewer<Node, Link>(KKl);
        vv.getRenderContext().setVertexLabelTransformer(new ToStringLabeller());
        vv.getRenderContext().setEdgeLabelTransformer(new ToStringLabeller());
        DefaultModalGraphMouse graphMouse = new DefaultModalGraphMouse();
        vv.setGraphMouse(graphMouse);
        vv.addKeyListener(graphMouse.getModeKeyListener());
        vv.setBackground(Color.white);
        jf.getContentPane().add(vv);
        jf.setDefaultCloseOperation(3);
        jf.pack();
        jf.setVisible(true);
        System.out.println("V size: " + G.getVertexCount());
        System.out.println("E size: " + G.getEdgeCount());
        System.out.println();
    }

    public static void initGraph(Graph<Node, Link> G) {
        HashMultiset<String> g = HashMultiset.create();
        HashMultiset<String> d = HashMultiset.create();
        g.add(C, nbC);
        g.add(M, nbM);
        g.add(B);
        Node p = new Node((Multiset<String>)g, (Multiset<String>)d);
        G.addVertex(p);
    }

    public static void Move(Graph<Node, Link> G) {
        Node p = toDo.pop();
        Set<Node> moves = mcPb.getAllMoves(p);
        HashSet<Node> legal_moves = new HashSet<Node>();
        for (Node v : moves) {
            if (!mcPb.validMove(v)) continue;
            legal_moves.add(v);
        }
        for (Node v : legal_moves) {
            Link link = edgeFactory.create();
            link.weight = mcPb.Wtransition(p, v);
            G.addEdge(link, p, v);
            if (done.contains(v)) continue;
            toDo.push(v);
        }
        done.add(p);
        if (!toDo.empty()) {
            mcPb.Move(G);
        }
    }

    public static int Wtransition(Node a, Node b) {
        int t = 0;
        int diffC = Math.abs(((Multiset)a.fst).count(C) - ((Multiset)b.fst).count(C));
        int diffM = Math.abs(((Multiset)a.fst).count(M) - ((Multiset)b.fst).count(M));
        t = Math.abs(diffC - diffM);
        return t;
    }

    public static boolean validMove(Node move) {
        boolean a = false;
        boolean b = false;
        if (((Multiset)move.fst).count(C) <= ((Multiset)move.fst).count(M) || ((Multiset)move.fst).count(M) == 0) {
            a = true;
        }
        if (((Multiset)move.snd).count(C) <= ((Multiset)move.snd).count(M) || ((Multiset)move.snd).count(M) == 0) {
            b = true;
        }
        return a && b;
    }

    public static Set<Node> getAllMoves(Node move) {
        HashSet<Node> allm = new HashSet<Node>();
        if (((Multiset)move.fst).contains(B)) {
            int cap = 1;
            while (cap <= capB) {
                int k = 0;
                while ((double)k < Math.pow(2.0, cap)) {
                    boolean moved = false;
                    String comb = "";
                    int z = 0;
                    while (z < cap) {
                        comb = String.valueOf(comb) + "0";
                        ++z;
                    }
                    String tmpcomb = Integer.toBinaryString(k);
                    char[] t = comb.toCharArray();
                    int z2 = 0;
                    while (z2 < tmpcomb.length()) {
                        t[comb.length() - 1 - z2] = tmpcomb.charAt(tmpcomb.length() - 1 - z2);
                        ++z2;
                    }
                    comb = new String(t);
                    HashMultiset<String> g = HashMultiset.create((Iterable)move.fst);
                    HashMultiset<String> d = HashMultiset.create((Iterable)move.snd);
                    int c = 0;
                    while (c < comb.length()) {
                        if (comb.substring(c, c + 1).equals("0") && g.remove(C)) {
                            d.add(C);
                            moved = true;
                        }
                        if (comb.substring(c, c + 1).equals("1") && g.remove(M)) {
                            d.add(M);
                            moved = true;
                        }
                        ++c;
                    }
                    if (moved) {
                        g.remove(B);
                        d.add(B);
                    }
                    if (!((Multiset)move.fst).equals(g) || !((Multiset)move.snd).equals(d)) {
                        allm.add(new Node((Multiset<String>)g, (Multiset<String>)d));
                    }
                    ++k;
                }
                ++cap;
            }
        } else {
            int cap = 1;
            while (cap <= capB) {
                int k = 0;
                while ((double)k < Math.pow(2.0, cap)) {
                    boolean moved = false;
                    String comb = "";
                    int z = 0;
                    while (z < cap) {
                        comb = String.valueOf(comb) + "0";
                        ++z;
                    }
                    String tmpcomb = Integer.toBinaryString(k);
                    char[] t = comb.toCharArray();
                    int z3 = 0;
                    while (z3 < tmpcomb.length()) {
                        t[comb.length() - 1 - z3] = tmpcomb.charAt(tmpcomb.length() - 1 - z3);
                        ++z3;
                    }
                    comb = new String(t);
                    HashMultiset<String> g = HashMultiset.create((Iterable)move.fst);
                    HashMultiset<String> d = HashMultiset.create((Iterable)move.snd);
                    int c = 0;
                    while (c < comb.length()) {
                        if (comb.substring(c, c + 1).equals("0") && d.remove(C)) {
                            g.add(C);
                            moved = true;
                        }
                        if (comb.substring(c, c + 1).equals("1") && d.remove(M)) {
                            g.add(M);
                            moved = true;
                        }
                        ++c;
                    }
                    if (moved) {
                        d.remove(B);
                        g.add(B);
                    }
                    if (!((Multiset)move.fst).equals(g) || !((Multiset)move.snd).equals(d)) {
                        allm.add(new Node((Multiset<String>)g, (Multiset<String>)d));
                    }
                    ++k;
                }
                ++cap;
            }
        }
        return allm;
    }
}

