/*
 * Decompiled with CFR 0.152.
 */
package tools.dataStructures;

import java.util.HashMap;
import java.util.NoSuchElementException;
import tools.dataStructures.interfaces.PriorityQueue;

public class BinaryTree<E, V extends Comparable<V>>
implements PriorityQueue<E, V> {
    private TreeNode treeRoot = null;
    private TreeNode minNode;
    private HashMap<E, V> elementToValue = new HashMap();

    private TreeNode getMinNode(TreeNode root) {
        if (root.getLeft() == null) {
            return root;
        }
        return this.getMinNode(root.getLeft());
    }

    @Override
    public void clear() {
        this.treeRoot = null;
        this.elementToValue.clear();
    }

    @Override
    public E deleteMin() throws NoSuchElementException {
        if (this.treeRoot == null) {
            throw new NoSuchElementException("The heap is empty");
        }
        Object result = this.minNode.getObject();
        if (this.minNode.getRight() == null) {
            if (this.minNode.getParent() != null) {
                this.minNode.getParent().setLeft(null);
            } else {
                this.treeRoot = null;
            }
            this.minNode = this.minNode.getParent();
        } else {
            if (this.minNode.getParent() != null) {
                this.minNode.getParent().setLeft(this.minNode.getRight());
            } else {
                this.treeRoot = this.minNode.getRight();
                this.treeRoot.setParent(null);
            }
            this.minNode = this.getMinNode(this.minNode.getRight());
        }
        this.elementToValue.remove(result);
        return result;
    }

    @Override
    public E findMin() throws NoSuchElementException {
        if (this.treeRoot == null) {
            throw new NoSuchElementException("The heap is empty");
        }
        return this.minNode.getObject();
    }

    @Override
    public boolean isEmpty() {
        return this.treeRoot == null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int insertHeapNode(TreeNode root, TreeNode node, int depth, boolean isMin) {
        if (root.getValue().compareTo(node.getValue()) < 0) {
            if (root.getRight() != null) return this.insertHeapNode(root.getRight(), node, depth + 1, false);
            root.setRight(node);
            return depth + 1;
        } else {
            if (root.getLeft() != null) return this.insertHeapNode(root.getLeft(), node, depth + 1, isMin);
            root.setLeft(node);
            if (!isMin) return depth + 1;
            this.minNode = node;
        }
        return depth + 1;
    }

    @Override
    public void insert(E x, V value) {
        TreeNode newNode = new TreeNode(this, x, value);
        if (this.treeRoot != null) {
            this.insertHeapNode(this.treeRoot, newNode, 0, true);
        } else {
            this.treeRoot = newNode;
            this.minNode = newNode;
        }
        this.elementToValue.put(x, value);
    }

    private E findInSubTree(TreeNode root, V k) throws NoSuchElementException {
        if (root.getValue().compareTo(k) == 0) {
            return root.getObject();
        }
        if (k.compareTo(root.getValue()) < 0) {
            if (root.getLeft() == null) {
                throw new NoSuchElementException();
            }
            return this.findInSubTree(root.getLeft(), k);
        }
        if (root.getRight() == null) {
            throw new NoSuchElementException();
        }
        return this.findInSubTree(root.getRight(), k);
    }

    public E find(V k) throws NoSuchElementException {
        return this.findInSubTree(this.treeRoot, k);
    }

    @Override
    public boolean contains(E element) {
        return this.elementToValue.containsKey(element);
    }

    @Override
    public V getValueOf(E element) {
        Comparable result = (Comparable)this.elementToValue.get(element);
        if (result == null) {
            throw new NoSuchElementException();
        }
        return (V)result;
    }

    private static class TreeNode {
        private TreeNode father;
        private TreeNode right;
        private TreeNode left;
        private E o;
        private V value;
        final /* synthetic */ BinaryTree this$0;

        public TreeNode(E o, V value) {
            this.this$0 = var1_1;
            assert (value != null);
            this.o = o;
            this.value = value;
            this.father = null;
            this.left = null;
            this.right = null;
        }

        public void setParent(TreeNode father) {
            this.father = father;
        }

        public TreeNode getParent() {
            return this.father;
        }

        public void setLeft(TreeNode left) {
            this.left = left;
            if (left != null) {
                left.setParent(this);
            }
        }

        public TreeNode getLeft() {
            return this.left;
        }

        public void setRight(TreeNode right) {
            this.right = right;
            if (right != null) {
                right.setParent(this);
            }
        }

        public TreeNode getRight() {
            return this.right;
        }

        public E getObject() {
            return this.o;
        }

        public V getValue() {
            return this.value;
        }
    }
}

