/*
 * Decompiled with CFR 0.152.
 */
package tools.dataStructures;

import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Vector;
import tools.dataStructures.interfaces.PriorityQueue;

public class FibonacciHeap<E, V extends Comparable<V>>
implements PriorityQueue<E, V> {
    private int nodeNumber_ = 0;
    private FibHeapNode<E, V> minNode_ = null;
    private Hashtable<E, FibHeapNode<E, V>> objectToFibNode_ = new Hashtable();

    private void FibHeapInsert(FibHeapNode<E, V> fhn) {
        ((FibHeapNode)fhn).left_ = (FibHeapNode)fhn;
        ((FibHeapNode)fhn).right_ = (FibHeapNode)fhn;
        if (this.minNode_ != null) {
            ((FibHeapNode)this.minNode_).right_.left_ = (FibHeapNode)fhn;
            ((FibHeapNode)fhn).right_ = ((FibHeapNode)this.minNode_).right_;
            ((FibHeapNode)this.minNode_).right_ = (FibHeapNode)fhn;
            ((FibHeapNode)fhn).left_ = (FibHeapNode)this.minNode_;
        }
        if (this.minNode_ == null || ((FibHeapNode)fhn).value_.compareTo(((FibHeapNode)this.minNode_).value_) < 0) {
            this.minNode_ = fhn;
        }
        ++this.nodeNumber_;
    }

    @Override
    public boolean isEmpty() {
        return this.minNode_ == null;
    }

    @Override
    public void clear() {
        while (!this.isEmpty()) {
            try {
                this.deleteMin();
            }
            catch (NoSuchElementException u) {
                return;
            }
        }
        this.nodeNumber_ = 0;
        this.minNode_ = null;
    }

    @Override
    public E findMin() throws NoSuchElementException {
        if (this.minNode_ == null) {
            throw new NoSuchElementException("The heap is empty");
        }
        return (E)((FibHeapNode)this.minNode_).element_;
    }

    private FibHeapNode<E, V> FibHeapExtractMin() {
        FibHeapNode<E, V> z = this.minNode_;
        if (z != null) {
            if (((FibHeapNode)z).child_ != null) {
                FibHeapNode w;
                FibHeapNode t = w = ((FibHeapNode)z).child_;
                do {
                    t.parent_ = null;
                } while ((t = t.right_) != w);
                ((FibHeapNode)this.minNode_).left_.right_ = w.right_;
                w.right_.left_ = ((FibHeapNode)this.minNode_).left_;
                ((FibHeapNode)this.minNode_).left_ = w;
                w.right_ = (FibHeapNode)this.minNode_;
            }
            ((FibHeapNode)z).left_.right_ = ((FibHeapNode)z).right_;
            ((FibHeapNode)z).right_.left_ = ((FibHeapNode)z).left_;
            if (z == ((FibHeapNode)z).right_) {
                this.minNode_ = null;
            } else {
                this.minNode_ = ((FibHeapNode)z).right_;
                this.Consolidate();
            }
            --this.nodeNumber_;
            this.objectToFibNode_.remove(((FibHeapNode)z).element_);
        }
        return z;
    }

    @Override
    public E deleteMin() {
        FibHeapNode<E, V> z = this.FibHeapExtractMin();
        if (z == null) {
            throw new NoSuchElementException("The heap is empty");
        }
        return (E)((FibHeapNode)z).element_;
    }

    private void Consolidate() {
        FibHeapNode stop;
        if (this.isEmpty()) {
            return;
        }
        int k = (int)Math.floor(Math.sqrt(this.nodeNumber_)) + 2;
        Vector<FibHeapNode> a = new Vector<FibHeapNode>();
        int i = 0;
        while (i < k) {
            a.add(null);
            ++i;
        }
        FibHeapNode check = stop = this.minNode_;
        do {
            FibHeapNode x;
            int d;
            if (a.get(d = (x = check).degree) == x) continue;
            while (a.get(d) != null) {
                FibHeapNode y = (FibHeapNode)a.get(d);
                if (y.value_.compareTo(x.value_) < 0) {
                    FibHeapNode temp = x;
                    x = y;
                    y = temp;
                }
                this.FibHeapLink(y, x);
                stop = x;
                check = x;
                a.set(d, null);
                ++d;
            }
            a.set(d, x);
        } while ((check = check.right_) != stop);
        this.minNode_ = stop;
        check = stop;
        do {
            if (check.value_.compareTo(((FibHeapNode)this.minNode_).value_) >= 0) continue;
            this.minNode_ = check;
        } while ((check = check.right_) != stop);
    }

    private void FibHeapLink(FibHeapNode<E, V> y, FibHeapNode<E, V> x) {
        ((FibHeapNode)y).left_.right_ = ((FibHeapNode)y).right_;
        ((FibHeapNode)y).right_.left_ = ((FibHeapNode)y).left_;
        if (((FibHeapNode)x).child_ == null) {
            ((FibHeapNode)y).right_ = (FibHeapNode)y;
            ((FibHeapNode)y).left_ = (FibHeapNode)y;
            ((FibHeapNode)x).child_ = (FibHeapNode)y;
        } else {
            ((FibHeapNode)y).right_ = ((FibHeapNode)x).child_.right_;
            ((FibHeapNode)y).left_ = ((FibHeapNode)x).child_;
            ((FibHeapNode)x).child_.right_.left_ = (FibHeapNode)y;
            ((FibHeapNode)x).child_.right_ = (FibHeapNode)y;
        }
        ((FibHeapNode)y).parent_ = (FibHeapNode)x;
        FibHeapNode<E, V> fibHeapNode = x;
        ((FibHeapNode)fibHeapNode).degree = ((FibHeapNode)fibHeapNode).degree + 1;
        ((FibHeapNode)y).mark = false;
    }

    public void FibHeapDecreaseKey(E element, V value) throws IllegalArgumentException {
        FibHeapNode<E, V> fibNode = this.objectToFibNode_.get(element);
        if (fibNode == null) {
            this.insert(element, value);
            return;
        }
        if (((FibHeapNode)fibNode).value_.compareTo(value) < 0) {
            throw new IllegalArgumentException("new key is greater than current key");
        }
        ((FibHeapNode)fibNode).value_ = value;
        FibHeapNode y = ((FibHeapNode)fibNode).parent_;
        if (y != null && ((FibHeapNode)fibNode).value_.compareTo(y.value_) < 0) {
            this.Cut(fibNode, y);
            this.CascadingCut(y);
        }
        if (((FibHeapNode)fibNode).value_.compareTo(((FibHeapNode)this.minNode_).value_) < 0) {
            this.minNode_ = fibNode;
        }
    }

    private void Cut(FibHeapNode<E, V> x, FibHeapNode<E, V> y) {
        if (((FibHeapNode)x).right_ == x) {
            ((FibHeapNode)y).child_ = null;
        } else {
            ((FibHeapNode)y).child_ = ((FibHeapNode)x).right_;
        }
        ((FibHeapNode)x).left_.right_ = ((FibHeapNode)x).right_;
        ((FibHeapNode)x).right_.left_ = ((FibHeapNode)x).left_;
        FibHeapNode<E, V> fibHeapNode = y;
        ((FibHeapNode)fibHeapNode).degree = ((FibHeapNode)fibHeapNode).degree - 1;
        ((FibHeapNode)this.minNode_).right_.left_ = (FibHeapNode)x;
        ((FibHeapNode)x).right_ = ((FibHeapNode)this.minNode_).right_;
        ((FibHeapNode)this.minNode_).right_ = (FibHeapNode)x;
        ((FibHeapNode)x).left_ = (FibHeapNode)this.minNode_;
        ((FibHeapNode)x).parent_ = null;
        ((FibHeapNode)x).mark = false;
    }

    private void CascadingCut(FibHeapNode<E, V> y) {
        FibHeapNode z = ((FibHeapNode)y).parent_;
        if (z != null) {
            if (!((FibHeapNode)y).mark) {
                ((FibHeapNode)y).mark = true;
            } else {
                this.Cut(y, z);
                this.CascadingCut(z);
            }
        }
    }

    @Override
    public void insert(E x, V value) {
        FibHeapNode fhn = new FibHeapNode(this, x, value);
        this.objectToFibNode_.put(x, fhn);
        this.FibHeapInsert(fhn);
    }

    @Override
    public boolean contains(E element) {
        return this.objectToFibNode_.get(element) != null;
    }

    @Override
    public V getValueOf(E element) {
        FibHeapNode<E, V> result = this.objectToFibNode_.get(element);
        if (result == null) {
            throw new NoSuchElementException();
        }
        return (V)((FibHeapNode)result).value_;
    }

    private static class FibHeapNode<Elm, Val extends Comparable<Val>> {
        private Elm element_;
        private Val value_;
        private FibHeapNode<Elm, Val> left_;
        private FibHeapNode<Elm, Val> right_;
        private FibHeapNode<Elm, Val> parent_;
        private FibHeapNode<Elm, Val> child_;
        private boolean mark;
        private int degree;
        final /* synthetic */ FibonacciHeap this$0;

        FibHeapNode(Elm theElement, Val value) {
            this.this$0 = var1_1;
            this.element_ = theElement;
            this.value_ = value;
            this.left_ = null;
            this.right_ = null;
            this.parent_ = null;
            this.child_ = null;
            this.mark = false;
            this.degree = 0;
        }
    }
}

