/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.common.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;

public class PercentLayout
implements LayoutManager2 {
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    private static final Constraint REMAINING_SPACE = new Constraint("*");
    private static final Constraint PREFERRED_SIZE = new Constraint("");
    private int orientation;
    private int gap;
    private Hashtable m_ComponentToConstraint;

    public PercentLayout() {
        this(0, 0);
    }

    public PercentLayout(int orientation, int gap) {
        this.setOrientation(orientation);
        this.gap = gap;
        this.m_ComponentToConstraint = new Hashtable();
    }

    public void setGap(int gap) {
        this.gap = gap;
    }

    public int getGap() {
        return this.gap;
    }

    public void setOrientation(int orientation) {
        if (orientation != 0 && orientation != 1) {
            throw new IllegalArgumentException("Orientation must be one of HORIZONTAL or VERTICAL");
        }
        this.orientation = orientation;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public Constraint getConstraint(Component component) {
        return (Constraint)this.m_ComponentToConstraint.get(component);
    }

    public void setConstraint(Component component, Object constraints) {
        if (constraints instanceof Constraint) {
            this.m_ComponentToConstraint.put(component, constraints);
        } else if (constraints instanceof Number) {
            this.setConstraint(component, new NumberConstraint(((Number)constraints).intValue()));
        } else if ("*".equals(constraints)) {
            this.setConstraint(component, REMAINING_SPACE);
        } else if ("".equals(constraints)) {
            this.setConstraint(component, PREFERRED_SIZE);
        } else if (constraints instanceof String) {
            String s = (String)constraints;
            if (s.endsWith("%")) {
                float value = Float.valueOf(s.substring(0, s.length() - 1)).floatValue() / 100.0f;
                if (value > 1.0f || value < 0.0f) {
                    throw new IllegalArgumentException("percent value must be >= 0 and <= 100");
                }
                this.setConstraint(component, new PercentConstraint(value));
            } else {
                this.setConstraint(component, new NumberConstraint(Integer.valueOf(s)));
            }
        } else if (constraints == null) {
            this.setConstraint(component, PREFERRED_SIZE);
        } else {
            throw new IllegalArgumentException("Invalid Constraint");
        }
    }

    @Override
    public void addLayoutComponent(Component component, Object constraints) {
        this.setConstraint(component, constraints);
    }

    @Override
    public float getLayoutAlignmentX(Container target) {
        return 0.5f;
    }

    @Override
    public float getLayoutAlignmentY(Container target) {
        return 0.5f;
    }

    @Override
    public void invalidateLayout(Container target) {
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public void removeLayoutComponent(Component comp) {
        this.m_ComponentToConstraint.remove(comp);
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        return this.preferredLayoutSize(parent);
    }

    @Override
    public Dimension maximumLayoutSize(Container parent) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        Component[] components = parent.getComponents();
        Insets insets = parent.getInsets();
        int width = 0;
        int height = 0;
        boolean firstVisibleComponent = true;
        int i = 0;
        int c = components.length;
        while (i < c) {
            if (components[i].isVisible()) {
                Dimension componentPreferredSize = components[i].getPreferredSize();
                if (this.orientation == 0) {
                    height = Math.max(height, componentPreferredSize.height);
                    width += componentPreferredSize.width;
                    if (firstVisibleComponent) {
                        firstVisibleComponent = false;
                    } else {
                        width += this.gap;
                    }
                } else {
                    height += componentPreferredSize.height;
                    width = Math.max(width, componentPreferredSize.width);
                    if (firstVisibleComponent) {
                        firstVisibleComponent = false;
                    } else {
                        height += this.gap;
                    }
                }
            }
            ++i;
        }
        return new Dimension(width + insets.right + insets.left, height + insets.top + insets.bottom);
    }

    @Override
    public void layoutContainer(Container parent) {
        int totalSize;
        Insets insets = parent.getInsets();
        Dimension d = parent.getSize();
        d.width = d.width - insets.left - insets.right;
        d.height = d.height - insets.top - insets.bottom;
        Component[] components = parent.getComponents();
        int[] sizes = new int[components.length];
        int availableSize = totalSize = (this.orientation == 0 ? d.width : d.height) - (components.length - 1) * this.gap;
        int i = 0;
        int c = components.length;
        while (i < c) {
            if (components[i].isVisible()) {
                Constraint constraint = (Constraint)this.m_ComponentToConstraint.get(components[i]);
                if (constraint == null || constraint == PREFERRED_SIZE) {
                    sizes[i] = this.orientation == 0 ? components[i].getPreferredSize().width : components[i].getPreferredSize().height;
                    availableSize -= sizes[i];
                } else if (constraint instanceof NumberConstraint) {
                    sizes[i] = ((NumberConstraint)constraint).intValue();
                    availableSize -= sizes[i];
                }
            }
            ++i;
        }
        int remainingSize = availableSize;
        int i2 = 0;
        int c2 = components.length;
        while (i2 < c2) {
            Constraint constraint;
            if (components[i2].isVisible() && (constraint = (Constraint)this.m_ComponentToConstraint.get(components[i2])) instanceof PercentConstraint) {
                sizes[i2] = (int)((float)remainingSize * ((PercentConstraint)constraint).floatValue());
                availableSize -= sizes[i2];
            }
            ++i2;
        }
        ArrayList<Integer> remaining = new ArrayList<Integer>();
        int i3 = 0;
        int c3 = components.length;
        while (i3 < c3) {
            Constraint constraint;
            if (components[i3].isVisible() && (constraint = (Constraint)this.m_ComponentToConstraint.get(components[i3])) == REMAINING_SPACE) {
                remaining.add(new Integer(i3));
                sizes[i3] = 0;
            }
            ++i3;
        }
        if (remaining.size() > 0) {
            int rest = availableSize / remaining.size();
            Iterator iter = remaining.iterator();
            while (iter.hasNext()) {
                sizes[((Integer)iter.next()).intValue()] = rest;
            }
        }
        int currentOffset = this.orientation == 0 ? insets.left : insets.top;
        int i4 = 0;
        int c4 = components.length;
        while (i4 < c4) {
            if (components[i4].isVisible()) {
                if (this.orientation == 0) {
                    components[i4].setBounds(currentOffset, insets.top, sizes[i4], d.height);
                } else {
                    components[i4].setBounds(insets.left, currentOffset, d.width, sizes[i4]);
                }
                currentOffset += this.gap + sizes[i4];
            }
            ++i4;
        }
    }

    static class Constraint {
        protected Object value;

        private Constraint(Object value) {
            this.value = value;
        }

        /* synthetic */ Constraint(Object object, Constraint constraint, Constraint constraint2) {
            this(object);
        }
    }

    static class NumberConstraint
    extends Constraint {
        public NumberConstraint(int d) {
            this(new Integer(d));
        }

        public NumberConstraint(Integer d) {
            super(d, null, null);
        }

        public int intValue() {
            return (Integer)this.value;
        }
    }

    static class PercentConstraint
    extends Constraint {
        public PercentConstraint(float d) {
            super(new Float(d), null, null);
        }

        public float floatValue() {
            return ((Float)this.value).floatValue();
        }
    }
}

