/*
 * Decompiled with CFR 0.152.
 */
package explorer;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JPanel;

public class ImagePanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private BufferedImage img;

    public void setImage(BufferedImage image) {
        this.img = new BufferedImage(image.getWidth(), image.getHeight(), image.getType());
        Graphics2D g = this.img.createGraphics();
        g.drawImage((Image)image, 0, 0, this);
        g.dispose();
    }

    public void draw() {
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.img != null) {
            g.drawImage(this.img, 0, 0, this);
        }
    }

    BufferedImage toBufferedImage(Image image) {
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        image = new ImageIcon(image).getImage();
        BufferedImage bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 1);
        Graphics2D g = bufferedImage.createGraphics();
        g.drawImage(image, 0, 0, this);
        g.dispose();
        return bufferedImage;
    }
}

