/*
 * Decompiled with CFR 0.152.
 */
package explorer.batch;

import explorer.batch.CentralResult;
import explorer.batch.ResultDisplay;
import explorer.compute.classification.Indices;
import explorer.compute.classification.KMean;
import explorer.compute.compute.Decoupe;
import explorer.compute.compute.projection.PMFactory;
import explorer.compute.compute.projection.PMLDA;
import explorer.compute.compute.projection.PMPCA;
import explorer.compute.compute.projection.conditionning.Conditioning;
import explorer.compute.compute.projection.conditionning.ConditioningFactory;
import explorer.data.SourceAttrVal;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Vector;

public class InteractionTest {
    private static boolean contient(Vector<String> LC, String s) {
        int i = 0;
        while (i < LC.size() && !LC.elementAt(i).equals(s)) {
            ++i;
        }
        return i < LC.size();
    }

    private static String contrainteC2inf(PMPCA acp, PMLDA lda, Vector<String> LC, int nbDims) {
        int n = acp.getNbActifs();
        int iMin = -1;
        int jMin = -1;
        float min = -1.0f;
        float ymin = 0.0f;
        int i = 0;
        while (i < n) {
            if (lda.estActif(i)) {
                int j = i + 1;
                while (j < n) {
                    if (lda.estActif(j)) {
                        float x = acp.distanceND(i, j, nbDims);
                        float y = lda.distanceND(i, j, nbDims);
                        String s = "Comp | 1 : " + i + " - " + j + " < " + y;
                        if (y < x && !InteractionTest.contient(LC, s) && (x / y > min || min == -1.0f)) {
                            iMin = i;
                            jMin = j;
                            min = x / y;
                            ymin = y;
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        System.out.println("Comp | 1 : " + iMin + " - " + jMin + " < " + ymin);
        return "Comp | 1 : " + iMin + " - " + jMin + " < " + ymin;
    }

    private static String contrainteC2infMatth(PMPCA acp, PMLDA lda, Vector<String> LC, int nbDims, int nbc) {
        float y;
        float x;
        int j;
        int n = acp.getNbActifs();
        float[] tab = new float[n * (n - 1) / 2];
        int rank = 0;
        int i = 0;
        while (i < n) {
            if (lda.estActif(i)) {
                j = i + 1;
                while (j < n) {
                    if (lda.estActif(j)) {
                        x = acp.distanceND(i, j, nbDims);
                        y = lda.distanceND(i, j, nbDims);
                        String s = "Comp | 1 : " + i + " - " + j + " < " + y;
                        tab[rank] = y < x && !InteractionTest.contient(LC, s) && y != 0.0f ? x / y : 0.0f;
                        ++rank;
                    }
                    ++j;
                }
            }
            ++i;
        }
        Arrays.sort(tab);
        float thr = tab[rank - nbc];
        int[][] cand = new int[nbc][2];
        float[] candXY = new float[nbc];
        rank = 0;
        i = 0;
        while (i < n) {
            if (lda.estActif(i)) {
                j = i + 1;
                while (j < n) {
                    if (lda.estActif(j)) {
                        x = acp.distanceND(i, j, nbDims);
                        y = lda.distanceND(i, j, nbDims);
                        String s = "Comp | 1 : " + i + " - " + j + " < " + y;
                        if (y < x && !InteractionTest.contient(LC, s) && x / y > thr) {
                            cand[rank][0] = i;
                            cand[rank][1] = j;
                            candXY[rank] = x / y;
                            ++rank;
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        float minXY = 0.0f;
        int minRank = 0;
        i = 0;
        while (i < rank) {
            if (candXY[i] < minXY) {
                minXY = candXY[i];
                minRank = i;
            }
            ++i;
        }
        i = cand[minRank][0];
        j = cand[minRank][1];
        System.out.println("Comp | 1 : " + i + " - " + j + " < " + lda.distanceND(i, j, nbDims) + " " + candXY[minRank]);
        return "Comp | 1 : " + i + " - " + j + " < " + lda.distanceND(i, j, nbDims);
    }

    private static float threshC2inf(PMPCA acp, PMLDA lda, int nbDims, int nbc) {
        int n = acp.getNbActifs();
        int rank = 0;
        float[] tab = new float[n * (n - 1) / 2];
        int i = 0;
        while (i < n) {
            if (lda.estActif(i)) {
                int j = i + 1;
                while (j < n) {
                    if (lda.estActif(j)) {
                        float x = acp.distanceND(i, j, nbDims);
                        float y = lda.distanceND(i, j, nbDims);
                        tab[rank] = y != 0.0f ? x / y : 0.0f;
                        ++rank;
                    }
                    ++j;
                }
            }
            ++i;
        }
        Arrays.sort(tab);
        return tab[rank - nbc];
    }

    private static float SommeC2infMatth(PMPCA acp, PMLDA lda, int nbDims) {
        int n = acp.getNbActifs();
        float sum = 0.0f;
        int i = 0;
        while (i < n) {
            if (lda.estActif(i)) {
                int j = i + 1;
                while (j < n) {
                    if (lda.estActif(j)) {
                        float x = acp.distanceND(i, j, nbDims);
                        float y = lda.distanceND(i, j, nbDims);
                        if (x != 0.0f && y != 0.0f) {
                            sum += x / y;
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        return sum / (float)(n * (n - 1) / 2);
    }

    private static int supC2infMatth(PMPCA acp, PMLDA lda, int nbDims, float thrmax) {
        int n = acp.getNbActifs();
        int nbsup = 0;
        int rank = 0;
        int i = 0;
        while (i < n) {
            if (lda.estActif(i)) {
                int j = i + 1;
                while (j < n) {
                    if (lda.estActif(j)) {
                        float x = acp.distanceND(i, j, nbDims);
                        float y = lda.distanceND(i, j, nbDims);
                        ++rank;
                        if (x / y >= thrmax) {
                            ++nbsup;
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        return nbsup;
    }

    private static String contrainteC2sup(PMPCA acp, PMLDA lda, Vector<String> LC, int nbDims) {
        int n = acp.getNbActifs();
        int iMin = -1;
        int jMin = -1;
        float min = -1.0f;
        float ymin = 0.0f;
        int i = 0;
        while (i < n) {
            int j = i + 1;
            while (j < n) {
                float x = acp.distanceND(i, j, nbDims);
                float y = lda.distanceND(i, j, nbDims);
                String s = "Comp | 1 : " + i + " - " + j + " > " + y;
                if (x < y && !InteractionTest.contient(LC, s) && (y / x > min || min == -1.0f)) {
                    iMin = i;
                    jMin = j;
                    min = y / x;
                    ymin = y;
                }
                ++j;
            }
            ++i;
        }
        System.out.println("Comp | 1 : " + iMin + " - " + jMin + " > " + ymin + " " + min);
        return "Comp | 1 : " + iMin + " - " + jMin + " > " + ymin;
    }

    private static String contrainteC3inf(PMPCA acp, PMLDA lda, Vector<String> LC, int nbDims) {
        int n = acp.getNbActifs();
        int aMin = -1;
        int bMin = -1;
        int cMin = -1;
        float min = -1.0f;
        float ymin = 0.0f;
        int a = 0;
        while (a < n) {
            int b = 0;
            while (b < n) {
                if (a != b) {
                    float Dab = acp.distanceND(a, b, nbDims);
                    float y = lda.distanceND(a, b, nbDims);
                    int c = 0;
                    while (c < n) {
                        if (a != c && b != c && lda.classe(a) == lda.classe(c) && lda.classe(a) != lda.classe(b)) {
                            float Dac = acp.distanceND(a, c, nbDims);
                            float y1 = lda.distanceND(a, c, nbDims);
                            String s = "An | 1 : " + a + " - " + b + " - " + c + " < " + y1 / y;
                            if (Dab < Dac && !InteractionTest.contient(LC, s) && Dac / Dab > min || min == -1.0f) {
                                aMin = a;
                                bMin = b;
                                cMin = c;
                                min = Dac / Dab;
                                ymin = y1 / y;
                            }
                        }
                        ++c;
                    }
                }
                ++b;
            }
            ++a;
        }
        System.out.println("An | 1 : " + aMin + " - " + bMin + " - " + cMin + " < " + ymin);
        return "An | 1 : " + aMin + " - " + bMin + " - " + cMin + " < " + ymin;
    }

    private static String contrainteC3sup(PMPCA acp, PMLDA lda, Vector<String> LC, int nbDims) {
        int n = acp.getNbActifs();
        int aMin = -1;
        int bMin = -1;
        int cMin = -1;
        float min = -1.0f;
        float ymin = 0.0f;
        int a = 0;
        while (a < n) {
            int b = 0;
            while (b < n) {
                if (a != b) {
                    float Dab = acp.distanceND(a, b, nbDims);
                    float y = lda.distanceND(a, b, nbDims);
                    int c = 0;
                    while (c < n) {
                        if (a != c && b != c && lda.classe(a) == lda.classe(c) && lda.classe(a) != lda.classe(b)) {
                            float Dac = acp.distanceND(a, c, nbDims);
                            float y1 = lda.distanceND(a, c, nbDims);
                            String s = "An | 1 : " + a + " - " + b + " - " + c + " < " + y1 / y;
                            if (Dab < Dac && !InteractionTest.contient(LC, s) && Dac / Dab > min || min == -1.0f) {
                                aMin = a;
                                bMin = b;
                                cMin = c;
                                min = Dac / Dab;
                                ymin = y1 / y;
                            }
                        }
                        ++c;
                    }
                }
                ++b;
            }
            ++a;
        }
        System.out.println("An | 1 : " + aMin + " - " + bMin + " - " + cMin + " < " + ymin);
        return "An | 1 : " + aMin + " - " + bMin + " - " + cMin + " < " + ymin;
    }

    private static void contrainteCV(PMPCA acp, PMLDA lda, Vector<String> LC, int nbDims) {
        float y;
        int b;
        int n = acp.getNbActifs();
        int aMin = -1;
        int bMin = -1;
        int cMin = -1;
        float min = -1.0f;
        float ymin = 0.0f;
        float som_max = -1.0f;
        float[] dist = new float[n];
        int[] ind = new int[n];
        int[] la_contrainte = new int[7];
        int a = 0;
        while (a < n) {
            int j;
            int imin;
            b = 0;
            while (b < n) {
                dist[b] = acp.distanceND(a, b, nbDims);
                ind[b] = b;
                ++b;
            }
            dist[a] = -1.0f;
            int i = 0;
            while (i < n) {
                imin = i;
                j = i + 1;
                while (j < n) {
                    if (dist[j] < dist[imin]) {
                        imin = j;
                    }
                    ++j;
                }
                y = dist[i];
                dist[i] = dist[imin];
                dist[imin] = y;
                j = ind[i];
                ind[i] = ind[imin];
                ind[imin] = j;
                ++i;
            }
            if (lda.classe(a) != lda.classe(ind[1])) {
                int aa = ind[1];
                int bb = ind[2];
                int cc = ind[3];
                int k = 0;
                b = 0;
                while (b < n) {
                    if (lda.classe(a) == lda.classe(b) && a != b) {
                        dist[k] = acp.distanceND(a, b, nbDims) / lda.distanceND(a, b, nbDims);
                        ind[k] = b;
                        ++k;
                    }
                    ++b;
                }
                i = 0;
                while (i < k) {
                    imin = i;
                    j = i + 1;
                    while (j < k) {
                        if (dist[j] > dist[imin]) {
                            imin = j;
                        }
                        ++j;
                    }
                    y = dist[i];
                    dist[i] = dist[imin];
                    dist[imin] = y;
                    j = ind[i];
                    ind[i] = ind[imin];
                    ind[imin] = j;
                    ++i;
                }
                float som = dist[0] + dist[1] + dist[2];
                if (som > som_max) {
                    la_contrainte[0] = aa;
                    la_contrainte[1] = bb;
                    la_contrainte[2] = cc;
                    la_contrainte[3] = ind[0];
                    la_contrainte[4] = ind[1];
                    la_contrainte[5] = ind[5];
                    la_contrainte[6] = a;
                    som_max = som;
                }
            }
            ++a;
        }
        float v1 = 0.4f;
        float v2 = 2.5f;
        a = la_contrainte[6];
        b = la_contrainte[0];
        y = acp.getSource().distance(a, b);
        String s = "Comp | 1 : " + a + " - " + b + " > " + y * v1;
        LC.add(s);
        System.out.println(s);
        b = la_contrainte[1];
        y = acp.getSource().distance(a, b);
        s = "Comp | 1 : " + a + " - " + b + " > " + y * v1;
        b = la_contrainte[2];
        y = acp.getSource().distance(a, b);
        s = "Comp | 1 : " + a + " - " + b + " > " + y * v1;
        b = la_contrainte[3];
        y = lda.distanceND(a, b, nbDims);
        s = "Comp | 1 : " + a + " - " + b + " < " + y * v2;
        LC.add(s);
        System.out.println(s);
        b = la_contrainte[4];
        y = lda.distanceND(a, b, nbDims);
        s = "Comp | 1 : " + a + " - " + b + " < " + y * v2;
        LC.add(s);
        System.out.println(s);
        b = la_contrainte[5];
        y = lda.distanceND(a, b, nbDims);
        s = "Comp | 1 : " + a + " - " + b + " < " + y * v2;
        LC.add(s);
        System.out.println(s);
    }

    public static void testclassic(int nbelem, SourceAttrVal src, int[] classe, String output, String nameFic, int nbDims) {
        int nbgroupes = 10;
        int nbBoucles = 0;
        int maxConstr = 100;
        int nbConstr = 0;
        int knn = 1;
        int verbose = 1;
        int[] axes = new int[nbDims];
        int i = 0;
        while (i < nbDims) {
            axes[i] = i;
            ++i;
        }
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(output);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        PrintStream psout = new PrintStream(fos);
        int[] cross = Decoupe.nFold(classe, 5);
        Conditioning c = ConditioningFactory.createConditioning(2, true);
        PMLDA lda = PMFactory.getSingleton().createPMLDA(src, c);
        int i2 = 0;
        while (i2 < lda.getNbObjets()) {
            cross[i2] = cross[i2] == 0 ? 1 : 0;
            ++i2;
        }
        lda.calculer();
        lda.calculerCentreGravite();
        lda.creerProjection();
        c = ConditioningFactory.createConditioning(2, true);
        PMPCA acp = PMFactory.getSingleton().createPMPCA(src, c);
        acp.calculer();
        acp.calculerCentreGravite();
        acp.creerProjection();
        float acpInter = acp.varianceInter(axes);
        float acpIntra = acp.varianceIntra(axes);
        float acpTotal = acp.varianceTotale(axes);
        float ldaTotal = lda.varianceTotale(axes);
        float ldaInter = lda.varianceInter(axes);
        float ldaIntra = lda.varianceIntra(axes);
        System.out.println("variance inter/intra ACP : " + 100.0f * acpInter / acpTotal + "    " + 100.0f * acpIntra / acpTotal + "   ->   " + acpTotal);
        System.out.println("variance inter/intra LDA : " + 100.0f * ldaInter / ldaTotal + "    " + 100.0f * ldaIntra / ldaTotal + "   ->   " + ldaTotal);
        CentralResult resultats = new CentralResult();
        Vector<String> LC = new Vector<String>();
        float thresh = InteractionTest.threshC2inf(acp, lda, nbDims, maxConstr * 10);
        resultats.addResult("acp", "varintra", 100.0f * acpIntra / acpTotal);
        resultats.addResult("acp", "varinter", 100.0f * acpInter / acpTotal);
        resultats.addResult("acp", "Variance", acpTotal);
        resultats.addResult("acp", "sumdist", InteractionTest.SommeC2infMatth(acp, lda, nbDims));
        resultats.addResult("acp", "supth", InteractionTest.supC2infMatth(acp, lda, nbDims, thresh));
        while (nbConstr < maxConstr) {
            System.out.println("Run n\u00b0 " + nbConstr);
            LC.add(InteractionTest.contrainteC2infMatth(acp, lda, LC, nbDims, maxConstr));
            ++nbConstr;
            System.out.println("SUM " + InteractionTest.SommeC2infMatth(acp, lda, nbDims));
            acp.reinit();
            acp.creerProjection();
            acpInter = acp.varianceInter(axes);
            acpIntra = acp.varianceIntra(axes);
            acpTotal = acp.varianceTotale(axes);
            System.out.println("variance inter/intra ACP : " + 100.0f * acpInter / acpTotal + "    " + 100.0f * acpIntra / acpTotal + "   ->   " + acpTotal);
            resultats.addResult("acp", "varintra", 100.0f * acpIntra / acpTotal);
            resultats.addResult("acp", "varinter", 100.0f * (acpInter / acpTotal) / (ldaInter / ldaTotal));
            resultats.addResult("acp", "Variance", acpTotal);
            resultats.addResult("acp", "sumdist", InteractionTest.SommeC2infMatth(acp, lda, nbDims));
            resultats.addResult("acp", "supth", InteractionTest.supC2infMatth(acp, lda, nbDims, thresh));
            System.out.println();
        }
        ResultDisplay resdisplay = new ResultDisplay(resultats, psout, verbose);
        resdisplay.afficherln("--------------------------------------------------------", psout, verbose);
        resdisplay.afficherln("Source : " + nameFic, psout, verbose);
        resdisplay.afficherln("knn=" + knn, psout, verbose);
        resdisplay.afficherln("nbgroupes=" + nbgroupes, psout, verbose);
        resdisplay.afficherln("nbBoucles=" + nbBoucles, psout, verbose);
        resdisplay.afficherln("--------------------------------------------------------", psout, verbose);
        resdisplay.afficheMethodeType("acp", "varintra");
        resdisplay.afficheMethodeType("acp", "varinter");
        resdisplay.afficheMethodeType("acp", "Variance");
        resdisplay.afficheMethodeType("acp", "sumdist");
        resdisplay.afficheMethodeType("acp", "supth");
        System.out.println("variance inter/intra LDA : " + 100.0f * ldaInter / ldaTotal + "    " + 100.0f * ldaIntra / ldaTotal + "   ->   " + ldaTotal);
        psout.close();
    }

    public static void testclassicCSV(int nbelem, SourceAttrVal src, int[] classe, String output, String nameFic, int nbDims, int nbClasses, boolean poor) {
        Object projlda;
        int nbgroupes = 10;
        int nbBoucles = 0;
        int maxConstr = 100;
        int nbConstr = 0;
        int knn = 1;
        int verbose = 1;
        int[] axes = new int[nbDims];
        int i = 0;
        while (i < nbDims) {
            axes[i] = i;
            ++i;
        }
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(output);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        PrintStream psout = new PrintStream(fos);
        int[] cross = Decoupe.nFold(classe, 5);
        Conditioning c = ConditioningFactory.createConditioning(2, true);
        PMLDA lda = PMFactory.getSingleton().createPMLDA(src, c);
        int i2 = 0;
        while (i2 < lda.getNbObjets()) {
            cross[i2] = cross[i2] == 0 ? 1 : 0;
            ++i2;
        }
        lda.calculer();
        lda.calculerCentreGravite();
        lda.creerProjection();
        c = ConditioningFactory.createConditioning(2, true);
        PMPCA acp = PMFactory.getSingleton().createPMPCA(src, c);
        acp.calculer();
        acp.calculerCentreGravite();
        acp.creerProjection();
        float acpInter = acp.varianceInter(axes);
        float acpIntra = acp.varianceIntra(axes);
        float acpTotal = acp.varianceTotale(axes);
        float ldaTotal = lda.varianceTotale(axes);
        float ldaInter = lda.varianceInter(axes);
        float ldaIntra = lda.varianceIntra(axes);
        System.out.println("variance inter/intra ACP : " + 100.0f * acpInter / acpTotal + "    " + 100.0f * acpIntra / acpTotal + "   ->   " + acpTotal);
        System.out.println("variance inter/intra LDA : " + 100.0f * ldaInter / ldaTotal + "    " + 100.0f * ldaIntra / ldaTotal + "   ->   " + ldaTotal);
        CentralResult resultats = new CentralResult();
        Vector<String> LC = new Vector<String>();
        resultats.addResult("acp", "varintra", 100.0f * acpIntra / acpTotal);
        resultats.addResult("acp", "varinter", 100.0f * acpInter / acpTotal);
        resultats.addResult("acp", "Variance", acpTotal);
        resultats.addResult("acp", "sumdist", InteractionTest.SommeC2infMatth(acp, lda, nbDims));
        int nbkm = 10;
        float meanrand = 0.0f;
        int[] nArray = new int[3];
        nArray[1] = 1;
        nArray[2] = 2;
        acp.creerProjection3D(nArray);
        int km = 0;
        while (km < nbkm) {
            KMean k = new KMean(acp.getDataProjected3D(), nbClasses);
            k.compute(100);
            meanrand += Indices.rand(classe, k.getClasses());
            ++km;
        }
        resultats.addResult("acp", "rand", meanrand /= (float)nbkm);
        double[][] vp = acp.getVecteursPropres();
        double[] vp1 = new double[vp.length];
        int vc = 0;
        while (vc < vp.length) {
            vp1[vc] = vp[vc][0];
            ++vc;
        }
        resultats.addResult("acp", "cos", 1.0f);
        while (nbConstr < maxConstr) {
            String contrainte = InteractionTest.contrainteC2sup(acp, lda, LC, nbDims);
            LC.add(contrainte);
            ++nbConstr;
            acp.reinit();
            acp.creerProjection();
            acpInter = acp.varianceInter(axes);
            acpIntra = acp.varianceIntra(axes);
            acpTotal = acp.varianceTotale(axes);
            resultats.addResult("acp", "varintra", 100.0f * acpIntra / acpTotal);
            resultats.addResult("acp", "varinter", 100.0f * (acpInter / acpTotal) / (ldaInter / ldaTotal));
            resultats.addResult("acp", "Variance", acpTotal);
            resultats.addResult("acp", "sumdist", InteractionTest.SommeC2infMatth(acp, lda, nbDims));
            meanrand = 0.0f;
            int[] nArray2 = new int[3];
            nArray2[1] = 1;
            nArray2[2] = 2;
            acp.creerProjection3D(nArray2);
            int km2 = 0;
            while (km2 < nbkm) {
                KMean k = new KMean(acp.getDataProjected3D(), nbClasses);
                k.compute(100);
                meanrand += Indices.rand(classe, k.getClasses());
                ++km2;
            }
            resultats.addResult("acp", "rand", meanrand /= (float)nbkm);
            vp = acp.getVecteursPropres();
            double cos = 0.0;
            int vc2 = 0;
            while (vc2 < vp1.length) {
                cos += vp1[vc2] * vp[vc2][0];
                ++vc2;
            }
            resultats.addResult("acp", "cos", (float)cos);
        }
        ResultDisplay resdisplay = new ResultDisplay(resultats, psout, verbose);
        resdisplay.afficherln("--------------------------------------------------------", psout, verbose);
        resdisplay.afficherln("Source : " + nameFic, psout, verbose);
        resdisplay.afficherln("knn=" + knn, psout, verbose);
        resdisplay.afficherln("nbgroupes=" + nbgroupes, psout, verbose);
        resdisplay.afficherln("nbBoucles=" + nbBoucles, psout, verbose);
        resdisplay.afficherln("--------------------------------------------------------", psout, verbose);
        resdisplay.afficherln("ALD (inter intra var rand)", psout, verbose);
        meanrand = 0.0f;
        int nd = lda.getNbDimensions();
        if (nd < 3) {
            int[] dims;
            if (nd == 1) {
                dims = new int[1];
            } else {
                int[] nArray3 = new int[2];
                nArray3[1] = 1;
                dims = nArray3;
            }
            projlda = new float[classe.length][];
            int cpt = 0;
            while (cpt < classe.length) {
                projlda[cpt] = lda.projection(cpt, dims);
                ++cpt;
            }
        } else {
            int[] nArray4 = new int[3];
            nArray4[1] = 1;
            nArray4[2] = 2;
            lda.creerProjection3D(nArray4);
            projlda = lda.getDataProjected3D();
        }
        int km3 = 0;
        while (km3 < nbkm) {
            KMean k = new KMean((float[][])projlda, nbClasses);
            k.compute(100);
            meanrand += Indices.rand(classe, k.getClasses());
            ++km3;
        }
        String ldaout = String.valueOf(100.0f * ldaIntra / ldaTotal) + " " + 100.0f * ldaInter / ldaTotal + " " + ldaTotal + " " + (meanrand /= (float)nbkm);
        resdisplay.afficherln(ldaout, psout, verbose);
        resdisplay.afficherln("--------------------------------------------------------", psout, verbose);
        resultats.prepareColumns("acp", "varintra");
        resultats.prepareColumns("acp", "varinter");
        resultats.prepareColumns("acp", "Variance");
        resultats.prepareColumns("acp", "sumdist");
        resultats.prepareColumns("acp", "rand");
        resultats.prepareColumns("acp", "cos");
        resdisplay.afficheColumns();
        System.out.println("variance inter/intra LDA : " + 100.0f * ldaInter / ldaTotal + "    " + 100.0f * ldaIntra / ldaTotal + "   ->   " + ldaTotal);
        psout.close();
    }
}

