/*
 * Decompiled with CFR 0.152.
 */
package explorer.batch;

import explorer.batch.CentralResult;
import explorer.batch.ResultDisplay;
import explorer.batch.acp.InterfaceTestACP;
import explorer.batch.acp.TestACP;
import explorer.batch.acp.TestACPExec;
import explorer.batch.ardp.InterfaceTestARDp;
import explorer.batch.ardp.TestARDp;
import explorer.batch.ardp.TestARDpExec;
import explorer.batch.ardp_boost.InterfaceTestARDpBoost;
import explorer.batch.ardp_boost.TestARDpBoost;
import explorer.batch.ardp_boost.TestARDpBoostExec;
import explorer.batch.knn.InterfaceTestKnn;
import explorer.batch.knn.TestKnn;
import explorer.batch.knn.TestKnnExec;
import explorer.batch.knn_acp_boost.InterfaceTestKnnBoost;
import explorer.batch.knn_acp_boost.TestKnnBoost;
import explorer.batch.knn_acp_boost.TestKnnBoostExec;
import explorer.batch.lda.InterfaceTestLDA;
import explorer.batch.lda.TestLDA;
import explorer.batch.lda.TestLDAExec;
import explorer.batch.lmnn.InterfaceTestLMNN;
import explorer.batch.lmnn.TestLMNN;
import explorer.batch.lmnn.TestLMNNExec;
import explorer.compute.compute.Decoupe;
import explorer.compute.compute.projection.PMFactory;
import explorer.compute.compute.projection.PMKNNPCA_Boost;
import explorer.compute.compute.projection.conditionning.ConditioningFactory;
import explorer.data.SourceAttrVal;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.rmi.Naming;
import java.rmi.RMISecurityManager;
import java.util.Vector;
import parameters.Parameters;

public class Test {
    public static void genereDistr(int[] classe, String file_radix) {
        int nbrun = 0;
        while (nbrun < 40) {
            int[] cross = Decoupe.nFold(classe, 10);
            String filename = new String(String.valueOf(file_radix) + ".CV_" + (nbrun + 1));
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(filename);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            PrintStream ps = new PrintStream(fos);
            int i = 0;
            while (i < classe.length) {
                if (cross[i] < 7) {
                    ps.println("0");
                } else {
                    ps.println("1");
                }
                ++i;
            }
            ps.close();
            ++nbrun;
        }
    }

    public static int[] loadGen(int nbelem, String filename) {
        int[] cross = new int[nbelem];
        try {
            FileInputStream fis = new FileInputStream(filename);
            DataInputStream dis = new DataInputStream(fis);
            int i = 0;
            while (i < nbelem) {
                String s = dis.readUTF();
                cross[i] = Integer.parseInt(s);
                ++i;
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return cross;
    }

    public static void test(int nbelem, SourceAttrVal dt, int[] classe) {
        PMKNNPCA_Boost acp0 = PMFactory.getSingleton().createPMKNNPCA_Boost(dt, ConditioningFactory.createConditioning(2, true));
        acp0.calculer(null);
    }

    public static void testclassic(int nbelem, SourceAttrVal dt, int[] classe, String output, String nameFic, int nbgroupes, int nbBoucles, Parameters par) {
        int verbose = 1;
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(output);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        PrintStream psout = new PrintStream(fos);
        CentralResult resultats = new CentralResult();
        try {
            String adresse = "rmi://localhost:1099/";
            if (System.getSecurityManager() == null) {
                System.setSecurityManager(new RMISecurityManager());
            }
            InterfaceTestACP acpBrut = null;
            InterfaceTestACP acpRed = null;
            InterfaceTestLDA lda = null;
            InterfaceTestARDp ardp = null;
            InterfaceTestARDp ardpDiff = null;
            InterfaceTestKnn kNN = null;
            InterfaceTestKnn kNNDiff = null;
            InterfaceTestLMNN lmnn = null;
            InterfaceTestKnnBoost kNNBoost = null;
            InterfaceTestKnnBoost kNNBoostDiff = null;
            InterfaceTestARDpBoost ardpBoost = null;
            InterfaceTestARDpBoost ardpBoostDiff = null;
            System.out.println("Connection aux serveurs...");
            if (par.getHostACP() == null) {
                acpBrut = new TestACP(dt, false, 0, "Brut");
                acpRed = new TestACP(dt, true, 2, "Red");
            } else {
                acpBrut = (InterfaceTestACP)Naming.lookup(String.valueOf(adresse) + "acpBrut");
                acpBrut.setParameters(dt, false, 0, "Brut");
                acpRed = (InterfaceTestACP)Naming.lookup(String.valueOf(adresse) + "acpRed");
                acpRed.setParameters(dt, true, 2, "Red");
            }
            if (par.getHostARDp() == null) {
                ardp = new TestARDp(dt, true, 2, "");
                ardpDiff = new TestARDp(dt, true, 2, "diff", 1.0f);
            } else {
                ardp = (InterfaceTestARDp)Naming.lookup(String.valueOf(adresse) + "ardp");
                ardp.setParameters(dt, true, 2, "", 0.0f);
                ardpDiff = (InterfaceTestARDp)Naming.lookup(String.valueOf(adresse) + "ardpDiff");
                ardpDiff.setParameters(dt, true, 2, "diff", 1.0f);
            }
            if (par.getHostARDpBoost() == null) {
                ardpBoost = new TestARDpBoost(dt, true, 2, "", 1);
                ardpBoostDiff = new TestARDpBoost(dt, true, 2, "diff", 1.0f, 1);
            } else {
                ardpBoost = (InterfaceTestARDpBoost)Naming.lookup(String.valueOf(adresse) + "ardpBoost");
                ardpBoost.setParameters(dt, true, 2, "", 0.0f, 1);
                ardpBoostDiff = (InterfaceTestARDpBoost)Naming.lookup(String.valueOf(adresse) + "ardpBoostDiff");
                ardpBoostDiff.setParameters(dt, true, 2, "diff", 1.0f, 1);
            }
            if (par.getHostKNNBoost() == null) {
                kNNBoost = new TestKnnBoost(dt, true, 2, "", 3);
                kNNBoostDiff = new TestKnnBoost(dt, true, 2, "diff", 1.0f, 3);
            } else {
                kNNBoost = (InterfaceTestKnnBoost)Naming.lookup(String.valueOf(adresse) + "knnBoost");
                kNNBoost.setParameters(dt, true, 2, "", 0.0f, 3);
                kNNBoostDiff = (InterfaceTestKnnBoost)Naming.lookup(String.valueOf(adresse) + "knnBoostDiff");
                kNNBoostDiff.setParameters(dt, true, 2, "diff", 1.0f, 3);
            }
            if (par.getHostLDA() == null) {
                lda = new TestLDA(dt, true, 2, "");
            } else {
                lda = (InterfaceTestLDA)Naming.lookup(String.valueOf(adresse) + "lda");
                lda.setParameters(dt, true, 2, "");
            }
            if (par.getHostKNN() == null) {
                kNN = new TestKnn(dt, true, 2, "");
                kNNDiff = new TestKnn(dt, true, 2, "diff", 1.0f);
            } else {
                kNN = (InterfaceTestKnn)Naming.lookup(String.valueOf(adresse) + "knn");
                kNN.setParameters(dt, true, 2, "", 0.0f);
                kNNDiff = (InterfaceTestKnn)Naming.lookup(String.valueOf(adresse) + "knnDiff");
                kNNDiff.setParameters(dt, true, 2, "diff", 1.0f);
            }
            if (par.getHostLMNN() == null) {
                lmnn = new TestLMNN(dt);
            } else {
                lmnn = (InterfaceTestLMNN)Naming.lookup(String.valueOf(adresse) + "lmnn");
                lmnn.setParameters(dt);
            }
            Vector<Thread> tabThread = new Vector<Thread>();
            int nbboucles = 0;
            while (nbboucles < nbBoucles) {
                int k;
                int j;
                int j2;
                int i;
                int[] cross = Decoupe.nFold(classe, nbgroupes);
                System.out.println("Run n: " + (nbboucles + 1));
                int nbg = 0;
                while (nbg < nbgroupes) {
                    System.out.println("Nb Groupe : " + (nbg + 1));
                    if (par.getKnnBrut() != null) {
                        i = 1;
                        while (i < par.getKnnBrut()[0] + 1) {
                            System.out.println("Pour ACP Brut avec knn = " + par.getKnnBrut()[i]);
                            tabThread.add(new TestACPExec(acpBrut, resultats, cross, nbg, par.getKnnBrut()[i], false));
                            ((Thread)tabThread.get(tabThread.size() - 1)).start();
                            ++i;
                        }
                    }
                    if (par.getKnnRed() != null) {
                        i = 1;
                        while (i < par.getKnnRed()[0] + 1) {
                            System.out.println("Pour ACP Reduite avec knn = " + par.getKnnRed()[i]);
                            tabThread.add(new TestACPExec(acpRed, resultats, cross, nbg, par.getKnnRed()[i], false));
                            ((Thread)tabThread.get(tabThread.size() - 1)).start();
                            ++i;
                        }
                    }
                    if (par.getKnnLDA() != null) {
                        i = 1;
                        while (i < par.getKnnLDA()[0] + 1) {
                            System.out.println("Pour LDA avec knn = " + par.getKnnLDA()[i]);
                            tabThread.add(new TestLDAExec(lda, resultats, cross, nbg, par.getKnnLDA()[i], false));
                            ((Thread)tabThread.get(tabThread.size() - 1)).start();
                            ++i;
                        }
                    }
                    if (par.getKnnARDp() != null || par.getKnnKNN() != null || par.getARDpdiff() != null || par.getKNNdiff() != null) {
                        int k2;
                        if (par.getKnnARDp() != null) {
                            i = 1;
                            while (i < par.getKnnARDp()[0] + 1) {
                                System.out.println("Pour ARDp avec knn = " + par.getKnnARDp()[i]);
                                k2 = 1;
                                while (k2 < par.getARDpSigmaMin()[0] + 1) {
                                    System.out.println("Pour ARDp avec SigmaMin = " + par.getARDpSigmaMin()[k2]);
                                    tabThread.add(new TestARDpExec(ardp, resultats, cross, nbg, par.getKnnARDp()[i], 0.0f, par.getARDpSigmaMin()[k2], false));
                                    ((Thread)tabThread.get(tabThread.size() - 1)).start();
                                    if (par.getARDpdiff()[0] != 1.0f || par.getARDpdiff()[1] != 0.0f) {
                                        j2 = 1;
                                        while ((float)j2 < par.getARDpdiff()[0] + 1.0f) {
                                            System.out.println("Pour ARDp avec diff = " + par.getARDpdiff()[j2]);
                                            tabThread.add(new TestARDpExec(ardpDiff, resultats, cross, nbg, par.getKnnARDp()[i], par.getARDpdiff()[j2], par.getARDpSigmaMin()[k2], false));
                                            ((Thread)tabThread.get(tabThread.size() - 1)).start();
                                            ++j2;
                                        }
                                    }
                                    ++k2;
                                }
                                ++i;
                            }
                        }
                        if (par.getKnnKNN() != null) {
                            i = 1;
                            while (i < par.getKnnKNN()[0] + 1) {
                                System.out.println("Pour KnnACP avec knn = " + par.getKnnKNN()[i]);
                                k2 = 1;
                                while (k2 < par.getKNNMin()[0] + 1) {
                                    System.out.println("Pour KnnACP avec knnMin = " + par.getKNNMin()[k2]);
                                    tabThread.add(new TestKnnExec(kNN, resultats, cross, nbg, par.getKnnKNN()[i], 0.0f, par.getKNNMin()[k2], false));
                                    ((Thread)tabThread.get(tabThread.size() - 1)).start();
                                    if (par.getKNNdiff()[0] != 1.0f || par.getKNNdiff()[1] != 0.0f) {
                                        j2 = 1;
                                        while ((float)j2 < par.getKNNdiff()[0] + 1.0f) {
                                            System.out.println("Pour KnnACP avec diff = " + par.getKNNdiff()[j2]);
                                            tabThread.add(new TestKnnExec(kNNDiff, resultats, cross, nbg, par.getKnnKNN()[i], par.getKNNdiff()[j2], par.getKNNMin()[k2], false));
                                            ((Thread)tabThread.get(tabThread.size() - 1)).start();
                                            ++j2;
                                        }
                                    }
                                    ++k2;
                                }
                                ++i;
                            }
                        }
                    }
                    if (par.getKnnARDpBoost() != null || par.getKnnKNNBoost() != null || par.getARDpBoostdiff() != null || par.getKNNBoostdiff() != null) {
                        int k3;
                        int i2;
                        int a;
                        if (par.getKnnARDpBoost() != null && par.gettArdpBoost() != null) {
                            a = 1;
                            while (a < par.gettArdpBoost()[0] + 1) {
                                System.out.println("Pour ARDpBoost avec T (nb Tours) = " + par.gettArdpBoost()[a]);
                                i2 = 1;
                                while (i2 < par.getKnnARDpBoost()[0] + 1) {
                                    System.out.println("Pour ARDpBoost avec knn = " + par.getKnnARDpBoost()[i2]);
                                    k3 = 1;
                                    while (k3 < par.getARDpBoostSigmaMin()[0] + 1) {
                                        System.out.println("Pour ARDpBoost avec SigmaMin = " + par.getARDpBoostSigmaMin()[k3]);
                                        j = 1;
                                        while ((float)j < par.getARDpBoostdiff()[0] + 1.0f) {
                                            tabThread.add(new TestARDpBoostExec(ardpBoost, resultats, cross, nbg, par.getKnnARDpBoost()[i2], 0.0f, par.getARDpBoostSigmaMin()[k3], false, par.gettArdpBoost()[a]));
                                            ((Thread)tabThread.get(tabThread.size() - 1)).start();
                                            if (par.getARDpBoostdiff()[0] != 1.0f || par.getARDpBoostdiff()[1] != 0.0f) {
                                                System.out.println("Pour ARDpBoost avec diff = " + par.getARDpBoostdiff()[j]);
                                                tabThread.add(new TestARDpBoostExec(ardpBoostDiff, resultats, cross, nbg, par.getKnnARDpBoost()[i2], par.getARDpBoostdiff()[j], par.getARDpBoostSigmaMin()[k3], false, par.gettArdpBoost()[a]));
                                                ((Thread)tabThread.get(tabThread.size() - 1)).start();
                                            }
                                            ++j;
                                        }
                                        ++k3;
                                    }
                                    ++i2;
                                }
                                ++a;
                            }
                        }
                        if (par.getKnnKNNBoost() != null && par.gettKNNBoost() != null) {
                            a = 1;
                            while (a < par.gettKNNBoost()[0] + 1) {
                                System.out.println("Pour KnnACPBoost avec T (nb Tours) = " + par.gettKNNBoost()[a]);
                                i2 = 1;
                                while (i2 < par.getKnnKNNBoost()[0] + 1) {
                                    System.out.println("Pour KnnACPBoost avec knn = " + par.getKnnKNNBoost()[i2]);
                                    k3 = 1;
                                    while (k3 < par.getKNNBoostMin()[0] + 1) {
                                        System.out.println("Pour KnnACPBoost avec knnMin = " + par.getKNNBoostMin()[k3]);
                                        tabThread.add(new TestKnnBoostExec(kNNBoost, resultats, cross, nbg, par.getKnnKNNBoost()[i2], 0.0f, par.getKNNBoostMin()[k3], false, par.gettKNNBoost()[a]));
                                        ((Thread)tabThread.get(tabThread.size() - 1)).start();
                                        if (par.getKNNBoostdiff()[0] != 1.0f || par.getKNNBoostdiff()[1] != 0.0f) {
                                            j = 1;
                                            while ((float)j < par.getKNNBoostdiff()[0] + 1.0f) {
                                                System.out.println("Pour KnnACPBoost avec diff = " + par.getKNNBoostdiff()[j]);
                                                tabThread.add(new TestKnnBoostExec(kNNBoostDiff, resultats, cross, nbg, par.getKnnKNNBoost()[i2], par.getKNNBoostdiff()[j], par.getKNNBoostMin()[k3], false, par.gettKNNBoost()[a]));
                                                ((Thread)tabThread.get(tabThread.size() - 1)).start();
                                                ++j;
                                            }
                                        }
                                        ++k3;
                                    }
                                    ++i2;
                                }
                                ++a;
                            }
                        }
                    }
                    if (par.getKnnLMNN() != null) {
                        i = 1;
                        while (i < par.getKnnLMNN()[0] + 1) {
                            System.out.println("Pour LMNN avec knn = " + par.getKnnLMNN()[i]);
                            tabThread.add(new TestLMNNExec(lmnn, resultats, cross, nbg, par.getKnnLMNN()[i], false));
                            ((Thread)tabThread.get(tabThread.size() - 1)).start();
                            ++i;
                        }
                    }
                    System.out.println();
                    ++nbg;
                }
                int i3 = 0;
                while (i3 < tabThread.size()) {
                    ((Thread)tabThread.get(i3)).join();
                    ++i3;
                }
                ResultDisplay resdisplay = new ResultDisplay(resultats, psout, verbose);
                System.out.println("resultats:");
                resdisplay.afficherln("--------------------------------------------------------", psout, verbose);
                resdisplay.afficherln("Source : " + nameFic, psout, verbose);
                resdisplay.afficherln("nbgroupes=" + nbgroupes, psout, verbose);
                resdisplay.afficherln("nbBoucles=" + nbBoucles, psout, verbose);
                resdisplay.afficherln("--------------------------------------------------------", psout, verbose);
                if (par.getKnnBrut() != null) {
                    i = 1;
                    while (i < par.getKnnBrut()[0] + 1) {
                        String res = "";
                        res = "Knn = " + par.getKnnBrut()[i] + " ACP non centree, non r\u00e9duite :";
                        res = String.valueOf(res) + resdisplay.formatFloat(resdisplay.getMoyenne("acpBrutknn" + par.getKnnBrut()[i], "TauxTest"));
                        res = String.valueOf(res) + " +/- " + resdisplay.formatFloat(resdisplay.getEcartType("acpBrutknn" + par.getKnnBrut()[i], "TauxTest"));
                        res = String.valueOf(res) + "  ( " + resdisplay.formatFloat(resdisplay.getMoyenne("acpBrutknn" + par.getKnnBrut()[i], "TauxApp"));
                        res = String.valueOf(res) + " +/- " + resdisplay.formatFloat(resdisplay.getEcartType("acpBrutknn" + par.getKnnBrut()[i], "TauxApp")) + " )";
                        resdisplay.afficherln(res, psout, verbose);
                        res = "Training time : " + resdisplay.formatFloat(resdisplay.getMoyenne("acpBrutknn" + par.getKnnBrut()[i], "Time"));
                        res = String.valueOf(res) + " +/- " + resdisplay.formatFloat(resdisplay.getEcartType("acpBrutknn" + par.getKnnBrut()[i], "Time"));
                        resdisplay.afficherln(res, psout, verbose);
                        ++i;
                    }
                }
                if (par.getKnnRed() != null) {
                    i = 1;
                    while (i < par.getKnnRed()[0] + 1) {
                        String res = "";
                        res = "Knn = " + par.getKnnRed()[i] + " ACP centree, r\u00e9duite :";
                        res = String.valueOf(res) + resdisplay.formatFloat(resdisplay.getMoyenne("acpRedknn" + par.getKnnRed()[i], "TauxTest"));
                        res = String.valueOf(res) + " +/- " + resdisplay.formatFloat(resdisplay.getEcartType("acpRedknn" + par.getKnnRed()[i], "TauxTest"));
                        res = String.valueOf(res) + "  ( " + resdisplay.formatFloat(resdisplay.getMoyenne("acpRedknn" + par.getKnnRed()[i], "TauxApp"));
                        res = String.valueOf(res) + " +/- " + resdisplay.formatFloat(resdisplay.getEcartType("acpRedknn" + par.getKnnRed()[i], "TauxApp")) + " )";
                        resdisplay.afficherln(res, psout, verbose);
                        res = "Training time : " + resdisplay.formatFloat(resdisplay.getMoyenne("acpRedknn" + par.getKnnRed()[i], "Time"));
                        res = String.valueOf(res) + " +/- " + resdisplay.formatFloat(resdisplay.getEcartType("acpRedknn" + par.getKnnRed()[i], "Time"));
                        resdisplay.afficherln(res, psout, verbose);
                        ++i;
                    }
                }
                if (par.getKnnLDA() != null) {
                    i = 1;
                    while (i < par.getKnnLDA()[0] + 1) {
                        String res = "";
                        res = "Knn = " + par.getKnnLDA()[i] + " " + "LDA :";
                        res = String.valueOf(res) + resdisplay.formatFloat(resdisplay.getMoyenne("lda knn " + par.getKnnLDA()[i], "TauxTest"));
                        res = String.valueOf(res) + " +/- " + resdisplay.formatFloat(resdisplay.getEcartType("lda knn " + par.getKnnLDA()[i], "TauxTest"));
                        res = String.valueOf(res) + "  ( " + resdisplay.formatFloat(resdisplay.getMoyenne("lda knn " + par.getKnnLDA()[i], "TauxApp"));
                        res = String.valueOf(res) + " +/- " + resdisplay.formatFloat(resdisplay.getEcartType("lda knn " + par.getKnnLDA()[i], "TauxApp")) + " )";
                        resdisplay.afficherln(res, psout, verbose);
                        res = "Training time : " + resdisplay.formatFloat(resdisplay.getMoyenne("lda knn " + par.getKnnLDA()[i], "Time"));
                        res = String.valueOf(res) + " +/- " + resdisplay.formatFloat(resdisplay.getEcartType("lda knn " + par.getKnnLDA()[i], "Time"));
                        resdisplay.afficherln(res, psout, verbose);
                        ++i;
                    }
                }
                if (par.getKnnARDp() != null || par.getKnnKNN() != null || par.getARDpdiff() != null || par.getKNNdiff() != null) {
                    if (par.getKnnARDp() != null) {
                        if (par.getARDpSigmaMin() != null) {
                            k = 1;
                            while (k < par.getARDpSigmaMin()[0] + 1) {
                                int i4 = 1;
                                while (i4 < par.getKnnARDp()[0] + 1) {
                                    String res = "";
                                    res = "Knn = " + par.getKnnARDp()[i4] + " ARDp " + ":  (ARDpDiff=" + 0.0f + ")";
                                    res = String.valueOf(res) + resdisplay.formatFloat(resdisplay.getMoyenne("ardpardpDiff0.0knn" + par.getKnnARDp()[i4] + "SigmaMin" + par.getARDpSigmaMin()[k], "Taux"));
                                    res = String.valueOf(res) + " +/- " + resdisplay.formatFloat(resdisplay.getEcartType("ardpardpDiff0.0knn" + par.getKnnARDp()[i4] + "SigmaMin" + par.getARDpSigmaMin()[k], "Taux"));
                                    resdisplay.afficherln(res, psout, verbose);
                                    res = "Training time : " + resdisplay.formatFloat(resdisplay.getMoyenne("ardpardpDiff0.0knn" + par.getKnnARDp()[i4] + "SigmaMin" + par.getARDpSigmaMin()[k], "Time"));
                                    res = String.valueOf(res) + " +/- " + resdisplay.formatFloat(resdisplay.getEcartType("ardpardpDiff0.0knn" + par.getKnnARDp()[i4] + "SigmaMin" + par.getARDpSigmaMin()[k], "Time"));
                                    resdisplay.afficherln(res, psout, verbose);
                                    if (par.getARDpdiff()[0] != 1.0f || par.getARDpdiff()[1] != 0.0f) {
                                        j = 1;
                                        while ((float)j < par.getARDpdiff()[0] + 1.0f) {
                                            res = "";
                                            res = "Knn = " + par.getKnnARDp()[i4] + " ARDp " + "diff" + ":  (ARDpDiff=" + par.getARDpdiff()[j] + ")";
                                            res = String.valueOf(res) + resdisplay.formatFloat(resdisplay.getMoyenne("ardpdiffardpDiff" + par.getARDpdiff()[j] + "knn" + par.getKnnARDp()[i4] + "SigmaMin" + par.getARDpSigmaMin()[k], "Taux"));
                                            res = String.valueOf(res) + " +/- " + resdisplay.formatFloat(resdisplay.getEcartType("ardpdiffardpDiff" + par.getARDpdiff()[j] + "knn" + par.getKnnARDp()[i4] + "SigmaMin" + par.getARDpSigmaMin()[k], "Taux"));
                                            resdisplay.afficherln(res, psout, verbose);
                                            res = "Training time : " + resdisplay.formatFloat(resdisplay.getMoyenne("ardpdiffardpDiff" + par.getARDpdiff()[j] + "knn" + par.getKnnARDp()[i4] + "SigmaMin" + par.getARDpSigmaMin()[k], "Time"));
                                            res = String.valueOf(res) + " +/- " + resdisplay.formatFloat(resdisplay.getEcartType("ardpdiffardpDiff" + par.getARDpdiff()[j] + "knn" + par.getKnnARDp()[i4] + "SigmaMin" + par.getARDpSigmaMin()[k], "Time"));
                                            resdisplay.afficherln(res, psout, verbose);
                                            ++j;
                                        }
                                    }
                                    ++i4;
                                }
                                ++k;
                            }
                        } else {
                            i = 1;
                            while (i < par.getKnnARDp()[0] + 1) {
                                String res = "";
                                res = "Knn = " + par.getKnnARDp()[i] + " ARDp " + ":  (ARDpDiff=" + 0.0f + ")";
                                res = String.valueOf(res) + resdisplay.formatFloat(resdisplay.getMoyenne("ardpardpDiff0.0knn" + par.getKnnARDp()[i] + "SigmaMin" + 0, "Taux"));
                                res = String.valueOf(res) + " +/- " + resdisplay.formatFloat(resdisplay.getEcartType("ardpardpDiff0.0knn" + par.getKnnARDp()[i] + "SigmaMin" + 0, "Taux"));
                                resdisplay.afficherln(res, psout, verbose);
                                res = "Training time : " + resdisplay.formatFloat(resdisplay.getMoyenne("ardpardpDiff0.0knn" + par.getKnnARDp()[i] + "SigmaMin" + 0, "Time"));
                                res = String.valueOf(res) + " +/- " + resdisplay.formatFloat(resdisplay.getEcartType("ardpardpDiff0.0knn" + par.getKnnARDp()[i] + "SigmaMin" + 0, "Time"));
                                resdisplay.afficherln(res, psout, verbose);
                                if (par.getARDpdiff()[0] != 1.0f || par.getARDpdiff()[1] != 0.0f) {
                                    j2 = 1;
                                    while ((float)j2 < par.getARDpdiff()[0] + 1.0f) {
                                        res = "";
                                        res = "Knn = " + par.getKnnARDp()[i] + " ARDp " + "diff" + ":  (ARDpDiff=" + par.getARDpdiff()[j2] + ")";
                                        res = String.valueOf(res) + resdisplay.formatFloat(resdisplay.getMoyenne("ardpdiffardpDiff" + par.getARDpdiff()[j2] + "knn" + par.getKnnARDp()[i] + "SigmaMin" + 0, "Taux"));
                                        res = String.valueOf(res) + " +/- " + resdisplay.formatFloat(resdisplay.getEcartType("ardpdiffardpDiff" + par.getARDpdiff()[j2] + "knn" + par.getKnnARDp()[i] + "SigmaMin" + 0, "Taux"));
                                        resdisplay.afficherln(res, psout, verbose);
                                        res = "Training time : " + resdisplay.formatFloat(resdisplay.getMoyenne("ardpdiffardpDiff" + par.getARDpdiff()[j2] + "knn" + par.getKnnARDp()[i] + "SigmaMin" + 0, "Time"));
                                        res = String.valueOf(res) + " +/- " + resdisplay.formatFloat(resdisplay.getEcartType("ardpdiffardpDiff" + par.getARDpdiff()[j2] + "knn" + par.getKnnARDp()[i] + "SigmaMin" + 0, "Time"));
                                        resdisplay.afficherln(res, psout, verbose);
                                        ++j2;
                                    }
                                }
                                ++i;
                            }
                        }
                    }
                    if (par.getKnnKNN() != null) {
                        if (par.getKNNMin() != null) {
                            k = 1;
                            while (k < par.getKNNMin()[0] + 1) {
                                int i5 = 1;
                                while (i5 < par.getKnnKNN()[0] + 1) {
                                    String res = "Knn = " + par.getKnnKNN()[i5] + " knn :  (knnMax = 11 , knnDiff=" + 0.0f + ")";
                                    res = String.valueOf(res) + resdisplay.formatFloat(resdisplay.getMoyenne("knnknndiff =0.0knn " + par.getKnnKNN()[i5] + " KnnMin : " + par.getKNNMin()[k], "Taux"));
                                    res = String.valueOf(res) + " +/- " + resdisplay.formatFloat(resdisplay.getEcartType("knnknndiff =0.0knn " + par.getKnnKNN()[i5] + " KnnMin : " + par.getKNNMin()[k], "Taux"));
                                    resdisplay.afficherln(res, psout, verbose);
                                    res = "Training time : " + resdisplay.formatFloat(resdisplay.getMoyenne("knnknndiff =0.0knn " + par.getKnnKNN()[i5] + " KnnMin : " + par.getKNNMin()[k], "Time"));
                                    res = String.valueOf(res) + " +/- " + resdisplay.formatFloat(resdisplay.getEcartType("knnknndiff =0.0knn " + par.getKnnKNN()[i5] + " KnnMin : " + par.getKNNMin()[k], "Time"));
                                    resdisplay.afficherln(res, psout, verbose);
                                    if (par.getKNNdiff()[0] != 1.0f || par.getKNNdiff()[1] != 0.0f) {
                                        j = 1;
                                        while ((float)j < par.getKNNdiff()[0] + 1.0f) {
                                            res = "";
                                            res = "Knn = " + par.getKnnKNN()[i5] + " knn diff:  (knnMax = 11 , knnDiff=" + par.getKNNdiff()[j] + ")";
                                            res = String.valueOf(res) + resdisplay.formatFloat(resdisplay.getMoyenne("knndiffknndiff =" + par.getKNNdiff()[j] + "knn " + par.getKnnKNN()[i5] + " KnnMin : " + par.getKNNMin()[k], "Taux"));
                                            res = String.valueOf(res) + " +/- " + resdisplay.formatFloat(resdisplay.getEcartType("knndiffknndiff =" + par.getKNNdiff()[j] + "knn " + par.getKnnKNN()[i5] + " KnnMin : " + par.getKNNMin()[k], "Taux"));
                                            res = String.valueOf(res) + "\n Training time : " + resdisplay.formatFloat(resdisplay.getMoyenne("knndiffknndiff =" + par.getKNNdiff()[j] + "knn " + par.getKnnKNN()[i5] + " KnnMin : " + par.getKNNMin()[k], "Time"));
                                            res = String.valueOf(res) + " +/- " + resdisplay.formatFloat(resdisplay.getEcartType("knndiffknndiff =" + par.getKNNdiff()[j] + "knn " + par.getKnnKNN()[i5] + " KnnMin : " + par.getKNNMin()[k], "Time"));
                                            resdisplay.afficherln(res, psout, verbose);
                                            ++j;
                                        }
                                    }
                                    ++i5;
                                }
                                ++k;
                            }
                        } else {
                            i = 1;
                            while (i < par.getKnnKNN()[0] + 1) {
                                String res = "Knn = " + par.getKnnKNN()[i] + " knn :  (knnMax = 11 , knnDiff=" + 0.0f + ")";
                                res = String.valueOf(res) + resdisplay.formatFloat(resdisplay.getMoyenne("knnknndiff =0.0knn " + par.getKnnKNN()[i] + " KnnMin : " + 1, "Taux"));
                                res = String.valueOf(res) + " +/- " + resdisplay.formatFloat(resdisplay.getEcartType("knnknndiff =0.0knn " + par.getKnnKNN()[i] + " KnnMin : " + 1, "Taux"));
                                res = String.valueOf(res) + "\n Training time : " + resdisplay.formatFloat(resdisplay.getMoyenne("knnknndiff =0.0knn " + par.getKnnKNN()[i] + " KnnMin : " + 1, "Time"));
                                res = String.valueOf(res) + " +/- " + resdisplay.formatFloat(resdisplay.getEcartType("knnknndiff =0.0knn " + par.getKnnKNN()[i] + " KnnMin : " + 1, "Time"));
                                resdisplay.afficherln(res, psout, verbose);
                                if (par.getKNNdiff()[0] != 1.0f || par.getKNNdiff()[1] != 0.0f) {
                                    int j3 = 1;
                                    while ((float)j3 < par.getKNNdiff()[0] + 1.0f) {
                                        res = "";
                                        res = "Knn = " + par.getKnnKNN()[i] + " knn diff:  (knnMax = 11 , knnDiff=" + par.getKNNdiff()[j3] + ")";
                                        res = String.valueOf(res) + resdisplay.formatFloat(resdisplay.getMoyenne("knndiffknndiff =" + par.getKNNdiff()[j3] + "knn " + par.getKnnKNN()[i] + " KnnMin : " + 1, "Taux"));
                                        res = String.valueOf(res) + " +/- " + resdisplay.formatFloat(resdisplay.getEcartType("knndiffknndiff =" + par.getKNNdiff()[j3] + "knn " + par.getKnnKNN()[i] + " KnnMin : " + 1, "Taux"));
                                        res = String.valueOf(res) + "\n Training time : " + resdisplay.formatFloat(resdisplay.getMoyenne("knndiffknndiff =" + par.getKNNdiff()[j3] + "knn " + par.getKnnKNN()[i] + " KnnMin : " + 1, "Time"));
                                        res = String.valueOf(res) + " +/- " + resdisplay.formatFloat(resdisplay.getEcartType("knndiffknndiff =" + par.getKNNdiff()[j3] + "knn " + par.getKnnKNN()[i] + " KnnMin : " + 1, "Time"));
                                        resdisplay.afficherln(res, psout, verbose);
                                        ++j3;
                                    }
                                }
                                ++i;
                            }
                        }
                    }
                }
                if (par.getKnnARDpBoost() != null || par.getKnnKNNBoost() != null || par.getARDpBoostdiff() != null || par.getKNNBoostdiff() != null) {
                    if (par.getKnnARDpBoost() != null) {
                        if (par.getARDpBoostSigmaMin() != null) {
                            k = 1;
                            while (k < par.getARDpBoostSigmaMin()[0] + 1) {
                                int i6 = 1;
                                while (i6 < par.getKnnARDpBoost()[0] + 1) {
                                    String res = "";
                                    res = "Knn = " + par.getKnnARDpBoost()[i6] + " ARDpBoost " + ":  (ARDpDiff=" + 0.0f + ")";
                                    res = String.valueOf(res) + resdisplay.formatFloat(resdisplay.getMoyenne("ardpBoostardpDiff0.0knn" + par.getKnnARDpBoost()[i6] + "SigmaMin" + par.getARDpBoostSigmaMin()[k], "Taux"));
                                    res = String.valueOf(res) + " +/- " + resdisplay.formatFloat(resdisplay.getEcartType("ardpBoostardpDiff0.0knn" + par.getKnnARDpBoost()[i6] + "SigmaMin" + par.getARDpBoostSigmaMin()[k], "Taux"));
                                    resdisplay.afficherln(res, psout, verbose);
                                    res = "Training time : " + resdisplay.formatFloat(resdisplay.getMoyenne("ardpBoostardpDiff0.0knn" + par.getKnnARDpBoost()[i6] + "SigmaMin" + par.getARDpBoostSigmaMin()[k], "Time"));
                                    res = String.valueOf(res) + " +/- " + resdisplay.formatFloat(resdisplay.getEcartType("ardpBoostardpDiff0.0knn" + par.getKnnARDpBoost()[i6] + "SigmaMin" + par.getARDpBoostSigmaMin()[k], "Time"));
                                    resdisplay.afficherln(res, psout, verbose);
                                    if (par.getARDpBoostdiff()[0] != 1.0f || par.getARDpBoostdiff()[1] != 0.0f) {
                                        j = 1;
                                        while ((float)j < par.getARDpBoostdiff()[0] + 1.0f) {
                                            res = "";
                                            res = "Knn = " + par.getKnnARDpBoost()[i6] + " ARDpBoost " + "diff" + ":  (ARDpDiff=" + par.getARDpBoostdiff()[j] + ")";
                                            res = String.valueOf(res) + resdisplay.formatFloat(resdisplay.getMoyenne("ardpBoostdiffardpDiff" + par.getARDpBoostdiff()[j] + "knn" + par.getKnnARDpBoost()[i6] + "SigmaMin" + par.getARDpBoostSigmaMin()[k], "Taux"));
                                            res = String.valueOf(res) + " +/- " + resdisplay.formatFloat(resdisplay.getEcartType("ardpBoostdiffardpDiff" + par.getARDpBoostdiff()[j] + "knn" + par.getKnnARDpBoost()[i6] + "SigmaMin" + par.getARDpBoostSigmaMin()[k], "Taux"));
                                            resdisplay.afficherln(res, psout, verbose);
                                            res = "Training time : " + resdisplay.formatFloat(resdisplay.getMoyenne("ardpBoostdiffardpDiff" + par.getARDpBoostdiff()[j] + "knn" + par.getKnnARDpBoost()[i6] + "SigmaMin" + par.getARDpBoostSigmaMin()[k], "Time"));
                                            res = String.valueOf(res) + " +/- " + resdisplay.formatFloat(resdisplay.getEcartType("ardpBoostdiffardpDiff" + par.getARDpBoostdiff()[j] + "knn" + par.getKnnARDpBoost()[i6] + "SigmaMin" + par.getARDpBoostSigmaMin()[k], "Time"));
                                            resdisplay.afficherln(res, psout, verbose);
                                            ++j;
                                        }
                                    }
                                    ++i6;
                                }
                                ++k;
                            }
                        } else {
                            i = 1;
                            while (i < par.getKnnARDpBoost()[0] + 1) {
                                String res = "";
                                res = "Knn = " + par.getKnnARDpBoost()[i] + " ARDpBoost " + ":  (ARDpDiff=" + 0.0f + ")";
                                res = String.valueOf(res) + resdisplay.formatFloat(resdisplay.getMoyenne("ardpBoostardpDiff0.0knn" + par.getKnnARDpBoost()[i] + "SigmaMin" + 0, "Taux"));
                                res = String.valueOf(res) + " +/- " + resdisplay.formatFloat(resdisplay.getEcartType("ardpBoostardpDiff0.0knn" + par.getKnnARDpBoost()[i] + "SigmaMin" + 0, "Taux"));
                                resdisplay.afficherln(res, psout, verbose);
                                res = "Training time : " + resdisplay.formatFloat(resdisplay.getMoyenne("ardpBoostardpDiff0.0knn" + par.getKnnARDpBoost()[i] + "SigmaMin" + 0, "Time"));
                                res = String.valueOf(res) + " +/- " + resdisplay.formatFloat(resdisplay.getEcartType("ardpBoostardpDiff0.0knn" + par.getKnnARDpBoost()[i] + "SigmaMin" + 0, "Time"));
                                resdisplay.afficherln(res, psout, verbose);
                                if (par.getARDpBoostdiff()[0] != 1.0f || par.getARDpBoostdiff()[1] != 0.0f) {
                                    int j4 = 1;
                                    while ((float)j4 < par.getARDpBoostdiff()[0] + 1.0f) {
                                        res = "";
                                        res = "Knn = " + par.getKnnARDpBoost()[i] + " ARDpBoost " + "diff" + ":  (ARDpDiff=" + par.getARDpBoostdiff()[j4] + ")";
                                        res = String.valueOf(res) + resdisplay.formatFloat(resdisplay.getMoyenne("ardpBoostdiffardpDiff" + par.getARDpBoostdiff()[j4] + "knn" + par.getKnnARDpBoost()[i] + "SigmaMin" + 0, "Taux"));
                                        res = String.valueOf(res) + " +/- " + resdisplay.formatFloat(resdisplay.getEcartType("ardpBoostdiffardpDiff" + par.getARDpBoostdiff()[j4] + "knn" + par.getKnnARDpBoost()[i] + "SigmaMin" + 0, "Taux"));
                                        resdisplay.afficherln(res, psout, verbose);
                                        res = "Training time : " + resdisplay.formatFloat(resdisplay.getMoyenne("ardpBoostdiffardpDiff" + par.getARDpBoostdiff()[j4] + "knn" + par.getKnnARDpBoost()[i] + "SigmaMin" + 0, "Time"));
                                        res = String.valueOf(res) + " +/- " + resdisplay.formatFloat(resdisplay.getEcartType("ardpBoostdiffardpDiff" + par.getARDpBoostdiff()[j4] + "knn" + par.getKnnARDpBoost()[i] + "SigmaMin" + 0, "Time"));
                                        resdisplay.afficherln(res, psout, verbose);
                                        ++j4;
                                    }
                                }
                                ++i;
                            }
                        }
                    }
                    if (par.getKnnKNNBoost() != null) {
                        if (par.getKNNBoostMin() != null) {
                            k = 1;
                            while (k < par.getKNNBoostMin()[0] + 1) {
                                int i7 = 1;
                                while (i7 < par.getKnnKNNBoost()[0] + 1) {
                                    String res = "Knn = " + par.getKnnKNNBoost()[i7] + " knnBoost :  (knnMax = 11 , knnDiff=" + 0.0f + ")";
                                    res = String.valueOf(res) + resdisplay.formatFloat(resdisplay.getMoyenne("knnBoostknndiff =0.0knn " + par.getKnnKNNBoost()[i7] + " KnnMin : " + par.getKNNBoostMin()[k], "Taux"));
                                    res = String.valueOf(res) + " +/- " + resdisplay.formatFloat(resdisplay.getEcartType("knnBoostknndiff =0.0knn " + par.getKnnKNNBoost()[i7] + " KnnMin : " + par.getKNNBoostMin()[k], "Taux"));
                                    resdisplay.afficherln(res, psout, verbose);
                                    res = "Training time : " + resdisplay.formatFloat(resdisplay.getMoyenne("knnBoostknndiff =0.0knn " + par.getKnnKNNBoost()[i7] + " KnnMin : " + par.getKNNBoostMin()[k], "Time"));
                                    res = String.valueOf(res) + " +/- " + resdisplay.formatFloat(resdisplay.getEcartType("knnBoostknndiff =0.0knn " + par.getKnnKNNBoost()[i7] + " KnnMin : " + par.getKNNBoostMin()[k], "Time"));
                                    resdisplay.afficherln(res, psout, verbose);
                                    if (par.getKNNBoostdiff()[0] != 1.0f || par.getKNNBoostdiff()[1] != 0.0f) {
                                        j = 1;
                                        while ((float)j < par.getKNNBoostdiff()[0] + 1.0f) {
                                            res = "";
                                            res = "Knn = " + par.getKnnKNNBoost()[i7] + " knnBoost diff:  (knnMax = 11 , knnDiff=" + par.getKNNBoostdiff()[j] + ")";
                                            res = String.valueOf(res) + resdisplay.formatFloat(resdisplay.getMoyenne("knnBoostdiffknndiff =" + par.getKNNBoostdiff()[j] + "knn " + par.getKnnKNNBoost()[i7] + " KnnMin : " + par.getKNNBoostMin()[k], "Taux"));
                                            res = String.valueOf(res) + " +/- " + resdisplay.formatFloat(resdisplay.getEcartType("knnBoostdiffknndiff =" + par.getKNNBoostdiff()[j] + "knn " + par.getKnnKNNBoost()[i7] + " KnnMin : " + par.getKNNBoostMin()[k], "Taux"));
                                            res = String.valueOf(res) + "\n Training time : " + resdisplay.formatFloat(resdisplay.getMoyenne("knnBoostdiffknndiff =" + par.getKNNBoostdiff()[j] + "knn " + par.getKnnKNNBoost()[i7] + " KnnMin : " + par.getKNNBoostMin()[k], "Time"));
                                            res = String.valueOf(res) + " +/- " + resdisplay.formatFloat(resdisplay.getEcartType("knnBoostdiffknndiff =" + par.getKNNBoostdiff()[j] + "knn " + par.getKnnKNNBoost()[i7] + " KnnMin : " + par.getKNNBoostMin()[k], "Time"));
                                            resdisplay.afficherln(res, psout, verbose);
                                            ++j;
                                        }
                                    }
                                    ++i7;
                                }
                                ++k;
                            }
                        } else {
                            i = 1;
                            while (i < par.getKnnKNNBoost()[0] + 1) {
                                String res = "Knn = " + par.getKnnKNNBoost()[i] + " knnBoost :  (knnMax = 11 , knnDiff=" + 0.0f + ")";
                                res = String.valueOf(res) + resdisplay.formatFloat(resdisplay.getMoyenne("knnBoostknndiff =0.0knn " + par.getKnnKNNBoost()[i] + " KnnMin : " + 1, "Taux"));
                                res = String.valueOf(res) + " +/- " + resdisplay.formatFloat(resdisplay.getEcartType("knnBoostknndiff =0.0knn " + par.getKnnKNNBoost()[i] + " KnnMin : " + 1, "Taux"));
                                res = String.valueOf(res) + "\n Training time : " + resdisplay.formatFloat(resdisplay.getMoyenne("knnknndiff =0.0knn " + par.getKnnKNNBoost()[i] + " KnnMin : " + 1, "Time"));
                                res = String.valueOf(res) + " +/- " + resdisplay.formatFloat(resdisplay.getEcartType("knnBoostknndiff =0.0knn " + par.getKnnKNNBoost()[i] + " KnnMin : " + 1, "Time"));
                                resdisplay.afficherln(res, psout, verbose);
                                if (par.getKNNBoostdiff()[0] != 1.0f || par.getKNNBoostdiff()[1] != 0.0f) {
                                    int j5 = 1;
                                    while ((float)j5 < par.getKNNBoostdiff()[0] + 1.0f) {
                                        res = "";
                                        res = "Knn = " + par.getKnnKNNBoost()[i] + " knnBoost diff:  (knnMax = 11 , knnDiff=" + par.getKNNBoostdiff()[j5] + ")";
                                        res = String.valueOf(res) + resdisplay.formatFloat(resdisplay.getMoyenne("knnBoostdiffknndiff =" + par.getKNNBoostdiff()[j5] + "knn " + par.getKnnKNNBoost()[i] + " KnnMin : " + 1, "Taux"));
                                        res = String.valueOf(res) + " +/- " + resdisplay.formatFloat(resdisplay.getEcartType("knnBoostdiffknndiff =" + par.getKNNBoostdiff()[j5] + "knn " + par.getKnnKNNBoost()[i] + " KnnMin : " + 1, "Taux"));
                                        res = String.valueOf(res) + "\n Training time : " + resdisplay.formatFloat(resdisplay.getMoyenne("knndiffknndiff =" + par.getKNNBoostdiff()[j5] + "knn " + par.getKnnKNNBoost()[i] + " KnnMin : " + 1, "Time"));
                                        res = String.valueOf(res) + " +/- " + resdisplay.formatFloat(resdisplay.getEcartType("knnBoostdiffknndiff =" + par.getKNNBoostdiff()[j5] + "knn " + par.getKnnKNNBoost()[i] + " KnnMin : " + 1, "Time"));
                                        resdisplay.afficherln(res, psout, verbose);
                                        ++j5;
                                    }
                                }
                                ++i;
                            }
                        }
                    }
                }
                if (par.getKnnLMNN() != null) {
                    i = 1;
                    while (i < par.getKnnLMNN()[0] + 1) {
                        String res = "";
                        res = "Knn = " + par.getKnnLMNN()[i];
                        res = String.valueOf(res) + "\nLMNN Euclidean : " + resdisplay.formatFloat(resdisplay.getMoyenne("LMNN Euclidean, knn" + par.getKnnLMNN()[i], "TauxTesting"));
                        res = String.valueOf(res) + " +/- " + resdisplay.formatFloat(resdisplay.getEcartType("LMNN Euclidean, knn" + par.getKnnLMNN()[i], "TauxTesting"));
                        res = String.valueOf(res) + "  ( " + resdisplay.formatFloat(resdisplay.getMoyenne("LMNN Euclidean, knn" + par.getKnnLMNN()[i], "TauxTraining"));
                        res = String.valueOf(res) + " +/- " + resdisplay.formatFloat(resdisplay.getEcartType("LMNN Euclidean, knn" + par.getKnnLMNN()[i], "TauxTraining")) + " )";
                        res = String.valueOf(res) + "\nLMNN Malhalanobis : " + resdisplay.formatFloat(resdisplay.getMoyenne("LMNN Malhalanobis, knn" + par.getKnnLMNN()[i], "TauxTesting"));
                        res = String.valueOf(res) + " +/- " + resdisplay.formatFloat(resdisplay.getEcartType("LMNN Malhalanobis, knn" + par.getKnnLMNN()[i], "TauxTesting"));
                        res = String.valueOf(res) + "  ( " + resdisplay.formatFloat(resdisplay.getMoyenne("LMNN Malhalanobis, knn" + par.getKnnLMNN()[i], "TauxTraining"));
                        res = String.valueOf(res) + " +/- " + resdisplay.formatFloat(resdisplay.getEcartType("LMNN Malhalanobis, knn" + par.getKnnLMNN()[i], "TauxTraining")) + " )";
                        res = String.valueOf(res) + "\nEnergy classification : " + resdisplay.formatFloat(resdisplay.getMoyenne("Energy classification, knn" + par.getKnnLMNN()[i], "TauxError"));
                        res = String.valueOf(res) + " +/- " + resdisplay.formatFloat(resdisplay.getEcartType("Energy classification, knn" + par.getKnnLMNN()[i], "TauxError"));
                        res = String.valueOf(res) + "\nLMNN Training Time : " + resdisplay.formatFloat(resdisplay.getMoyenne("LMNN Training, knn" + par.getKnnLMNN()[i], "Time"));
                        res = String.valueOf(res) + " +/- " + resdisplay.formatFloat(resdisplay.getEcartType("LMNN Training, knn" + par.getKnnLMNN()[i], "Time"));
                        resdisplay.afficherln(res, psout, verbose);
                        ++i;
                    }
                }
                ++nbboucles;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        psout.close();
    }
}

