/*
 * Decompiled with CFR 0.152.
 */
package explorer.batch.knn;

import explorer.batch.CentralResult;
import explorer.batch.ResultDisplay;
import explorer.batch.knn.InterfaceTestKnn;
import explorer.compute.compute.projection.PMFactory;
import explorer.compute.compute.projection.PMKNNPCA;
import explorer.compute.compute.projection.conditionning.Conditioning;
import explorer.compute.compute.projection.conditionning.ConditioningFactory;
import explorer.data.SourceAttrVal;
import java.io.PrintStream;

public class TestKnn
implements InterfaceTestKnn {
    private PMKNNPCA kacp;
    private int nbAttACP;
    private SourceAttrVal dt;
    private boolean centrage;
    private int normalisation;
    private String name;
    private int knnMax = 11;
    private int detailAff = 0;
    private float knnDiff = 0.0f;
    private int knnMin = 1;

    public TestKnn(SourceAttrVal _dt, boolean _centrage, int _normalisation, String _name) {
        this.dt = _dt;
        this.nbAttACP = this.dt.getNbAttACP();
        this.centrage = _centrage;
        this.normalisation = _normalisation;
        this.name = _name;
        this.knnDiff = 0.0f;
    }

    public TestKnn(SourceAttrVal _dt, boolean _centrage, int _normalisation, String _name, float diff) {
        this.dt = _dt;
        this.nbAttACP = this.dt.getNbAttACP();
        this.centrage = _centrage;
        this.normalisation = _normalisation;
        this.name = _name;
        this.knnDiff = diff;
    }

    public TestKnn() {
    }

    @Override
    public void setParameters(SourceAttrVal _dt, boolean _centrage, int _normalisation, String _name, float diff) {
        this.dt = _dt;
        this.nbAttACP = this.dt.getNbAttACP();
        this.centrage = _centrage;
        this.normalisation = _normalisation;
        this.name = _name;
        this.knnDiff = diff;
    }

    @Override
    public int getKnnMin() {
        return this.knnMin;
    }

    @Override
    public synchronized void setKnnMin(int knnMin) {
        this.knnMin = knnMin;
    }

    @Override
    public float getKnnDiff() {
        return this.knnDiff;
    }

    @Override
    public synchronized void setKnnDiff(float knnDiff) {
        this.knnDiff = knnDiff;
    }

    @Override
    public synchronized CentralResult run(int[] cross, int nbg, boolean affichage, int knn) {
        long begin = System.currentTimeMillis();
        long end = 0L;
        float time = 0.0f;
        float tauxM = -1.0f;
        float tauxT = 0.0f;
        int errM = 0;
        CentralResult resultats = new CentralResult();
        int j = this.knnMin;
        while (j < this.knnMax) {
            Conditioning c = ConditioningFactory.createConditioning(this.normalisation, this.centrage);
            this.kacp = PMFactory.getSingleton().createPMKNNPCA(this.dt, c, this.knnDiff);
            this.kacp.setAff(false);
            if (this.kacp.isAff()) {
                System.out.print("knnACP ");
            }
            this.kacp.setParameterValue(PMKNNPCA.param_knn, (float)j * 1.0f);
            this.kacp.setCrossValidation(cross, nbg);
            this.kacp.calculer();
            this.kacp.creerProjection();
            if (this.kacp.isAff()) {
                System.out.print(String.valueOf(j) + " ");
            }
            this.kacp.test(cross, nbg, false, j);
            float[] ve = this.kacp.getVarEx();
            end = System.currentTimeMillis();
            int i = 0;
            while (i < this.nbAttACP) {
                resultats.addResult("knn" + this.name + "-" + j + " (" + i + ")" + "knndiff =" + this.knnDiff + "knn " + knn + " KnnMin : " + this.knnMin, "Taux", this.kacp.getTauxCorrect(i));
                resultats.addResult("knn" + this.name + "-" + j + " (" + i + ")" + "knndiff =" + this.knnDiff + "knn " + knn + " KnnMin : " + this.knnMin, "VarEx", ve[i]);
                resultats.addResult("knn" + this.name + "-" + j + " (" + i + ")" + "knndiff =" + this.knnDiff + "knn " + knn + " KnnMin : " + this.knnMin, "VarInter", this.kacp.getVarianceInter(i));
                resultats.addResult("knn" + this.name + "-" + j + " (" + i + ")" + "knndiff =" + this.knnDiff + "knn " + knn + " KnnMin : " + this.knnMin, "VarIntra", this.kacp.getVarianceIntra(i));
                ++i;
            }
            resultats.addResult("knn" + this.name + "-" + j + "knndiff =" + this.knnDiff + "knn " + knn + " KnnMin : " + this.knnMin, "AutoDim", this.kacp.getNbDimAutoDim());
            float errA = this.kacp.getTauxCorrectAppAutoDim();
            resultats.addResult("knn" + this.name + "-" + j + "knndiff =" + this.knnDiff + "knn " + knn + " KnnMin : " + this.knnMin, "TauxApp", errA);
            float errT = this.kacp.getTauxCorrectTestAutoDim();
            resultats.addResult("knn" + this.name + "-" + j + "knndiff =" + this.knnDiff + "knn " + knn + " KnnMin : " + this.knnMin, "TauxTest", errT);
            if (tauxM == -1.0f || errA > tauxM) {
                errM = j;
                tauxM = errA;
                tauxT = errT;
            }
            j += 2;
        }
        if (end != 0L) {
            time = (float)(end - begin) / 1000.0f;
        }
        resultats.addResult("knn" + this.name + "knndiff =" + this.knnDiff + "knn " + knn + " KnnMin : " + this.knnMin, "bestW", errM);
        resultats.addResult("knn" + this.name + "knndiff =" + this.knnDiff + "knn " + knn + " KnnMin : " + this.knnMin, "Taux", tauxT);
        resultats.addResult("knn" + this.name + "knndiff =" + this.knnDiff + "knn " + knn + " KnnMin : " + this.knnMin, "Time", time);
        return resultats;
    }

    public void affiche(CentralResult res, PrintStream psout, int verbose, int k, float knd, int kmin) {
        ResultDisplay resultats = new ResultDisplay(res, psout, verbose);
        resultats.afficherln("-------------------------------------------------------", psout, verbose);
        if (this.detailAff == 2) {
            resultats.afficherln("knn " + this.name + ":  (knnMax=" + this.knnMax + ", knnDiff=" + knd + ")", psout, verbose);
            int j = 1;
            while (j < this.knnMax) {
                resultats.afficherln("knn=" + j + " :   ", psout, verbose);
                int i = 0;
                while (i < this.nbAttACP) {
                    resultats.afficheMethodeType("knn" + this.name + "-" + j + " (" + i + ")" + "knndiff =" + knd + "knn " + k + " KnnMin : " + kmin, "Taux");
                    ++i;
                }
                resultats.afficheMethodeType("knn" + this.name + "-" + j + "knndiff =" + knd + "knn " + k + " KnnMin : " + kmin, "AutoDim");
                resultats.afficheMethodeType("knn" + this.name + "-" + j + "knndiff =" + knd + "knn " + k + " KnnMin : " + kmin, "TauxApp");
                resultats.afficheMethodeType("knn" + this.name + "-" + j + "knndiff =" + knd + "knn " + k + " KnnMin : " + kmin, "TauxTest");
                resultats.afficherln(psout, verbose);
                j += 2;
            }
            resultats.afficheMethodeType("knn" + this.name + "knndiff =" + knd + "knn " + k + " KnnMin : " + kmin, "bestW");
            resultats.afficheMethodeType("knn" + this.name + "knndiff =" + knd + "knn " + k + " KnnMin : " + kmin, "Taux");
        } else if (this.detailAff == 1) {
            resultats.afficherln("knn " + this.name + ":  (knnMax=" + this.knnMax + ", knnDiff=" + knd + ")", psout, verbose);
            resultats.afficheMethodeType("knn" + this.name + "knndiff =" + knd + "knn " + k + " KnnMin : " + kmin, "bestW");
            resultats.afficheMethodeType("knn" + this.name + "knndiff =" + knd + "knn " + k + " KnnMin : " + kmin, "Taux");
            resultats.afficheMethodeType("knn" + this.name + "knndiff =" + knd + "knn " + k + " KnnMin : " + kmin, "Time");
        } else if (this.detailAff == 0) {
            resultats.afficher("knn " + this.name + ":  (knnMax=" + this.knnMax + ", knnDiff=" + knd + ")", psout, verbose);
            String out = resultats.formatFloat(resultats.getMoyenne("knn" + this.name + "knndiff =" + knd + "knn " + k + " KnnMin : " + kmin, "Taux"));
            out = String.valueOf(out) + " +/- " + resultats.formatFloat(resultats.getEcartType("knn" + this.name + "knndiff =" + knd + "knn " + k + " KnnMin : " + kmin, "Taux"));
            resultats.afficherln(out, psout, verbose);
            out = "Training time : " + resultats.formatFloat(resultats.getMoyenne("knn" + this.name + "knndiff =" + knd + "knn " + k + " KnnMin : " + kmin, "Time"));
            out = String.valueOf(out) + " +/- " + resultats.formatFloat(resultats.getEcartType("knn" + this.name + "knndiff =" + knd + "knn " + k + " KnnMin : " + kmin, "Time"));
            resultats.afficherln(out, psout, verbose);
        }
    }
}

