/*
 * Decompiled with CFR 0.152.
 */
package explorer.batch.lda;

import explorer.batch.CentralResult;
import explorer.batch.ResultDisplay;
import explorer.batch.lda.InterfaceTestLDA;
import explorer.compute.compute.projection.PMFactory;
import explorer.compute.compute.projection.PMLDA;
import explorer.compute.compute.projection.conditionning.Conditioning;
import explorer.compute.compute.projection.conditionning.ConditioningFactory;
import explorer.data.DataManager;
import explorer.data.SourceAttrVal;
import java.io.PrintStream;
import lib3d4j.data.DescriptionData;

public class TestLDA
implements InterfaceTestLDA {
    private PMLDA lda;
    private int nbAttACP;
    private SourceAttrVal dt;
    private boolean centrage;
    private int normalisation;
    private String name;
    DescriptionData dd = DataManager.getSingleton().getCompAttr();
    private int detailAff = 0;

    public TestLDA(SourceAttrVal _dt, boolean _centrage, int _normalisation, String _name) {
        this.dt = _dt;
        this.nbAttACP = this.dt.getNbAttACP();
        this.centrage = _centrage;
        this.normalisation = _normalisation;
        this.name = _name;
    }

    public TestLDA() {
    }

    @Override
    public void setParameters(SourceAttrVal _dt, boolean _centrage, int _normalisation, String _name) {
        this.dt = _dt;
        this.nbAttACP = this.dt.getNbAttACP();
        this.centrage = _centrage;
        this.normalisation = _normalisation;
        this.name = _name;
    }

    @Override
    public synchronized CentralResult run(int[] cross, int nbg, boolean affichage, int knn) {
        long begin = System.currentTimeMillis();
        CentralResult resultats = new CentralResult();
        Conditioning c = ConditioningFactory.createConditioning(this.normalisation, this.centrage);
        this.lda = PMFactory.getSingleton().createPMLDA(this.dt, c);
        this.lda.setCrossValidation(cross, nbg);
        this.lda.calculer();
        this.lda.creerProjection();
        System.out.print("LDA  ");
        this.lda.test(cross, nbg, false, knn);
        float[] ve = this.lda.getVarEx();
        long end = System.currentTimeMillis();
        float time = (float)(end - begin) / 1000.0f;
        int borne = this.nbAttACP;
        if (borne > this.dd.getNbClasses() - 1) {
            borne = this.dd.getNbClasses() - 1;
        }
        int i = 0;
        while (i < borne) {
            resultats.addResult("lda" + this.name + "(" + i + ")" + " knn " + knn, "Taux", this.lda.getTauxCorrect(i));
            resultats.addResult("lda" + this.name + "(" + i + ")" + " knn " + knn, "VarEx", ve[i]);
            resultats.addResult("lda" + this.name + "(" + i + ")" + " knn " + knn, "VarInter", this.lda.getVarianceInter(i));
            resultats.addResult("lda" + this.name + "(" + i + ")" + " knn " + knn, "VarIntra", this.lda.getVarianceIntra(i));
            ++i;
        }
        resultats.addResult("lda" + this.name + " knn " + knn, "AutoDim", this.lda.getNbDimAutoDim());
        resultats.addResult("lda" + this.name + " knn " + knn, "TauxApp", this.lda.getTauxCorrectAppAutoDim());
        resultats.addResult("lda" + this.name + " knn " + knn, "TauxTest", this.lda.getTauxCorrectTestAutoDim());
        resultats.addResult("lda" + this.name + " knn " + knn, "Time", time);
        return resultats;
    }

    public void affiche(CentralResult res, PrintStream psout, int verbose, int knn) {
        ResultDisplay resultats = new ResultDisplay(res, psout, verbose);
        resultats.afficherln("-------------------------------------------------------", psout, verbose);
        if (this.detailAff == 1) {
            resultats.afficherln("LDA :", psout, verbose);
            resultats.afficher(" Taux : ", psout, verbose);
            int borne = this.nbAttACP;
            if (borne > this.dd.getNbClasses()) {
                borne = this.dd.getNbClasses();
            }
            int i = 0;
            while (i < borne) {
                resultats.afficheMoyenne("lda" + this.name + "(" + i + ")" + " knn " + knn, "Taux");
                ++i;
            }
            resultats.afficherln(psout, verbose);
            resultats.afficheMethodeType("lda" + this.name + " knn " + knn, "AutoDim");
            resultats.afficheMethodeType("lda" + this.name + " knn " + knn, "TauxApp");
            resultats.afficheMethodeType("lda" + this.name + " knn " + knn, "TauxTest");
            resultats.afficheMethodeType("lda" + this.name + " knn " + knn, "Time");
            resultats.afficherln(psout, verbose);
        } else {
            resultats.afficher("Knn = " + knn + " " + "LDA :", psout, verbose);
            String out = resultats.formatFloat(resultats.getMoyenne("lda" + this.name + " knn " + knn, "TauxTest"));
            out = String.valueOf(out) + " +/- " + resultats.formatFloat(resultats.getEcartType("lda" + this.name + " knn " + knn, "TauxTest"));
            out = String.valueOf(out) + "  ( " + resultats.formatFloat(resultats.getMoyenne("lda" + this.name + " knn " + knn, "TauxApp"));
            out = String.valueOf(out) + " +/- " + resultats.formatFloat(resultats.getEcartType("lda" + this.name + " knn " + knn, "TauxApp")) + " )";
            resultats.afficherln(out, psout, verbose);
            out = "Training time : " + resultats.formatFloat(resultats.getMoyenne("lda" + this.name + " knn " + knn, "Time"));
            out = String.valueOf(out) + " +/- " + resultats.formatFloat(resultats.getEcartType("lda" + this.name + " knn " + knn, "Time"));
            resultats.afficherln(out, psout, verbose);
        }
    }
}

