/*
 * Decompiled with CFR 0.152.
 */
package explorer.compute.classification;

import java.util.Arrays;
import java.util.Random;
import lib3d4j.compute.tools.OutilsAlgebre;

public class FuzzyKMean {
    protected float[][] points;
    protected float[][] u;
    protected int nbclasses;
    protected float[][] centres;
    protected int nbpoints;
    protected int nbdim;
    protected float min = -1.0f;
    protected float max = 1.0f;
    protected float ampl = this.max - this.min;
    protected float m = 1.25f;
    protected float fuz;

    public FuzzyKMean(float[][] p, int nbclasses) {
        this.points = p;
        this.nbpoints = p.length;
        this.nbclasses = nbclasses;
        this.nbdim = p[0].length;
        this.centres = new float[nbclasses][];
        Random rand = new Random();
        int i = 0;
        while (i < nbclasses) {
            this.centres[i] = new float[this.nbdim];
            this.centres[i] = Arrays.copyOf(this.points[rand.nextInt(this.nbpoints)], this.nbdim);
            ++i;
        }
        this.u = new float[this.nbpoints][nbclasses];
    }

    public boolean compute(int maxStep) {
        int change;
        this.fuz = 2.0f / (1.0f - this.m);
        int nbStep = 0;
        do {
            change = this.iterate();
        } while (++nbStep < maxStep);
        return change == 0;
    }

    public int iterate() {
        int change = 0;
        float[][] newCentres = new float[this.nbclasses][this.nbdim];
        float[] sumU = new float[this.nbclasses];
        int[] effectifs = new int[this.nbclasses];
        int i = 0;
        while (i < this.nbclasses) {
            Arrays.fill(newCentres[i], 0.0f);
            effectifs[i] = 0;
            sumU[i] = 0.0f;
            ++i;
        }
        i = 0;
        while (i < this.nbpoints) {
            float[] p = this.points[i];
            float[] dist = new float[this.nbclasses];
            int c = 0;
            while (c < this.nbclasses) {
                dist[c] = OutilsAlgebre.distance(p, this.centres[c]);
                ++c;
            }
            float sumD = 0.0f;
            int j = 0;
            while (j < this.nbclasses) {
                sumD = (float)((double)sumD + Math.pow(dist[j], this.fuz));
                ++j;
            }
            int k = 0;
            while (k < this.nbclasses) {
                this.u[i][k] = (float)Math.pow(dist[k], this.fuz) / sumD;
                if (Float.isNaN(this.u[i][k])) {
                    System.out.println("Nan " + i + " " + k);
                    this.u[i][k] = 1.0f;
                }
                int dim = 0;
                while (dim < this.nbdim) {
                    float[] fArray = newCentres[k];
                    int n = dim;
                    fArray[n] = (float)((double)fArray[n] + (double)p[dim] * Math.pow(this.u[i][k], this.m));
                    ++dim;
                }
                int n = k;
                sumU[n] = (float)((double)sumU[n] + Math.pow(this.u[i][k], this.m));
                ++k;
            }
            ++i;
        }
        int k = 0;
        while (k < this.nbclasses) {
            int dim = 0;
            while (dim < this.nbdim) {
                this.centres[k][dim] = newCentres[k][dim] / sumU[k];
                ++dim;
            }
            ++k;
        }
        return change;
    }

    public float[][] getClasses() {
        return this.u;
    }

    public float[] getCenter(int cat) {
        return this.centres[cat];
    }
}

