/*
 * Decompiled with CFR 0.152.
 */
package explorer.compute.classification;

import java.util.Arrays;
import java.util.Random;
import lib3d4j.compute.tools.OutilsAlgebre;

public class KMean {
    protected float[][] points;
    protected int[] classe;
    protected int nbclasses;
    protected float[][] centres;
    protected int nbpoints;
    protected int nbdim;
    protected float min = -1.0f;
    protected float max = 1.0f;
    protected float ampl = this.max - this.min;

    public KMean(float[][] p, int nbclasses) {
        this.points = p;
        this.nbpoints = p.length;
        this.nbclasses = nbclasses;
        this.nbdim = p[0].length;
        this.centres = new float[nbclasses][];
        Random rand = new Random();
        int i = 0;
        while (i < nbclasses) {
            this.centres[i] = new float[this.nbdim];
            this.centres[i] = Arrays.copyOf(this.points[rand.nextInt(this.nbpoints)], this.nbdim);
            ++i;
        }
        this.classe = new int[this.nbpoints];
        Arrays.fill(this.classe, 0);
    }

    public boolean compute(int maxStep) {
        int change;
        int nbStep = 0;
        do {
            change = this.iterate();
        } while (++nbStep < maxStep && change > 0);
        return change == 0;
    }

    public int iterate() {
        int change = 0;
        float[][] newCentres = new float[this.nbclasses][this.nbdim];
        int[] effectifs = new int[this.nbclasses];
        int i = 0;
        while (i < this.nbclasses) {
            Arrays.fill(newCentres[i], 0.0f);
            effectifs[i] = 0;
            ++i;
        }
        i = 0;
        while (i < this.nbpoints) {
            float[] p = this.points[i];
            int ppc = 0;
            double dist = OutilsAlgebre.distance(p, this.centres[0]);
            int c = 1;
            while (c < this.nbclasses) {
                float f;
                float distC = OutilsAlgebre.distance(p, this.centres[c]);
                if ((double)f < dist) {
                    ppc = c;
                    dist = distC;
                }
                ++c;
            }
            if (this.classe[i] != ppc) {
                ++change;
            }
            this.classe[i] = ppc;
            int dim = 0;
            while (dim < this.nbdim) {
                float[] fArray = newCentres[ppc];
                int n = dim;
                fArray[n] = fArray[n] + p[dim];
                ++dim;
            }
            int n = ppc;
            effectifs[n] = effectifs[n] + 1;
            ++i;
        }
        i = 0;
        while (i < this.nbclasses) {
            if (effectifs[i] > 0) {
                int dim = 0;
                while (dim < this.nbdim) {
                    this.centres[i][dim] = newCentres[i][dim] / (float)effectifs[i];
                    ++dim;
                }
            } else {
                Random rand = new Random();
                int dim = 0;
                while (dim < this.nbdim) {
                    this.centres[i][dim] = this.min + this.ampl * rand.nextFloat();
                    ++dim;
                }
            }
            ++i;
        }
        return change;
    }

    public int[] getClasses() {
        return this.classe;
    }
}

