/*
 * Decompiled with CFR 0.152.
 */
package explorer.compute.classification;

import explorer.compute.classification.IndiceException;
import explorer.compute.classification.OctKey;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;

public class OctreeProb {
    private float probPlus;
    public static final int NODE = 0;
    public static final int MINUS = 1;
    public static final int PLUS = 2;
    public static final int EMPTY = 3;
    public static final int NONE = -1;
    static int currnum = 0;
    static List<int[]> equivalentClusters = new ArrayList<int[]>();
    static Hashtable<Integer, List<Integer>> hashClust = new Hashtable();
    public static float xmin = -1.0f;
    public static float xsize = 2.0f;
    public static float ymin = -1.0f;
    public static float ysize = 2.0f;
    public static float zmin = -1.0f;
    public static float zsize = 2.0f;
    public static int MAXDEPTH = 6;
    static Hashtable<OctKey, OctreeProb> index = new Hashtable();
    protected int depth;
    protected float x;
    protected float y;
    protected float z;
    protected long indice;
    protected int sign;
    protected OctreeProb[] children;
    protected int cluster;

    public OctreeProb(List<float[]> plus, List<float[]> minus) {
        this(plus, minus, 0, xmin, ymin, zmin, 0L);
    }

    public OctreeProb(List<float[]> plus, List<float[]> minus, int depth, float x, float y, float z, long indice) {
        this.depth = depth;
        this.x = x;
        this.y = y;
        this.z = z;
        this.indice = indice;
        this.cluster = -1;
        this.children = null;
        int cardPlus = plus.size();
        int cardMinus = minus.size();
        if (cardMinus == 0 && cardPlus == 0) {
            this.sign = 3;
        } else if (depth == MAXDEPTH) {
            this.sign = cardMinus == 0 && cardPlus == 0 ? 3 : (cardMinus > cardPlus ? 1 : 2);
        } else {
            this.sign = 0;
            float step = (float)Math.pow(2.0, depth + 1);
            float midX = x + xsize / step;
            float midY = y + ysize / step;
            float midZ = z + zsize / step;
            ArrayList[] subPlus = new ArrayList[8];
            int i = 0;
            while (i < 8) {
                subPlus[i] = new ArrayList();
                ++i;
            }
            for (float[] plusElem : plus) {
                int indiceP = 0;
                if (plusElem[0] > midX) {
                    ++indiceP;
                }
                if (plusElem[1] > midY) {
                    indiceP += 2;
                }
                if (plusElem[2] > midZ) {
                    indiceP += 4;
                }
                subPlus[indiceP].add(plusElem);
            }
            ArrayList[] subMinus = new ArrayList[8];
            int i2 = 0;
            while (i2 < 8) {
                subMinus[i2] = new ArrayList();
                ++i2;
            }
            for (float[] minusElem : minus) {
                int indiceM = 0;
                if (minusElem[0] > midX) {
                    ++indiceM;
                }
                if (minusElem[1] > midY) {
                    indiceM += 2;
                }
                if (minusElem[2] > midZ) {
                    indiceM += 4;
                }
                subMinus[indiceM].add(minusElem);
            }
            this.children = new OctreeProb[8];
            int nbplus = 0;
            int nbminus = 0;
            int i3 = 0;
            while (i3 < 8) {
                float subX = x + ((i3 & 1) != 0 ? midX - x : 0.0f);
                float subY = y + ((i3 & 2) != 0 ? midY - y : 0.0f);
                float subZ = z + ((i3 & 4) != 0 ? midZ - z : 0.0f);
                this.children[i3] = new OctreeProb(subPlus[i3], subMinus[i3], depth + 1, subX, subY, subZ, indice << 3 | (long)i3);
                if (this.children[i3].sign == 2) {
                    ++nbplus;
                } else if (this.children[i3].sign == 1) {
                    ++nbminus;
                }
                ++i3;
            }
            if (nbplus == 8) {
                this.sign = 2;
            } else if (nbminus == 8) {
                this.sign = 1;
            }
        }
        OctreeProb.addInIndex(this);
        this.probPlus = this.sign == 2 ? 1.0f : (this.sign == 1 ? 0.0f : 0.5f);
    }

    public List<float[]> getCubesByCenter() {
        ArrayList<float[]> cubes = new ArrayList<float[]>();
        if (this.sign == 0) {
            OctreeProb[] octreeProbArray = this.children;
            int n = this.children.length;
            int n2 = 0;
            while (n2 < n) {
                OctreeProb child = octreeProbArray[n2];
                List<float[]> cubesfils = child.getCubesByCenter();
                for (float[] cf : cubesfils) {
                    cubes.add(cf);
                }
                ++n2;
            }
        } else if (this.sign == 2) {
            float[] coord = new float[6];
            float step = xsize / (float)Math.pow(2.0, this.depth + 1);
            coord[0] = this.x + step;
            coord[1] = this.y + step;
            coord[2] = this.z + step;
            coord[4] = coord[5] = step;
            coord[3] = coord[5];
            cubes.add(coord);
        }
        return cubes;
    }

    public List<Integer> getCubesByColor() {
        ArrayList<Integer> cubes = new ArrayList<Integer>();
        if (this.sign == 0) {
            OctreeProb[] octreeProbArray = this.children;
            int n = this.children.length;
            int n2 = 0;
            while (n2 < n) {
                OctreeProb child = octreeProbArray[n2];
                List<Integer> cubesfils = child.getCubesByColor();
                for (Integer cf : cubesfils) {
                    cubes.add(cf);
                }
                ++n2;
            }
        } else if (this.sign == 2) {
            cubes.add(this.cluster);
        }
        return cubes;
    }

    public String toString() {
        return this.trace("");
    }

    private long decalePlus(long indiceN, long exp) throws IndiceException {
        int max = 0;
        while ((indiceN & exp) != 0L && max < 63) {
            indiceN ^= exp;
            exp <<= 3;
            ++max;
        }
        if (max == 63) {
            throw new IndiceException();
        }
        return indiceN | exp;
    }

    private long decaleMoins(long indiceN, long exp) throws IndiceException {
        int max = 0;
        while ((indiceN & exp) == 0L && max < 63) {
            indiceN |= exp;
            exp <<= 3;
            ++max;
        }
        if (max == 63) {
            throw new IndiceException();
        }
        return indiceN ^ exp;
    }

    protected long getIndiceNeighbourg(int x, int y, int z) throws IndiceException {
        boolean depth = false;
        long indiceN = this.indice;
        while (x > 0) {
            indiceN = this.decalePlus(indiceN, 1L);
            --x;
        }
        while (x < 0) {
            indiceN = this.decaleMoins(indiceN, 1L);
            ++x;
        }
        while (y > 0) {
            indiceN = this.decalePlus(indiceN, 2L);
            --y;
        }
        while (y < 0) {
            indiceN = this.decaleMoins(indiceN, 2L);
            ++y;
        }
        while (z > 0) {
            indiceN = this.decalePlus(indiceN, 4L);
            --z;
        }
        while (z < 0) {
            indiceN = this.decaleMoins(indiceN, 4L);
            ++z;
        }
        return indiceN;
    }

    protected String trace(String dt) {
        dt = String.valueOf(dt) + ".";
        if (this.sign != 0) {
            dt = String.valueOf(dt) + " " + this.indice + " (" + OctreeProb.binary(this.indice, this.depth) + ") ";
        }
        switch (this.sign) {
            case 3: {
                return String.valueOf(dt) + " /";
            }
            case 2: {
                return String.valueOf(dt) + " +";
            }
            case 1: {
                return String.valueOf(dt) + " -";
            }
        }
        StringBuffer retour = new StringBuffer();
        OctreeProb[] octreeProbArray = this.children;
        int n = this.children.length;
        int n2 = 0;
        while (n2 < n) {
            OctreeProb child = octreeProbArray[n2];
            retour.append(child.trace(dt));
            retour.append("\n");
            ++n2;
        }
        return retour.toString();
    }

    public static OctreeProb getFromIndex(long indice, int depth) {
        return index.get(new OctKey(indice, depth));
    }

    public static void addInIndex(OctreeProb o) {
        index.put(new OctKey(o.indice, o.depth), o);
    }

    public static String binary(long l, int depth) {
        StringBuffer sb = new StringBuffer();
        long bit = 1L;
        int bound = 3 * depth;
        int i = 0;
        while (i < bound) {
            if ((l & bit) != 0L) {
                sb.append("1");
            } else {
                sb.append("0");
            }
            bit <<= 1;
            ++i;
        }
        return sb.reverse().toString();
    }

    public void setProb(int radius, float threshold, int nbiter) {
        int i = 0;
        while (i < nbiter) {
            this.setProb(radius, threshold);
            ++i;
        }
    }

    public int setProb(int radius, float threshold) {
        this.preSetProb(radius);
        int modified = this.finalizeProb(threshold);
        this.generateClusters();
        return modified;
    }

    public void preSetProb(int radius) {
        if (this.sign == 0) {
            OctreeProb[] octreeProbArray = this.children;
            int n = this.children.length;
            int n2 = 0;
            while (n2 < n) {
                OctreeProb child = octreeProbArray[n2];
                child.preSetProb(radius);
                ++n2;
            }
        } else if (this.sign == 3) {
            int nbplus = 0;
            int nbminus = 0;
            int x = -radius;
            while (x <= radius) {
                int y = -radius;
                while (y <= radius) {
                    int z = -radius;
                    while (z <= radius) {
                        if (x != 0 || y != 0 || z != 0) {
                            try {
                                long indiceV = this.getIndiceNeighbourg(x, y, z);
                                OctreeProb oct = OctreeProb.getFromIndex(indiceV, this.depth);
                                if (oct != null) {
                                    if (oct.sign == 2) {
                                        ++nbplus;
                                    }
                                    if (oct.sign == 1) {
                                        ++nbminus;
                                    }
                                }
                            }
                            catch (IndiceException indiceException) {
                                // empty catch block
                            }
                        }
                        ++z;
                    }
                    ++y;
                }
                ++x;
            }
            if (nbplus > nbminus) {
                this.probPlus = 0.5f + (float)nbplus / (float)(2 * (nbplus + nbminus));
                System.out.println("setprob (+): " + this.probPlus);
            } else if (nbminus > nbplus) {
                this.probPlus = 0.5f - (float)nbminus / (float)(2 * (nbplus + nbminus));
                System.out.println("setprob (-): " + this.probPlus);
            } else {
                this.probPlus = 0.5f;
            }
        }
    }

    public int finalizeProb(float threshold) {
        int modified = 0;
        if (this.sign == 0) {
            OctreeProb[] octreeProbArray = this.children;
            int n = this.children.length;
            int n2 = 0;
            while (n2 < n) {
                OctreeProb child = octreeProbArray[n2];
                child.finalizeProb(threshold);
                ++n2;
            }
        } else if (this.sign == 3) {
            if (this.probPlus > threshold) {
                this.sign = 2;
                ++modified;
                System.out.println("modified +" + this.probPlus);
            } else if (this.probPlus < 1.0f - threshold) {
                this.sign = 1;
                ++modified;
                System.out.println("modified -" + this.probPlus);
            }
        }
        return modified;
    }

    public void generateClusters() {
        Equiv equ = new Equiv();
        this.clusterize(equ);
        equ.unify();
        this.unifyClusters(equ);
    }

    private void clusterize(Equiv equ) {
        block12: {
            block11: {
                if (this.sign != 0) break block11;
                OctreeProb[] octreeProbArray = this.children;
                int n = this.children.length;
                int n2 = 0;
                while (n2 < n) {
                    OctreeProb child = octreeProbArray[n2];
                    child.clusterize(equ);
                    ++n2;
                }
                break block12;
            }
            if (this.sign != 2) break block12;
            if (this.cluster == -1) {
                this.cluster = OctreeProb.nextCluster();
                equ.ensure(this.cluster);
            }
            int x = 0;
            while (x < 2) {
                int y = 0;
                while (y < 2) {
                    int z = 0;
                    while (z < 2) {
                        if (x != 0 || y != 0 || z != 0) {
                            try {
                                long indiceV = this.getIndiceNeighbourg(x, y, z);
                                OctreeProb oct = OctreeProb.getFromIndex(indiceV, this.depth);
                                if (oct != null && oct.sign == 2) {
                                    if (oct.cluster == -1) {
                                        oct.cluster = this.cluster;
                                    } else {
                                        equ.update(this.cluster, oct.cluster);
                                    }
                                }
                            }
                            catch (IndiceException indiceException) {
                                // empty catch block
                            }
                        }
                        ++z;
                    }
                    ++y;
                }
                ++x;
            }
        }
    }

    private void unifyClusters(Equiv equ) {
        if (this.sign == 0) {
            OctreeProb[] octreeProbArray = this.children;
            int n = this.children.length;
            int n2 = 0;
            while (n2 < n) {
                OctreeProb child = octreeProbArray[n2];
                child.unifyClusters(equ);
                ++n2;
            }
        } else if (this.sign == 2) {
            this.cluster = equ.get(this.cluster);
        }
    }

    private static int nextCluster() {
        return ++currnum;
    }

    public static void main(String[] args) {
    }

    class Equiv {
        private static final int step = 5;
        private int size = 5;
        private int[] content = new int[5];

        public Equiv() {
            int i = 0;
            while (i < this.size) {
                this.content[i] = i;
                ++i;
            }
        }

        public void ensure(int max) {
            if (max >= this.size) {
                int[] nc = new int[this.size + 5];
                System.arraycopy(this.content, 0, nc, 0, this.size);
                int i = this.size;
                while (i < this.size + 5) {
                    nc[i] = i;
                    ++i;
                }
                this.content = nc;
                this.size += 5;
            }
        }

        public void update(int n1, int n2) {
            int min = n1;
            int max = n2;
            if (n2 < n1) {
                min = n2;
                max = n1;
            }
            if (this.content[max] == max) {
                this.content[max] = this.content[min];
            } else {
                int pmin;
                int pmax;
                if (this.content[max] > this.content[min]) {
                    pmax = this.content[max];
                    pmin = this.content[min];
                } else {
                    pmax = this.content[min];
                    pmin = this.content[max];
                }
                this.content[pmax] = this.content[pmin];
            }
        }

        public void unify() {
            int i = 0;
            while (i < this.size) {
                this.content[i] = this.content[this.content[i]];
                ++i;
            }
        }

        public int get(int i) {
            return this.content[i];
        }
    }
}

