/*
 * Decompiled with CFR 0.152.
 */
package explorer.compute.classification.klustaKwik;

import Jama.Matrix;
import explorer.compute.classification.klustaKwik.KK;
import explorer.compute.classification.klustaKwik.KlustaSave;
import java.util.LinkedList;
import java.util.Random;
import java.util.Vector;
import lib3d4j.compute.tools.OutilsAlgebre;
import lib3d4j.compute.tools.OutilsTableaux;

public class KlustaKwik {
    static final float HugeScore = 1.0E32f;
    static final int ElecNo = 1;
    static final int MinClusters = 2;
    static final int MaxClusters = 10;
    static final int MaxPossibleClusters = 100;
    static final int nStarts = 1;
    static final int RandomSeed = 1;
    static final char Debug = '0';
    static final int Verbose = 1;
    static final int DistDump = 0;
    static final float DistThresh = (float)Math.log(1000.0);
    static final int FullStepEvery = 10;
    static final float ChangedThresh = 0.05f;
    static final char Log = '\u0001';
    static final char Screen = '\u0001';
    static final int MaxIter = 500;
    static final int SplitEvery = 50;
    int nClass;
    static final float PenaltyMix = 0.0f;
    KlustaSave kSv = new KlustaSave();
    boolean fSaveModel = true;
    public int[][] clustersReindexes;
    public float[][] centreCluster;
    public float[][][] pointsParCluster;
    public Matrix[] clusterCovariance;

    public void Klusta(float[][] dav) {
        float BestScore;
        this.kSv.BestAliveIndex = new Vector(100);
        this.kSv.BestScoreSave = BestScore = 1.0E32f;
        try {
            KK K1 = new KK(this.kSv);
            K1.penaltyMix = 0.0f;
            K1.LoadData(dav);
            this.kSv.BestWeight = new float[100];
            this.kSv.BestMean = new float[100 * K1.nDims];
            K1.nStartingClusters = 2;
            while (K1.nStartingClusters <= 10) {
                int i = 0;
                while (i < 1) {
                    float Score = K1.CEM(true);
                    if (Score < BestScore) {
                        BestScore = Score;
                        if (BestScore < this.kSv.BestScoreSave) {
                            K1.SaveBestMeans();
                            this.kSv.BestScoreSave = BestScore;
                        }
                        int p = 0;
                        while (p < K1.nPoints) {
                            K1.BestClass[p] = K1.Class[p];
                            ++p;
                        }
                    }
                    ++i;
                }
                ++K1.nStartingClusters;
            }
            this.reindexer(K1);
            this.trierPointsParCluster(dav);
            this.calculerCentres();
            this.calculerCovariances();
            this.nClass = this.pointsParCluster.length;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public KlustaSave getkSv() {
        return this.kSv;
    }

    private void reindexer(KK K1) {
        int i = 0;
        if (this.kSv.nBestClustersAlive <= 1) {
            this.clustersReindexes = new int[1][K1.nPoints];
            i = 0;
            while (i < this.clustersReindexes[0].length) {
                this.clustersReindexes[0][i] = i;
                ++i;
            }
            return;
        }
        int max = 0;
        LinkedList<Integer> nbClusters = new LinkedList<Integer>();
        i = 0;
        while (i < K1.BestClass.length) {
            boolean trouve = false;
            int j = 0;
            while (j < nbClusters.size() && !trouve) {
                trouve = (Integer)nbClusters.get(j) == K1.BestClass[i];
                ++j;
            }
            if (!trouve) {
                nbClusters.add(K1.BestClass[i]);
            }
            ++i;
        }
        this.kSv.nBestClustersAlive = nbClusters.size();
        int[] indexToCluster = new int[nbClusters.size()];
        i = 0;
        while (i < nbClusters.size()) {
            indexToCluster[i] = (Integer)nbClusters.get(i);
            if (max < indexToCluster[i]) {
                max = indexToCluster[i];
            }
            ++i;
        }
        int[] clusterToIndex = new int[max + 1];
        i = 0;
        while (i <= max) {
            int j = 0;
            while (j < indexToCluster.length) {
                if (indexToCluster[j] == i) {
                    clusterToIndex[i] = j;
                }
                ++j;
            }
            ++i;
        }
        LinkedList[] l = new LinkedList[nbClusters.size()];
        i = 0;
        while (i < l.length) {
            l[i] = new LinkedList();
            ++i;
        }
        i = 0;
        while (i < K1.BestClass.length) {
            if (K1.BestClass[i] >= clusterToIndex.length) {
                System.out.println("aa");
            }
            if (clusterToIndex[K1.BestClass[i]] >= l.length) {
                System.out.println("aa");
            }
            l[clusterToIndex[K1.BestClass[i]]].add(i);
            ++i;
        }
        Object[][] res = new Object[nbClusters.size()][];
        i = 0;
        while (i < l.length) {
            res[i] = l[i].toArray();
            ++i;
        }
        this.clustersReindexes = new int[nbClusters.size()][];
        i = 0;
        while (i < res.length) {
            this.clustersReindexes[i] = new int[res[i].length];
            int j = 0;
            while (j < this.clustersReindexes[i].length) {
                this.clustersReindexes[i][j] = (Integer)res[i][j];
                ++j;
            }
            ++i;
        }
    }

    public int[] clusterParPoint() {
        return this.clustersReindexes[0];
    }

    public int[][] getClusters() {
        return this.clustersReindexes;
    }

    public int clusterDuPoint(int i) {
        int j = 0;
        while (j < this.clustersReindexes.length) {
            int k = 0;
            while (k < this.clustersReindexes[j].length) {
                if (this.clustersReindexes[j][k] == i) {
                    return j;
                }
                ++k;
            }
            ++j;
        }
        return -1;
    }

    private void trierPointsParCluster(float[][] points) {
        float[][] f = points;
        this.pointsParCluster = new float[this.clustersReindexes.length][][];
        int i = 0;
        while (i < this.clustersReindexes.length) {
            float[][] pointsClusterI = new float[this.clustersReindexes[i].length][];
            int j = 0;
            while (j < this.clustersReindexes[i].length) {
                pointsClusterI[j] = f[this.clustersReindexes[i][j]];
                ++j;
            }
            this.pointsParCluster[i] = pointsClusterI;
            ++i;
        }
    }

    private void calculerCentres() {
        this.centreCluster = new float[this.clustersReindexes.length][];
        int i = 0;
        while (i < this.clustersReindexes.length) {
            this.centreCluster[i] = OutilsAlgebre.barycenter(this.pointsParCluster[i]);
            ++i;
        }
    }

    private void calculerCovariances() {
        this.clusterCovariance = new Matrix[this.clustersReindexes.length];
        int i = 0;
        while (i < this.clustersReindexes.length) {
            this.clusterCovariance[i] = new Matrix(OutilsAlgebre.varianceCovariance(this.pointsParCluster[i]));
            ++i;
        }
    }

    public void supprimerGroupe(int numeroGroupe) {
        this.clusterCovariance = OutilsTableaux.dropRow(numeroGroupe, this.clusterCovariance);
        this.centreCluster = OutilsTableaux.dropRow(numeroGroupe, this.centreCluster);
        this.pointsParCluster = OutilsTableaux.dropRow(numeroGroupe, this.pointsParCluster);
        this.clustersReindexes = OutilsTableaux.dropRow(numeroGroupe, this.clustersReindexes);
    }

    public static void main(String[] args) {
        KlustaKwik k = new KlustaKwik();
        float[][] set = new float[200][];
        Random random = new Random();
        float factor = 100.0f;
        int i = 0;
        while (i < 80) {
            set[i] = new float[]{(0.5f + random.nextFloat() / 10.0f) * factor, (0.5f + random.nextFloat() / 10.0f) * factor, (0.5f + random.nextFloat() / 10.0f) * factor};
            ++i;
        }
        i = 80;
        while (i < 160) {
            set[i] = new float[]{(-0.5f + random.nextFloat() / 10.0f) * factor, (0.5f + random.nextFloat() / 10.0f) * factor, (0.5f + random.nextFloat() / 10.0f) * factor};
            ++i;
        }
        i = 160;
        while (i < 200) {
            set[i] = new float[]{(0.5f + random.nextFloat() / 10.0f) * factor, (-0.5f + random.nextFloat() / 10.0f) * factor, (-0.5f + random.nextFloat() / 10.0f) * factor};
            ++i;
        }
        int nbp = set.length;
        int nbDim = set[0].length;
        float[] maxs = new float[nbDim];
        float[][] fArrayArray = set;
        int n = set.length;
        int n2 = 0;
        while (n2 < n) {
            float[] point = fArrayArray[n2];
            int i2 = 0;
            while (i2 < nbDim) {
                if (maxs[i2] < Math.abs(point[i2])) {
                    maxs[i2] = Math.abs(point[i2]);
                }
                ++i2;
            }
            ++n2;
        }
        float max = 0.0f;
        float[] fArray = maxs;
        int n3 = maxs.length;
        n = 0;
        while (n < n3) {
            float elem = fArray[n];
            max = Math.max(max, elem);
            ++n;
        }
        float[][] redset = new float[set.length][3];
        int i3 = 0;
        while (i3 < set.length) {
            redset[i3] = new float[]{set[i3][0] / max, set[i3][1] / max, set[i3][2] / max};
            ++i3;
        }
        k.Klusta(redset);
        float[][][] pointsParClusters = k.pointsParCluster;
        int nbClusters = pointsParClusters.length;
        System.out.println(nbClusters);
    }
}

