/*
 * Decompiled with CFR 0.152.
 */
package explorer.compute.compute.constraints;

import explorer.compute.compute.constraints.AbstractConstraint;
import explorer.compute.compute.constraints.ConstraintTrace;
import explorer.compute.compute.projection.Projection;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class CNConstraint
extends AbstractConstraint {
    private static int idGenerator = 1;
    private static float rho = 1.0f;
    private static float alpha = 0.75f;
    private static float beta = 1.5f;
    private int objA;
    private int[] currentNbg;
    private int[] targetNbg;
    private int nTarget;
    private double[] ConstantesC;
    private boolean[] ContraintesCv;
    private float meanDist;

    private static synchronized int getNextId() {
        return idGenerator++;
    }

    public CNConstraint(String cn, Projection p) {
        super(p);
        Vector<Integer> elements = new Vector<Integer>();
        String UnElement = "";
        int i = 10;
        while (cn.charAt(i) != ')') {
            if (cn.charAt(i) == ' ') {
                i += 2;
                elements.add(Integer.parseInt(UnElement));
                UnElement = "";
            } else if (cn.charAt(i) == '(') {
                UnElement = "";
            } else if (cn.charAt(i) == ',') {
                elements.add(Integer.parseInt(UnElement));
                UnElement = "";
            } else {
                UnElement = String.valueOf(UnElement) + cn.charAt(i);
            }
            ++i;
        }
        elements.add(Integer.parseInt(UnElement));
        this.nTarget = elements.size() - 1;
        this.targetNbg = new int[this.nTarget];
        this.objA = (Integer)elements.get(0);
        i = 0;
        while (i < this.nTarget) {
            this.targetNbg[i] = (Integer)elements.get(i + 1);
            ++i;
        }
        this.init(true);
    }

    public CNConstraint(int a, int[] tNbg, Projection p) {
        super(p);
        this.objA = a;
        this.targetNbg = (int[])tNbg.clone();
        this.init(true);
    }

    public void modify(int a, int[] tNbg) {
        this.objA = a;
        this.targetNbg = (int[])tNbg.clone();
        this.init(false);
    }

    private void init(boolean creation) {
        if (creation) {
            this.id = CNConstraint.getNextId();
        }
        this.computeCurrentNbg(this.nTarget, this.objA);
        this.computeMeanDist();
        this.ConstantesC = new double[this.currentNbg.length + this.nTarget];
        int i = 0;
        while (i < this.currentNbg.length) {
            this.ConstantesC[i] = rho * (this.distanceProj(this.objA, this.currentNbg[i]) - alpha * this.distanceSource(this.objA, this.currentNbg[i]));
            ++i;
        }
        i = 0;
        while (i < this.nTarget) {
            this.ConstantesC[this.currentNbg.length + i] = rho * (this.distanceProj(this.objA, this.targetNbg[i]) - beta * this.meanDist);
            ++i;
        }
    }

    @Override
    public void afficher() {
    }

    @Override
    public void updateConstantC() {
        this.ConstantesC = new double[this.currentNbg.length + this.nTarget];
        int i = 0;
        while (i < this.currentNbg.length) {
            this.ConstantesC[i] = rho * (this.distanceProj(this.objA, this.currentNbg[i]) - alpha * this.distanceSource(this.objA, this.currentNbg[i]));
            System.out.println("i" + this.ConstantesC[i]);
            ++i;
        }
        i = 0;
        while (i < this.nTarget) {
            this.ConstantesC[this.currentNbg.length + i] = rho * (this.distanceProj(this.objA, this.targetNbg[i]) - beta * this.meanDist);
            System.out.println("i" + this.ConstantesC[this.currentNbg.length + i]);
            ++i;
        }
    }

    @Override
    public boolean ContraintePasRespectee() {
        boolean PasRespectee = true;
        boolean PasRespecteebis = true;
        this.ContraintesCv = new boolean[this.currentNbg.length + this.nTarget];
        PasRespectee = false;
        int i = 0;
        while (i < this.currentNbg.length) {
            this.ContraintesCv[i] = PasRespecteebis = !((this.distanceProj(this.objA, this.currentNbg[i]) - alpha * this.distanceSource(this.objA, this.currentNbg[i])) * -1.0f < 0.0f);
            if (PasRespecteebis) {
                PasRespectee = true;
            }
            ++i;
        }
        i = 0;
        while (i < this.nTarget) {
            this.ContraintesCv[i + this.currentNbg.length] = PasRespecteebis = !((this.distanceProj(this.objA, this.targetNbg[i]) - beta * this.meanDist) * 1.0f < 0.0f);
            if (PasRespecteebis) {
                PasRespectee = true;
            }
            ++i;
        }
        return PasRespectee;
    }

    @Override
    public boolean ContraintePasRespectee_old() {
        boolean PasRespectee = true;
        boolean PasRespecteebis = true;
        this.ContraintesCv = new boolean[this.currentNbg.length + this.nTarget];
        PasRespectee = false;
        int i = 0;
        while (i < this.currentNbg.length) {
            this.ContraintesCv[i] = PasRespecteebis = !((this.distanceProj(this.objA, this.currentNbg[i]) - alpha * this.distanceSource(this.objA, this.currentNbg[i])) * -1.0f < 0.0f);
            if (PasRespecteebis) {
                PasRespectee = true;
            }
            ++i;
        }
        i = 0;
        while (i < this.nTarget) {
            this.ContraintesCv[i + this.currentNbg.length] = PasRespecteebis = !((this.distanceProj(this.objA, this.targetNbg[i]) - beta * this.meanDist) * 1.0f < 0.0f);
            if (PasRespecteebis) {
                PasRespectee = true;
            }
            ++i;
        }
        return PasRespectee;
    }

    @Override
    public float volumeContraintePasRespectee() {
        return 0.0f;
    }

    @Override
    public double ValeurAdditionneeALaMatrice(float[][] dataOrigine, int i, int j, int nbObjects) {
        double Aj = 1.0;
        double[] AjCv = new double[this.currentNbg.length + this.nTarget];
        int m = 0;
        while (m < this.currentNbg.length) {
            AjCv[m] = this.ContraintesCv[m] ? this.ConstantesC[m] * (double)((dataOrigine[this.objA][i] - dataOrigine[this.currentNbg[m]][i]) * (dataOrigine[this.objA][j] - dataOrigine[this.currentNbg[m]][j]) - alpha * this.distanceSource(this.objA, this.currentNbg[m])) : 0.0;
            ++m;
        }
        int n = 0;
        while (n < this.nTarget) {
            AjCv[n + this.currentNbg.length] = this.ContraintesCv[n + this.currentNbg.length] ? this.ConstantesC[n + this.currentNbg.length] * (double)((dataOrigine[this.objA][i] - dataOrigine[this.targetNbg[n]][i]) * (dataOrigine[this.objA][j] - dataOrigine[this.targetNbg[n]][j]) - beta * this.meanDist) : 0.0;
            ++n;
        }
        int o = 0;
        while (o < AjCv.length) {
            Aj += AjCv[o];
            ++o;
        }
        return Aj;
    }

    private void computeCurrentNbg(int k, int objselectionne) {
        this.currentNbg = new int[k];
        float[] kplusprochesvoisinsdistances = new float[k];
        int i = 0;
        while (i < k) {
            kplusprochesvoisinsdistances[i] = 1000.0f;
            ++i;
        }
        int z = 0;
        while (z < this.pca.getNbActifs()) {
            if (this.distanceProj(objselectionne, z) < kplusprochesvoisinsdistances[this.voisinslepluseloigne(kplusprochesvoisinsdistances, k)] && z != objselectionne) {
                this.currentNbg[this.voisinslepluseloigne((float[])kplusprochesvoisinsdistances, (int)k)] = z;
                kplusprochesvoisinsdistances[this.voisinslepluseloigne((float[])kplusprochesvoisinsdistances, (int)k)] = this.distanceProj(objselectionne, z);
            }
            ++z;
        }
        int j = 0;
        while (j < k) {
            System.out.println("[" + j + "] = " + this.currentNbg[j]);
            ++j;
        }
    }

    private int voisinslepluseloigne(float[] kplusprochesvoisinsdistances, int k) {
        float max = 0.0f;
        int indice = 0;
        int i = 0;
        while (i < k) {
            if (kplusprochesvoisinsdistances[i] > max) {
                max = kplusprochesvoisinsdistances[i];
                indice = i;
            }
            ++i;
        }
        return indice;
    }

    private void computeMeanDist() {
        this.meanDist = 0.0f;
        int j = 0;
        while (j < this.nTarget) {
            int k = j + 1;
            while (k < this.nTarget) {
                this.meanDist += this.distanceProj(this.targetNbg[j], this.targetNbg[k]);
                ++k;
            }
            ++j;
        }
        this.meanDist /= (float)(this.nTarget * (this.nTarget - 1) / 2);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Dep | " + this.objA + " (");
        int[] nArray = this.targetNbg;
        int n = this.targetNbg.length;
        int n2 = 0;
        while (n2 < n) {
            int nb = nArray[n2];
            sb.append(nb + 44);
            ++n2;
        }
        sb.setCharAt(sb.length() - 1, ')');
        return sb.toString();
    }

    @Override
    public boolean fitTrace(ConstraintTrace ct) {
        if (ct instanceof CNTrace) {
            CNTrace cnt = (CNTrace)ct;
            return this.objA == cnt.objA;
        }
        return false;
    }

    public int getA() {
        return this.objA;
    }

    public List<Integer> getTargetNbg() {
        ArrayList<Integer> res = new ArrayList<Integer>();
        int[] nArray = this.targetNbg;
        int n = this.targetNbg.length;
        int n2 = 0;
        while (n2 < n) {
            int r = nArray[n2];
            res.add(r);
            ++n2;
        }
        return res;
    }

    public static class CNTrace
    implements ConstraintTrace {
        int objA;

        public CNTrace(int a) {
            this.objA = a;
        }
    }
}

