/*
 * Decompiled with CFR 0.152.
 */
package explorer.compute.compute.constraints;

import explorer.compute.compute.constraints.C2Constraint;
import explorer.compute.compute.constraints.C3Constraint;
import explorer.compute.compute.constraints.CNConstraint;
import explorer.compute.compute.constraints.Constraint;
import explorer.compute.compute.constraints.ConstraintTrace;
import explorer.compute.compute.projection.Projection;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class Constraints {
    private Projection proj;
    private List<Constraint> constList;
    private int nbEtapesInteractions = 1;
    private int nbAnomaly;
    private int nbMove;
    private int nbComp;

    public Constraints(Projection p) {
        this.proj = p;
        this.constList = new ArrayList<Constraint>();
        this.nbAnomaly = 0;
        this.nbMove = 0;
        this.nbComp = 0;
    }

    public Constraints(File f, Projection p) {
        this(p);
        this.constList.clear();
        BufferedReader fR = null;
        String ligne = null;
        try {
            fR = new BufferedReader(new FileReader(f));
            while ((ligne = fR.readLine()) != null) {
                this.constList.add(this.createConstraint(ligne));
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setProjection(Projection p) {
        for (Constraint c : this.constList) {
            c.setProjection(p);
        }
    }

    private Constraint createConstraint(String s) {
        if (s.startsWith("An |")) {
            return new C3Constraint(s, this.proj);
        }
        if (s.startsWith("Comp |")) {
            return new C2Constraint(s, this.proj);
        }
        if (s.startsWith("Dep |")) {
            return new CNConstraint(s, this.proj);
        }
        return null;
    }

    public List<Constraint> getConstraintList() {
        return this.getAllInteractions();
    }

    public void reste() {
        this.constList.clear();
        this.nbEtapesInteractions = 1;
    }

    public void miseaZeroNbEtapesInteractions() {
        this.nbEtapesInteractions = 0;
    }

    public int incrNbEtapesInteractions() {
        ++this.nbEtapesInteractions;
        return this.nbEtapesInteractions;
    }

    public void ajoutStringListeInteraction(String s) {
        this.constList.add(this.createConstraint(s));
    }

    public String getLastInteraction() {
        return this.constList.get(this.constList.size() - 1).toString();
    }

    public Constraint addMove(int a, List<Integer> nbglst) {
        CNConstraint mov;
        int rank = this.searchMoveGlobalRank(a);
        int nbnbg = nbglst.size();
        int[] nbgtab = new int[nbnbg];
        int i = 0;
        while (i < nbnbg) {
            nbgtab[i] = nbglst.get(i);
            ++i;
        }
        if (rank != -1) {
            mov = (CNConstraint)this.constList.get(rank);
            mov.modify(a, nbgtab);
        } else {
            mov = new CNConstraint(rank, nbgtab, this.proj);
            this.constList.add(mov);
            ++this.nbMove;
        }
        return mov;
    }

    private int searchMoveGlobalRank(int a) {
        return this.searchConstraintGlobalRank(new CNConstraint.CNTrace(a));
    }

    private int getId(int globrank) {
        return this.constList.get(globrank).getId();
    }

    public Constraint addComparison(int a, int b, String rate) {
        C2Constraint comp;
        boolean greater = rate.startsWith(" > ");
        float d = Float.parseFloat(rate.substring(3));
        int rank = this.searchComparisonGlobalRank(a, b);
        if (rank != -1) {
            comp = (C2Constraint)this.constList.get(rank);
            comp.modify(a, b, d, greater);
        } else {
            comp = new C2Constraint(a, b, d, greater, this.proj);
            this.constList.add(comp);
            ++this.nbComp;
        }
        return comp;
    }

    private int searchComparisonGlobalRank(int a, int b) {
        return this.searchConstraintGlobalRank(new C2Constraint.C2Trace(a, b));
    }

    public C3Constraint searchAnomaly(int a, int b) {
        int rank = this.searchAnomalyGlobalRank(a, b);
        if (rank != -1) {
            return (C3Constraint)this.constList.get(rank);
        }
        return null;
    }

    public Constraint getConstraint(int rank) {
        return this.constList.get(rank);
    }

    public C3Constraint addAnomaly(int a, int b, int c, String rate) {
        C3Constraint an;
        boolean greater = rate.startsWith(" > ");
        float d = Float.parseFloat(rate.substring(3));
        int rank = this.searchAnomalyGlobalRank(a, b);
        if (rank == -1) {
            an = new C3Constraint(a, b, c, d, greater, this.proj);
            this.constList.add(an);
            ++this.nbAnomaly;
        } else {
            an = (C3Constraint)this.constList.get(rank);
            an.modify(a, b, c, d, greater);
        }
        return an;
    }

    private int searchAnomalyGlobalRank(int a, int b) {
        return this.searchConstraintGlobalRank(new C3Constraint.C3Trace(a, b));
    }

    private int searchConstraintGlobalRank(ConstraintTrace ct) {
        int rank = 0;
        while (rank < this.constList.size()) {
            if (this.constList.get(rank).fitTrace(ct)) {
                return rank;
            }
            ++rank;
        }
        return -1;
    }

    public void removeAllListeInteraction() {
        this.constList.clear();
        this.nbMove = 0;
        this.nbComp = 0;
        this.nbAnomaly = 0;
        this.nbEtapesInteractions = 1;
    }

    public void remove(Constraint c) {
        this.constList.remove(c);
    }

    public int getNbEtapesInteractions() {
        return this.nbEtapesInteractions;
    }

    public int getNbAnomaly() {
        return this.nbAnomaly;
    }

    public int getNbMove() {
        return this.nbMove;
    }

    public int getNbComp() {
        return this.nbComp;
    }

    public String toString() {
        StringBuffer strbuf = new StringBuffer();
        for (Constraint c : this.constList) {
            strbuf.append(String.valueOf(c.toString()) + "\n");
        }
        return strbuf.toString();
    }

    public List<String> getAnomalies() {
        ArrayList<String> lst = new ArrayList<String>();
        for (Constraint c : this.constList) {
            if (!(c instanceof C3Constraint)) continue;
            lst.add(c.toString());
        }
        return lst;
    }

    public List<String> getComparisons() {
        ArrayList<String> lst = new ArrayList<String>();
        for (Constraint c : this.constList) {
            if (!(c instanceof C2Constraint)) continue;
            lst.add(c.toString());
        }
        return lst;
    }

    public List<String> getMoves() {
        ArrayList<String> lst = new ArrayList<String>();
        for (Constraint c : this.constList) {
            if (!(c instanceof CNConstraint)) continue;
            lst.add(c.toString());
        }
        return lst;
    }

    public List<Constraint> getAllInteractions() {
        return this.constList;
    }
}

