/*
 * Decompiled with CFR 0.152.
 */
package explorer.compute.compute.projection;

import Jama.EigenvalueDecomposition;
import Jama.Matrix;
import explorer.compute.compute.projection.PMARDp;
import explorer.data.Common;
import explorer.data.SourceAttrVal;
import java.util.Random;

public class PMARDp_Boosting
extends PMARDp {
    private double[][] M;
    private double[] D;
    private double[][] w;
    private double confiance;
    private Matrix L;
    private int NbDims;
    private int tMax = 0;
    private int tBoost = 0;
    private int k;
    private int[] y;
    private int cpt = 0;
    private int T;

    public int getCpt() {
        return this.cpt;
    }

    public PMARDp_Boosting(SourceAttrVal src, float ardpDiff) {
        super(src, ardpDiff);
    }

    public PMARDp_Boosting(SourceAttrVal src) {
        super(src);
        this.ARDpDiff = 0.0f;
    }

    public int getK() {
        return this.k;
    }

    public void setK(int k) {
        this.k = k;
    }

    public int getT() {
        return this.T;
    }

    public void setT(int t) {
        this.T = t;
    }

    private void initPoids() {
        this.D = new double[this.nbObjects];
        int i = 0;
        while (i < this.nbObjects) {
            if (this.actifs[i]) {
                this.D[i] = 1.0 / (double)this.nbActifs;
            }
            ++i;
        }
    }

    private void calculPoids(int t) {
        double som = 0.0;
        int a = 0;
        while (a < this.nbObjects) {
            if (this.actifs[a]) {
                double exp = Math.exp((double)this.y[a] * this.confiance);
                this.D[a] = (double)Math.abs(this.y[a]) * (this.D[a] * exp);
            }
            ++a;
        }
        som = 0.0;
        a = 0;
        while (a < this.nbActifs) {
            if (this.actifs[a]) {
                som += this.D[a];
            }
            ++a;
        }
        a = 0;
        while (a < this.nbActifs) {
            if (this.actifs[a]) {
                this.D[a] = this.D[a] / som;
            }
            ++a;
        }
        this.w = new double[this.nbObjects][this.nbObjects];
        a = 0;
        while (a < this.nbObjects) {
            if (this.actifs[a]) {
                double aux = -((double)this.y[a]) * this.D[a];
                if (this.y[a] == 1) {
                    aux = this.ARDpDiff > 0.0f ? (aux *= (double)this.ARDpDiff) : 0.0;
                } else if (this.y[a] == -1) {
                    aux = this.D[a];
                }
                int b = a;
                while (b < this.nbObjects) {
                    if (this.actifs[b]) {
                        double delta = t == 0 ? (double)this.distProjected(a, b, this.NbDims, this.dataOrigine) : (double)this.distProjected(a, b, this.NbDims, this.dataProjected);
                        if (this.sigma != 0.0f) {
                            if (delta != 0.0 && a != b) {
                                this.w[a][b] = aux / Math.pow(delta, this.sigma);
                            }
                            this.w[b][a] = this.w[a][b];
                        }
                    }
                    ++b;
                }
            }
            ++a;
        }
    }

    private synchronized void calculY(int t) {
        double taux = 0.0;
        int nbBon = 0;
        float[] d1 = new float[this.nbObjects];
        int[] distrib = new int[this.dd.getNbClasses()];
        int[] cl = new int[this.nbObjects];
        Random rand = new Random();
        this.y = new int[this.nbObjects];
        int i = 0;
        while (i < this.nbObjects) {
            if (this.actifs[i]) {
                int j = 0;
                while (j < this.nbObjects) {
                    if (i != j && this.actifs[j]) {
                        d1[j] = t == 0 ? this.distProjected(i, j, this.NbDims, this.dataOrigine) : this.distProjected(i, j, this.NbDims, this.dataProjected);
                    } else {
                        d1[i] = -1.0f;
                    }
                    ++j;
                }
                float valrk = this.valeurRangK(d1, this.k);
                j = 0;
                while (j < this.dd.getNbClasses()) {
                    distrib[j] = 0;
                    ++j;
                }
                j = 0;
                while (j < this.nbObjects) {
                    if (d1[j] <= valrk && j != i && this.actifs[j]) {
                        int n = this.dd.getClassIndice(j);
                        distrib[n] = distrib[n] + 1;
                    }
                    ++j;
                }
                int maxCl = distrib[0];
                j = 0;
                while (j < this.dd.getNbClasses()) {
                    if (distrib[j] > maxCl) {
                        maxCl = distrib[j];
                    }
                    ++j;
                }
                int nbMax = 0;
                cl[i] = 0;
                j = 0;
                while (j < this.dd.getNbClasses()) {
                    if (distrib[j] == maxCl) {
                        ++nbMax;
                        cl[i] = j;
                    }
                    ++j;
                }
                if (nbMax > 1) {
                    int tailleMax = 0;
                    j = 0;
                    while (j < this.dd.getNbClasses()) {
                        if (distrib[j] == maxCl && tailleMax < this.dd.getClassSize(j)) {
                            tailleMax = this.dd.getClassSize(j);
                        }
                        ++j;
                    }
                    nbMax = 0;
                    cl[i] = 0;
                    j = 0;
                    while (j < this.dd.getNbClasses()) {
                        if (distrib[j] == maxCl && tailleMax == this.dd.getClassSize(j)) {
                            ++nbMax;
                            cl[i] = j;
                        }
                        ++j;
                    }
                    if (nbMax > 1) {
                        nbMax = rand.nextInt(nbMax);
                        cl[i] = 0;
                        j = 0;
                        while (nbMax >= 0) {
                            if (distrib[j] == maxCl && tailleMax == this.dd.getClassSize(j)) {
                                cl[i] = j;
                                --nbMax;
                            }
                            ++j;
                        }
                    }
                }
                if (cl[i] == this.dd.getClassIndice(i)) {
                    this.y[i] = -1;
                    ++nbBon;
                } else {
                    this.y[i] = 1;
                }
            } else {
                this.y[i] = 0;
            }
            ++i;
        }
        taux = this.calculTauxPoids(cl, this.dd.getClassIndices());
        if (this.aff) {
            System.out.println("Nombre de bonnes valeurs : " + nbBon);
        }
        if (nbBon > this.tMax) {
            this.tMax = nbBon;
            this.tBoost = t;
        }
        this.cpt = taux < 0.51 && taux > 0.49 ? ++this.cpt : 0;
        double log = Math.log((1.0 - taux) / taux);
        if (this.aff) {
            System.out.println("log = " + log);
        }
        this.confiance = 0.5 * log;
        if (this.aff) {
            System.out.println("conf = " + this.confiance);
        }
    }

    private double calculTauxPoids(int[] c1, int[] c2) {
        double taux = 0.0;
        int i = 0;
        while (i < this.nbObjects) {
            if (this.actifs[i] && c1[i] != c2[i]) {
                taux += this.D[i];
            }
            ++i;
        }
        if (this.aff) {
            System.out.println("Taux = " + taux);
        }
        return taux;
    }

    private synchronized void calculProjection(int t, Common parent) {
        int j;
        this.M = new double[this.NbDims][this.NbDims];
        int n = 0;
        while (n < this.NbDims) {
            int m = 0;
            while (m < this.NbDims) {
                this.M[n][m] = 0.0;
                ++m;
            }
            ++n;
        }
        int i = 0;
        while (i < this.nbObjects) {
            if (this.actifs[i]) {
                j = 0;
                while (j < this.nbObjects) {
                    if (i != j && this.actifs[j]) {
                        int n2 = 0;
                        while (n2 < this.NbDims) {
                            int m = n2;
                            while (m < this.NbDims) {
                                double a;
                                if (t == 0) {
                                    a = (this.dataOrigine[i][m] - this.dataOrigine[j][m]) * (this.dataOrigine[i][n2] - this.dataOrigine[j][n2]);
                                    double[] dArray = this.M[n2];
                                    int n3 = m;
                                    dArray[n3] = dArray[n3] + this.w[i][j] * a;
                                } else {
                                    a = (this.dataProjected[i][m] - this.dataProjected[j][m]) * (this.dataProjected[i][n2] - this.dataProjected[j][n2]);
                                    double[] dArray = this.M[n2];
                                    int n4 = m;
                                    dArray[n4] = dArray[n4] + this.w[i][j] * a;
                                }
                                ++m;
                            }
                            ++n2;
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        i = 0;
        while (i < this.NbDims) {
            j = i;
            while (j < this.NbDims) {
                this.M[j][i] = this.M[i][j];
                ++j;
            }
            ++i;
        }
        Matrix Mt = new Matrix(this.M);
        this.ed = new EigenvalueDecomposition(Mt, parent);
        this.creerProjection(t);
        double[][] vp = this.ed.getV2();
        if (this.L == null) {
            this.L = new Matrix(vp);
            this.L = this.L.times(this.L.transpose());
            this.L = this.L.times(this.confiance);
        } else {
            Matrix Lt = new Matrix(vp);
            Lt = Lt.times(Lt.transpose());
            this.L = this.L.plus(Lt.times(this.confiance));
        }
    }

    public synchronized void calculer(Common parent, int nbt, int nbdi, float Sig) {
        this.T = nbt;
        this.sigma = Sig;
        if (this.T > 0) {
            if (this.aff) {
                System.out.println("t = 1");
            }
            this.initDataOrigine();
            this.initPoids();
            this.NbDims = nbdi == 0 ? this.nbTermes : nbdi;
            this.condition.condition(this.dataOrigine);
            this.calculerMoyennes();
            this.calculY(0);
            this.calculPoids(0);
            this.calculProjection(0, parent);
            int t = 1;
            while (t < this.T) {
                if (this.aff) {
                    System.out.println("t = " + (t + 1));
                }
                this.condition.condition(this.dataOrigine);
                this.calculerMoyennes();
                this.calculY(t);
                this.calculPoids(t);
                this.calculProjection(t, parent);
                ++t;
            }
            if (this.aff) {
                System.out.println("Nombre bonne valeur maximum : " + this.tMax + " nombre d'essai pour l'max " + this.tBoost);
            }
        }
    }

    public synchronized void test(int[] cross, int nbg, boolean affichage) {
        this.initDataOrigine();
        this.calculerCentreGravite();
        this.test(cross, nbg, affichage, this.k, -1);
    }

    public synchronized void creerProjection(int t) {
        double[][] vp = this.ed.getV2();
        int i = 0;
        while (i < this.nbActifs) {
            int j = 0;
            while (j < this.NbDims) {
                float ss = 0.0f;
                int k = 0;
                while (k < this.NbDims) {
                    ss = t == 0 ? (ss += (float)vp[k][j] * this.dataOrigine[i][k]) : (ss += (float)vp[k][j] * this.dataProjected[i][k]);
                    ++k;
                }
                if (this.dataProjected == null) {
                    this.dataProjected = new float[this.nbObjects][this.nbTermes];
                }
                this.dataProjected[i][j] = ss;
                ++j;
            }
            ++i;
        }
    }
}

