/*
 * Decompiled with CFR 0.152.
 */
package explorer.compute.compute.projection;

import Jama.EigenvalueDecomposition;
import Jama.Matrix;
import explorer.compute.compute.projection.PMAttrVal;
import explorer.compute.compute.projection.PMFactory;
import explorer.compute.kernels.Kernel;
import explorer.data.Common;
import explorer.data.SourceAttrVal;

public class PMDualPCA
extends PMAttrVal {
    Kernel kernel = null;

    public void setKernel(Kernel kernel) {
        this.kernel = kernel;
    }

    @Override
    public void retourPremiereProjection3D(int[] axes) {
    }

    public PMDualPCA(SourceAttrVal src) {
        super(src, PMFactory.ACPDual);
    }

    @Override
    public int getNbDimensions() {
        return this.nbObjects;
    }

    @Override
    public void calculer() {
        this.initDataOrigine();
        this.condition.condition(this.dataOrigine);
        this.calculerMoyennes();
        if (this.kernel != null) {
            this.kernel.setMoyennes(this.moyennes);
            this.kernel.setData(this.dataOrigine);
        }
        double[][] matrice = new double[this.nbObjects][this.nbObjects];
        int i = 0;
        while (i < this.nbObjects) {
            int j = i;
            while (j < this.nbObjects) {
                float som;
                if (this.kernel == null) {
                    som = 0.0f;
                    int k = 0;
                    while (k < this.nbTermes) {
                        som += (this.dataOrigine[i][k] - this.moyennes[k]) * (this.dataOrigine[j][k] - this.moyennes[k]);
                        ++k;
                    }
                } else {
                    som = this.kernel.k(i, j);
                }
                matrice[i][j] = 1.0 * (double)(som /= 1.0f * (float)this.nbObjects);
                matrice[j][i] = 1.0 * (double)som;
                ++j;
            }
            ++i;
        }
        Matrix M = new Matrix(matrice);
        this.ed = new EigenvalueDecomposition(M, Common.getSingleton());
    }

    @Override
    public float[] projection(int rank, int[] dims) {
        int k;
        int j;
        int nbterme = ((SourceAttrVal)this.src).getNbAttACP();
        double[] iv = this.ed.getRealEigenvalues();
        double[][] vp = this.ed.getV2();
        float[] res = new float[dims.length];
        double[][] vecteur = new double[dims.length][nbterme];
        int i = 0;
        while (i < dims.length) {
            j = 0;
            while (j < nbterme) {
                double somex = 0.0;
                k = 0;
                while (k < this.dataOrigine.length) {
                    somex += vp[k][dims[i]] * (double)this.dataOrigine[k][j];
                    ++k;
                }
                vecteur[i][j] = somex / Math.sqrt(iv[dims[i]]);
                ++j;
            }
            ++i;
        }
        j = 0;
        while (j < dims.length) {
            float ss = 0.0f;
            k = 0;
            while (k < nbterme) {
                ss = (float)((double)ss + vecteur[j][k] * (double)this.dataOrigine[rank][k]);
                ++k;
            }
            res[j] = ss;
            ++j;
        }
        return res;
    }

    @Override
    public float[] projection(float[] coord, int[] dims) {
        int k;
        int j;
        int nbterme = ((SourceAttrVal)this.src).getNbAttACP();
        double[] iv = this.ed.getRealEigenvalues();
        double[][] vp = this.ed.getV2();
        float[] res = new float[dims.length];
        double[][] vecteur = new double[dims.length][nbterme];
        int i = 0;
        while (i < dims.length) {
            j = 0;
            while (j < nbterme) {
                double somex = 0.0;
                k = 0;
                while (k < this.dataOrigine.length) {
                    somex += vp[k][dims[i]] * (double)this.dataOrigine[k][j];
                    ++k;
                }
                vecteur[i][j] = somex / Math.sqrt(iv[dims[i]]);
                ++j;
            }
            ++i;
        }
        j = 0;
        while (j < dims.length) {
            float ss = 0.0f;
            k = 0;
            while (k < nbterme) {
                ss = (float)((double)ss + vecteur[j][k] * (double)coord[k]);
                ++k;
            }
            res[j] = ss;
            ++j;
        }
        return res;
    }

    @Override
    public float[] getPointVariable(int var, int[] dims) {
        int j;
        int nbterme = ((SourceAttrVal)this.src).getNbAttACP();
        double[] iv = this.ed.getRealEigenvalues();
        double[][] vp = this.ed.getV2();
        float[] res = new float[dims.length];
        double[][] vecteur = new double[dims.length][nbterme];
        int i = 0;
        while (i < dims.length) {
            j = 0;
            while (j < nbterme) {
                double somex = 0.0;
                int k = 0;
                while (k < this.dataOrigine.length) {
                    somex += vp[k][dims[i]] * (double)this.dataOrigine[k][j];
                    ++k;
                }
                vecteur[i][j] = somex / Math.sqrt(iv[dims[i]]);
                ++j;
            }
            ++i;
        }
        j = 0;
        while (j < dims.length) {
            res[j] = 0.0f;
            ++j;
        }
        j = 0;
        while (j < dims.length) {
            int n = j;
            res[n] = (float)((double)res[n] + Math.sqrt(iv[dims[j]]) * vecteur[var][dims[j]]);
            ++j;
        }
        return res;
    }

    private void projectionKernel(int[] axes) {
        double[] iv = this.ed.getRealEigenvalues();
        double[][] vp = this.ed.getV2();
        double[] v = new double[3];
        int nbind = Math.min(3, iv.length);
        int j = 0;
        while (j < nbind) {
            v[j] = Math.sqrt(iv[axes[j]]);
            ++j;
        }
        this.dataProjected3D = new float[this.nbActifs][3];
        int i = 0;
        while (i < this.nbActifs) {
            j = 0;
            while (j < nbind) {
                float ss = 0.0f;
                this.dataProjected3D[i][j] = ss = (float)(v[j] * vp[i][axes[j]]);
                ++j;
            }
            ++i;
        }
    }

    @Override
    public float[][] creerProjection3D(int[] axes) {
        if (this.kernel != null) {
            this.projectionKernel(axes);
        } else {
            int k;
            int j;
            int ind = 0;
            double[][] vp = this.ed.getV2();
            this.dataProjected3D = new float[this.nbActifs][3];
            double[] iv = this.ed.getRealEigenvalues();
            double[][] vecteur = new double[3][this.nbTermes];
            int i = 0;
            while (i < 3) {
                j = 0;
                while (j < this.nbTermes) {
                    double somex = 0.0;
                    k = 0;
                    while (k < this.nbObjects) {
                        if (this.actifs[k]) {
                            somex += vp[k][axes[i]] * (double)this.dataOrigine[k][j];
                        }
                        ++k;
                    }
                    vecteur[i][j] = somex / Math.sqrt(iv[axes[i]]);
                    ++j;
                }
                ++i;
            }
            i = 0;
            while (i < this.nbObjects) {
                if (this.actifs[i]) {
                    j = 0;
                    while (j < 3) {
                        float ss = 0.0f;
                        k = 0;
                        while (k < this.nbTermes) {
                            ss = (float)((double)ss + vecteur[j][k] * (double)this.dataOrigine[i][k]);
                            ++k;
                        }
                        this.dataProjected3D[ind][j] = ss;
                        ++j;
                    }
                    ++ind;
                }
                ++i;
            }
        }
        return this.dataProjected3D;
    }

    @Override
    public void creerProjection() {
        int k;
        int j;
        int ind = 0;
        double[][] vp = this.ed.getV2();
        this.dataProjected = new float[this.nbActifs][3];
        double[] iv = this.ed.getRealEigenvalues();
        double[][] vecteur = new double[this.getNbDimensions()][this.nbTermes];
        int i = 0;
        while (i < this.getNbDimensions()) {
            j = 0;
            while (j < this.nbTermes) {
                double somex = 0.0;
                k = 0;
                while (k < this.nbObjects) {
                    if (this.actifs[k]) {
                        somex += vp[k][i] * (double)this.dataOrigine[k][j];
                    }
                    ++k;
                }
                vecteur[i][j] = somex / Math.sqrt(iv[i]);
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < this.nbObjects) {
            j = 0;
            while (j < this.getNbDimensions()) {
                float ss = 0.0f;
                k = 0;
                while (k < this.nbTermes) {
                    ss = (float)((double)ss + vecteur[j][k] * (double)this.dataOrigine[i][k]);
                    ++k;
                }
                this.dataProjected[i][j] = ss;
                ++j;
            }
            ++ind;
            ++i;
        }
    }

    @Override
    public float[] getAxisProjection(int rank) {
        int k;
        float[] axisProj = new float[this.nbObjects];
        double[][] vp = this.ed.getV2();
        double[] iv = this.ed.getRealEigenvalues();
        double[] vecteur = new double[this.nbTermes];
        int j = 0;
        while (j < this.nbTermes) {
            double somex = 0.0;
            k = 0;
            while (k < this.nbObjects) {
                if (this.actifs[k]) {
                    somex += vp[k][rank] * (double)this.dataOrigine[k][j];
                }
                ++k;
            }
            vecteur[j] = somex / Math.sqrt(iv[rank]);
            ++j;
        }
        int i = 0;
        while (i < this.nbObjects) {
            k = 0;
            while (k < this.nbTermes) {
                int n = i;
                axisProj[n] = (float)((double)axisProj[n] + vecteur[k] * (double)this.dataOrigine[i][k]);
                ++k;
            }
            ++i;
        }
        return axisProj;
    }
}

