/*
 * Decompiled with CFR 0.152.
 */
package explorer.compute.compute.projection;

import explorer.compute.compute.projection.PMARDp;
import explorer.compute.compute.projection.PMARDp_Boosting;
import explorer.compute.compute.projection.PMAttrVal;
import explorer.compute.compute.projection.PMDirect;
import explorer.compute.compute.projection.PMDualPCA;
import explorer.compute.compute.projection.PMException;
import explorer.compute.compute.projection.PMKNNPCA;
import explorer.compute.compute.projection.PMKNNPCA_Boost;
import explorer.compute.compute.projection.PMKNNPCA_Boosting;
import explorer.compute.compute.projection.PMLDA;
import explorer.compute.compute.projection.PMLLE;
import explorer.compute.compute.projection.PMMDS;
import explorer.compute.compute.projection.PMPCA;
import explorer.compute.compute.projection.ProjectiveMethod;
import explorer.compute.compute.projection.conditionning.Conditioning;
import explorer.data.Source3DCoord;
import explorer.data.SourceAttrVal;
import explorer.data.SourceDist;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lib3d4j.data.Source;

public class PMFactory {
    public static int DIRECT = 100;
    public static int MDS = 200;
    public static int ACP = 1;
    public static int LDA = 2;
    public static int ARDp = 3;
    public static int ACPDual = 4;
    public static int ACPkNN = 5;
    public static int LLE = 6;
    private static PMFactory singleton = null;
    private List<ProjectiveMethod> projMeths = new ArrayList<ProjectiveMethod>();
    private Map<Integer, String> tnl = new HashMap<Integer, String>();
    private int idgen = 0;

    private PMFactory() {
        this.tnl.put(DIRECT, "pmdirect");
        this.tnl.put(MDS, "pmmds");
        this.tnl.put(ACP, "pmpca");
        this.tnl.put(ACPDual, "pmdualpca");
        this.tnl.put(LDA, "pmlda");
        this.tnl.put(ARDp, "pmard");
        this.tnl.put(LLE, "pmlle");
        this.tnl.put(ACPkNN, "pmknnpca");
    }

    public static PMFactory getSingleton() {
        if (singleton == null) {
            singleton = new PMFactory();
        }
        return singleton;
    }

    public String getTypeName(int idx) {
        return this.tnl.get(idx);
    }

    public PMDirect createPMDirect(Source3DCoord src) {
        PMDirect pm = null;
        try {
            pm = new PMDirect(src);
            this.addToList(pm);
        }
        catch (PMException pme) {
            System.out.println("Exception PMDirect");
        }
        return pm;
    }

    public PMMDS createPMMDSClassic(SourceDist src) {
        PMMDS pm = new PMMDS(src);
        this.addToList(pm);
        return pm;
    }

    public PMPCA createPMPCA(SourceAttrVal src, Conditioning c) {
        PMPCA pm = new PMPCA(src);
        pm.setConditionning(c);
        this.addToList(pm);
        return pm;
    }

    public PMDualPCA createPMDualPCA(SourceAttrVal src, Conditioning c) {
        PMDualPCA pm = new PMDualPCA(src);
        pm.setConditionning(c);
        this.addToList(pm);
        return pm;
    }

    public PMLDA createPMLDA(SourceAttrVal src, Conditioning c) {
        PMLDA pm = new PMLDA(src);
        pm.setConditionning(c);
        this.addToList(pm);
        return pm;
    }

    public PMARDp createPMARDp(SourceAttrVal src, Conditioning c, float sigma) {
        PMARDp pm = new PMARDp(src);
        pm.setConditionning(c);
        pm.setSigma(sigma);
        this.addToList(pm);
        return pm;
    }

    public PMARDp_Boosting createPMARDp_Boosting(SourceAttrVal src, Conditioning c, float diff) {
        PMARDp_Boosting pm = new PMARDp_Boosting(src, diff);
        pm.setConditionning(c);
        this.addToList(pm);
        return pm;
    }

    public PMLLE createPMLLE(SourceAttrVal src, Conditioning c, int sigma) {
        PMLLE pm = new PMLLE(src);
        pm.setConditionning(c);
        pm.setNbNeighbors(sigma);
        this.addToList(pm);
        return pm;
    }

    public PMKNNPCA createPMKNNPCA(SourceAttrVal src, Conditioning c, float diff) {
        PMKNNPCA pm = new PMKNNPCA(src);
        pm.setConditionning(c);
        pm.setKnnDiff(diff);
        this.addToList(pm);
        return pm;
    }

    public PMKNNPCA_Boost createPMKNNPCA_Boost(SourceAttrVal src, Conditioning c) {
        PMKNNPCA_Boost pm = new PMKNNPCA_Boost(src);
        pm.setConditionning(c);
        this.addToList(pm);
        return pm;
    }

    public PMKNNPCA_Boosting createPMKNNPCA_Boosting(SourceAttrVal src, Conditioning c, float diff) {
        PMKNNPCA_Boosting pm = new PMKNNPCA_Boosting(src);
        pm.setConditionning(c);
        pm.setKnnDiff(diff);
        this.addToList(pm);
        return pm;
    }

    public PMAttrVal createPMAV(SourceAttrVal src, int numeroMethode) {
        PMAttrVal pm = null;
        if (numeroMethode == ACP) {
            pm = new PMPCA(src);
        } else if (numeroMethode == ACPkNN) {
            pm = new PMKNNPCA(src);
        } else if (numeroMethode == LDA) {
            pm = new PMLDA(src);
        } else if (numeroMethode == ARDp) {
            pm = new PMARDp(src);
        } else if (numeroMethode == ACPDual) {
            pm = new PMDualPCA(src);
        }
        if (pm != null) {
            this.addToList(pm);
        }
        return pm;
    }

    public ProjectiveMethod createFromCrop(Source src, ProjectiveMethod pm) {
        if (pm instanceof PMDirect) {
            return this.createPMDirect((Source3DCoord)src);
        }
        if (pm instanceof PMMDS) {
            return this.createPMMDSClassic((SourceDist)src);
        }
        if (pm instanceof PMAttrVal) {
            PMAttrVal pmc = this.createPMAV((SourceAttrVal)src, pm.getType());
            pmc.setConditionning(((PMAttrVal)pm).getConditionning());
            if (pmc.getType() == ARDp) {
                pmc.setParameterValue(PMARDp.param_sigma, ((PMARDp)pm).sigma);
            } else if (pmc.getType() == ACPkNN) {
                pmc.setParameterValue(PMKNNPCA.param_knn, ((PMKNNPCA)pm).knn);
            }
            return pmc;
        }
        return null;
    }

    private void addToList(ProjectiveMethod pm) {
        if (pm.getId() == null) {
            pm.setId("PM" + ++this.idgen);
        }
        if (!this.projMeths.contains(pm)) {
            this.projMeths.add(pm);
        }
    }

    public List<ProjectiveMethod> getMethods() {
        return this.projMeths;
    }
}

