/*
 * Decompiled with CFR 0.152.
 */
package explorer.compute.compute.projection;

import Jama.EigenvalueDecomposition;
import Jama.Matrix;
import explorer.compute.compute.projection.PMAttrVal;
import explorer.compute.compute.projection.PMFactory;
import explorer.data.Common;
import explorer.data.SourceAttrVal;

public class PMKNNPCA
extends PMAttrVal {
    public static int param_knn = 0;
    protected float knn = 1.0f;
    protected float knnDiff;
    private boolean aff = false;

    @Override
    public void retourPremiereProjection3D(int[] axes) {
    }

    public PMKNNPCA(SourceAttrVal src) {
        super(src, PMFactory.ACPkNN);
        this.knnDiff = 0.0f;
    }

    public PMKNNPCA(SourceAttrVal src, float f, boolean b) {
        super(src, PMFactory.ACPkNN);
        this.knnDiff = f;
        this.aff = b;
    }

    public void setKnnDiff(float knnDiff) {
        this.knnDiff = knnDiff;
    }

    public float getKnnDiff() {
        return this.knnDiff;
    }

    @Override
    public int getNbDimensions() {
        return this.nbTermes;
    }

    @Override
    public void setParameterValue(int indice, float valeur) {
        if (indice == param_knn) {
            this.knn = valeur;
        }
    }

    @Override
    public void calculer() {
        Matrix M;
        int j;
        int m;
        int n;
        this.initDataOrigine();
        this.condition.condition(this.dataOrigine);
        this.calculerMoyennes();
        double[][] matrice = new double[this.nbTermes][this.nbTermes];
        String anomalie = "";
        float[][] distance = null;
        if (this.nbObjects < 1000) {
            distance = new float[this.nbObjects][this.nbObjects];
            n = 0;
            while (n < this.nbObjects) {
                m = n + 1;
                while (m < this.nbObjects) {
                    if (this.actifs[n] && this.actifs[m]) {
                        distance[n][m] = this.distpts(n, m, this.nbTermes);
                        distance[m][n] = distance[n][m];
                    }
                    ++m;
                }
                ++n;
            }
        }
        matrice = new double[this.nbTermes][this.nbTermes];
        int i = 0;
        while (i < this.nbTermes) {
            j = i;
            while (j < this.nbTermes) {
                matrice[i][j] = 0.0;
                ++j;
            }
            ++i;
        }
        int cpt = 0;
        float[] d1 = new float[this.nbObjects];
        n = 0;
        while (n < this.nbObjects) {
            if (this.actifs[n]) {
                i = 0;
                while (i < this.nbObjects) {
                    d1[i] = i != n && this.actifs[i] ? (distance == null ? this.distpts(n, i, this.nbTermes) : distance[i][n]) : -1.0f;
                    ++i;
                }
                float valrk = this.valeurRangK(d1, this.knn);
                boolean intrus = false;
                m = 0;
                while (m < this.nbObjects) {
                    if (m != n && this.dd.getClassIndice(n) != this.dd.getClassIndice(m) && this.actifs[m] && d1[m] > 0.0f && d1[m] <= valrk) {
                        ++cpt;
                        intrus = true;
                        i = 0;
                        while (i < this.nbTermes) {
                            j = i;
                            while (j < this.nbTermes) {
                                double[] dArray = matrice[i];
                                int n2 = j;
                                dArray[n2] = dArray[n2] + (double)((this.dataOrigine[n][j] - this.dataOrigine[m][j]) * (this.dataOrigine[n][i] - this.dataOrigine[m][i]));
                                ++j;
                            }
                            ++i;
                        }
                    }
                    ++m;
                }
                if (this.knnDiff > 0.0f && intrus) {
                    m = 0;
                    while (m < this.nbObjects) {
                        if (m != n && this.dd.getClassIndice(n) == this.dd.getClassIndice(m) && this.actifs[m] && d1[m] > 0.0f && d1[m] <= valrk) {
                            ++cpt;
                            i = 0;
                            while (i < this.nbTermes) {
                                j = i;
                                while (j < this.nbTermes) {
                                    double[] dArray = matrice[i];
                                    int n3 = j;
                                    dArray[n3] = dArray[n3] - (double)(this.knnDiff * (this.dataOrigine[n][j] - this.dataOrigine[m][j]) * (this.dataOrigine[n][i] - this.dataOrigine[m][i]));
                                    ++j;
                                }
                                ++i;
                            }
                        }
                        ++m;
                    }
                }
            }
            ++n;
        }
        i = 0;
        while (i < this.nbTermes) {
            j = i;
            while (j < this.nbTermes) {
                matrice[i][j] = matrice[i][j] / (double)(1.0f * (float)this.nbActifs);
                matrice[j][i] = matrice[i][j];
                ++j;
            }
            ++i;
        }
        if (!anomalie.equals("")) {
            System.out.println("Anomalies d'\ufffdtiquetage:\n" + anomalie);
        }
        if (!((M = new Matrix(matrice)).get(0, 0) > 0.0) && !(M.get(0, 0) <= 0.0)) {
            System.out.println("NaN m");
        }
        this.ed = new EigenvalueDecomposition(M, Common.getSingleton());
    }

    @Override
    public void creerProjection() {
        int ind = 0;
        double[][] vp = this.ed.getV2();
        this.dataProjected = new float[this.nbObjects][this.getNbDimensions()];
        int i = 0;
        while (i < this.nbObjects) {
            int j = 0;
            while (j < this.getNbDimensions()) {
                float ss = 0.0f;
                int k = 0;
                while (k < this.nbTermes) {
                    ss = (float)((double)ss + vp[k][j] * (double)this.dataOrigine[i][k]);
                    ++k;
                }
                this.dataProjected[i][j] = ss;
                ++j;
            }
            ++ind;
            ++i;
        }
    }

    @Override
    public float[] projection(int rank, int[] dims) {
        double[][] vp = this.ed.getV2();
        float[] res = new float[dims.length];
        int j = 0;
        while (j < dims.length) {
            float ss = 0.0f;
            int k = 0;
            while (k < this.nbTermes) {
                ss = (float)((double)ss + vp[k][dims[j]] * (double)this.dataOrigine[rank][k]);
                ++k;
            }
            res[j] = ss;
            ++j;
        }
        return res;
    }

    @Override
    public float[] projection(float[] coord, int[] dims) {
        double[][] vp = this.ed.getV2();
        float[] res = new float[dims.length];
        int j = 0;
        while (j < dims.length) {
            float ss = 0.0f;
            int k = 0;
            while (k < this.nbTermes) {
                ss = (float)((double)ss + vp[k][dims[j]] * (double)coord[k]);
                ++k;
            }
            res[j] = ss;
            ++j;
        }
        return res;
    }

    @Override
    public float[] getAxisProjection(int rank) {
        float[] axisProj = new float[this.nbObjects];
        double[][] vp = this.ed.getV2();
        int i = 0;
        while (i < this.nbObjects) {
            axisProj[i] = 0.0f;
            int k = 0;
            while (k < this.nbTermes) {
                int n = i;
                axisProj[n] = (float)((double)axisProj[n] + vp[k][rank] * (double)this.dataOrigine[i][k]);
                ++k;
            }
            ++i;
        }
        return axisProj;
    }

    @Override
    public float[] getPointVariable(int var, int[] dims) {
        double[][] vp = this.ed.getV2();
        double[] iv = this.ed.getRealEigenvalues();
        float[] res = new float[dims.length];
        int j = 0;
        while (j < dims.length) {
            res[j] = 0.0f;
            ++j;
        }
        j = 0;
        while (j < dims.length) {
            int n = j;
            res[n] = (float)((double)res[n] + Math.sqrt(iv[dims[j]]) * vp[var][dims[j]]);
            ++j;
        }
        return res;
    }

    protected float distpts(int i, int j, int nb) {
        float som = 0.0f;
        int n = 0;
        while (n < nb) {
            som += (this.dataOrigine[i][n] - this.dataOrigine[j][n]) * (this.dataOrigine[i][n] - this.dataOrigine[j][n]);
            ++n;
        }
        double d = som;
        d = Math.sqrt(d);
        return (float)d;
    }

    public void setAff(boolean aff) {
        this.aff = aff;
    }

    public boolean isAff() {
        return this.aff;
    }
}

