/*
 * Decompiled with CFR 0.152.
 */
package explorer.compute.compute.projection;

import Jama.EigenvalueDecomposition;
import Jama.Matrix;
import explorer.compute.compute.projection.PMKNNPCA;
import explorer.data.Common;
import explorer.data.SourceAttrVal;
import java.util.Random;

public class PMKNNPCA_Boosting
extends PMKNNPCA {
    private double[][] M;
    private double[] D;
    private double[][] w;
    private int[] y;
    private double confiance;
    private Matrix L;
    private int NbDims;
    private int tMax = 0;
    private int tBoost = 0;
    private int k;
    private int cpt;
    private int T;

    public int getCpt() {
        return this.cpt;
    }

    public int getT() {
        return this.T;
    }

    public void setT(int t) {
        this.T = t;
    }

    public PMKNNPCA_Boosting(SourceAttrVal src) {
        super(src);
        this.knnDiff = 0.0f;
    }

    public PMKNNPCA_Boosting(SourceAttrVal src, float fl, boolean b) {
        super(src, fl, b);
    }

    private void initPoids() {
        this.D = new double[this.nbObjects];
        int i = 0;
        while (i < this.nbObjects) {
            this.D[i] = this.actifs[i] ? 1.0 / (double)this.nbActifs : 0.0;
            ++i;
        }
    }

    private void calculPoids(int t) {
        double som = 0.0;
        int a = 0;
        while (a < this.nbObjects) {
            if (this.actifs[a]) {
                double exp = Math.exp((double)this.y[a] * this.confiance);
                this.D[a] = (double)Math.abs(this.y[a]) * (this.D[a] * exp);
            }
            ++a;
        }
        som = 0.0;
        a = 0;
        while (a < this.nbActifs) {
            if (this.actifs[a]) {
                som += this.D[a];
            }
            ++a;
        }
        a = 0;
        while (a < this.nbActifs) {
            if (this.actifs[a]) {
                this.D[a] = this.D[a] / som;
            }
            ++a;
        }
        this.w = new double[this.nbObjects][this.nbObjects];
        a = 0;
        while (a < this.nbObjects) {
            if (this.actifs[a]) {
                double aux = -((double)this.y[a]) * this.D[a];
                if (this.y[a] == 1) {
                    aux = this.knnDiff > 0.0f ? (aux *= (double)this.knnDiff) : 0.0;
                }
                int b = a;
                while (b < this.nbObjects) {
                    if (this.actifs[b] && a != b) {
                        this.w[a][b] = aux;
                        this.w[b][a] = this.w[a][b];
                    }
                    ++b;
                }
            }
            ++a;
        }
    }

    private void calculY(int t) {
        double taux = 0.0;
        int nbBon = 0;
        float[] d1 = new float[this.nbObjects];
        int[] distrib = new int[this.dd.getNbClasses()];
        int[] cl = new int[this.nbObjects];
        Random rand = new Random();
        this.y = new int[this.nbObjects];
        int i = 0;
        while (i < this.nbObjects) {
            if (this.actifs[i]) {
                int j = 0;
                while (j < this.nbObjects) {
                    if (i != j && this.actifs[j]) {
                        d1[j] = t == 0 ? this.distProjected(i, j, this.getNbDimensions(), this.dataOrigine) : this.distProjected(i, j, this.getNbDimensions(), this.dataProjected);
                    } else {
                        d1[i] = -1.0f;
                    }
                    ++j;
                }
                float valrk = this.valeurRangK(d1, this.k);
                j = 0;
                while (j < this.dd.getNbClasses()) {
                    distrib[j] = 0;
                    ++j;
                }
                j = 0;
                while (j < this.nbObjects) {
                    if (d1[j] <= valrk && j != i && this.actifs[j]) {
                        int n = this.dd.getClassIndice(j);
                        distrib[n] = distrib[n] + 1;
                    }
                    ++j;
                }
                int maxCl = distrib[0];
                j = 0;
                while (j < this.dd.getNbClasses()) {
                    if (distrib[j] > maxCl) {
                        maxCl = distrib[j];
                    }
                    ++j;
                }
                int nbMax = 0;
                cl[i] = 0;
                j = 0;
                while (j < this.dd.getNbClasses()) {
                    if (distrib[j] == maxCl) {
                        ++nbMax;
                        cl[i] = j;
                    }
                    ++j;
                }
                if (nbMax > 1) {
                    int tailleMax = 0;
                    j = 0;
                    while (j < this.dd.getNbClasses()) {
                        if (distrib[j] == maxCl && tailleMax < this.dd.getClassSize(j)) {
                            tailleMax = this.dd.getClassSize(j);
                        }
                        ++j;
                    }
                    nbMax = 0;
                    cl[i] = 0;
                    j = 0;
                    while (j < this.dd.getNbClasses()) {
                        if (distrib[j] == maxCl && tailleMax == this.dd.getClassSize(j)) {
                            ++nbMax;
                            cl[i] = j;
                        }
                        ++j;
                    }
                    if (nbMax > 1) {
                        nbMax = rand.nextInt(nbMax);
                        cl[i] = 0;
                        j = 0;
                        while (nbMax >= 0) {
                            if (distrib[j] == maxCl && tailleMax == this.dd.getClassSize(j)) {
                                cl[i] = j;
                                --nbMax;
                            }
                            ++j;
                        }
                    }
                }
                if (this.actifs[i]) {
                    if (cl[i] == this.dd.getClassIndice(i)) {
                        this.y[i] = -1;
                        ++nbBon;
                    } else {
                        this.y[i] = 1;
                    }
                } else {
                    this.y[i] = 0;
                }
            }
            ++i;
        }
        taux = this.calculTauxPoids(cl, this.dd.getClassIndices());
        if (this.isAff()) {
            System.out.println("Nombre de bonnes valeurs : " + nbBon);
        }
        if (taux <= 0.0 && t != 0) {
            if (this.isAff()) {
                System.out.println("Erreur au niveau du taux.");
            }
            System.exit(-1);
        }
        if (nbBon > this.tMax) {
            this.tMax = nbBon;
            this.tBoost = t;
        }
        this.cpt = taux > 0.49 && taux < 0.51 ? ++this.cpt : 0;
        double log = Math.log((1.0 - taux) / taux);
        if (this.isAff()) {
            System.out.println("log = " + log);
        }
        this.confiance = log / 2.0;
        if (this.isAff()) {
            System.out.println("conf = " + this.confiance);
        }
    }

    private double calculTauxPoids(int[] c1, int[] c2) {
        double taux = 0.0;
        int i = 0;
        while (i < this.nbObjects) {
            if (this.actifs[i] && c1[i] != c2[i]) {
                taux += this.D[i];
            }
            ++i;
        }
        if (this.isAff()) {
            System.out.println("Taux = " + taux);
        }
        return taux;
    }

    private void calculProjection(int t, Common parent) {
        int j;
        this.M = new double[this.NbDims][this.NbDims];
        int i = 0;
        while (i < this.nbTermes) {
            j = i;
            while (j < this.nbTermes) {
                this.M[i][j] = 0.0;
                ++j;
            }
            ++i;
        }
        int cpt = 0;
        float[] d1 = new float[this.nbObjects];
        int n = 0;
        while (n < this.nbObjects) {
            if (this.actifs[n]) {
                i = 0;
                while (i < this.nbObjects) {
                    d1[i] = i != n && this.actifs[i] ? this.distpts(n, i, this.nbTermes) : -1.0f;
                    ++i;
                }
                float valrk = this.valeurRangK(d1, this.knn);
                int m = 0;
                while (m < this.nbObjects) {
                    if (m != n && this.actifs[m] && d1[m] > 0.0f && d1[m] <= valrk) {
                        ++cpt;
                        i = 0;
                        while (i < this.nbTermes) {
                            j = i;
                            while (j < this.nbTermes) {
                                double[] dArray = this.M[i];
                                int n2 = j;
                                dArray[n2] = dArray[n2] + this.w[i][j] * (double)(this.dataOrigine[n][j] - this.dataOrigine[m][j]) * (double)(this.dataOrigine[n][i] - this.dataOrigine[m][i]);
                                ++j;
                            }
                            ++i;
                        }
                    }
                    ++m;
                }
            }
            ++n;
        }
        i = 0;
        while (i < this.nbTermes) {
            j = i;
            while (j < this.nbTermes) {
                this.M[i][j] = this.M[i][j] / (double)(1.0f * (float)this.nbActifs);
                this.M[j][i] = this.M[i][j];
                ++j;
            }
            ++i;
        }
        Matrix Mt = new Matrix(this.M);
        this.ed = new EigenvalueDecomposition(Mt, parent);
        this.creerProjection(t);
        double[][] vp = this.ed.getV2();
        if (this.L == null) {
            this.L = new Matrix(vp);
            this.L = this.L.times(this.L.transpose());
            this.L = this.L.times(this.confiance);
        } else {
            Matrix Lt = new Matrix(vp);
            Lt = Lt.times(Lt.transpose());
            this.L = this.L.plus(Lt.times(this.confiance));
        }
    }

    @Override
    public void test(int[] cross, int nbg, boolean affichage, int knn) {
        this.initDataOrigine();
        this.calculerCentreGravite();
        this.test(cross, nbg, affichage, knn, -1);
    }

    public void calculer(Common parent, int nbt, int nbdi, int k1) {
        this.k = k1;
        this.NbDims = nbdi == 0 ? this.getNbDimensions() : nbdi;
        this.T = nbt;
        if (this.isAff()) {
            System.out.println("t = 1");
        }
        this.initPoids();
        this.initDataOrigine();
        this.condition.condition(this.dataOrigine);
        this.calculerMoyennes();
        this.calculY(0);
        this.calculPoids(0);
        this.calculProjection(0, parent);
        int t = 1;
        while (t < this.T) {
            if (this.isAff()) {
                System.out.println("t = " + (t + 1));
            }
            this.condition.condition(this.dataOrigine);
            this.calculerMoyennes();
            this.calculY(t);
            this.calculPoids(t);
            this.calculProjection(t, parent);
            ++t;
        }
        if (this.isAff()) {
            System.out.println("Nombre bonne val max : " + this.tMax + " nombre d'essai pour l'max " + (this.tBoost + 1) + "\nFin");
        }
    }

    public int[] indiceKnnSameLabel(int j, int t) {
        boolean init = false;
        float[] res = new float[this.k];
        int i = 0;
        while (i < this.nbObjects && !init) {
            if (this.actifs[i] && i != j) {
                init = true;
                float aux = t == 0 ? this.distProjected(j, i, this.NbDims, this.dataOrigine) : this.distProjected(j, i, this.NbDims, this.dataProjected);
                res[0] = aux;
            }
            ++i;
        }
        int[] indRes = new int[this.k];
        float d1 = 0.0f;
        int LabelJ = this.dd.getClassIndice(j);
        int i2 = 0;
        while (i2 < this.nbObjects) {
            if (this.actifs[i2] && i2 != j && this.dd.getClassIndice(i2) == LabelJ && res[0] > (d1 = t == 0 ? this.distProjected(j, i2, this.NbDims, this.dataOrigine) : this.distProjected(j, i2, this.NbDims, this.dataProjected))) {
                res[0] = d1;
                indRes[0] = i2;
            }
            ++i2;
        }
        int nb = 1;
        while (nb < this.k) {
            int i3 = 0;
            while (i3 < this.nbActifs) {
                if (i3 != j && this.actifs[i3] && (d1 = t == 0 ? this.distProjected(j, i3, this.NbDims, this.dataOrigine) : this.distProjected(j, i3, this.NbDims, this.dataProjected)) >= res[nb - 1] && (res[nb] > d1 || res[nb] == -1.0f) && this.dd.getClassIndice(i3) == LabelJ && i3 != indRes[nb - 1]) {
                    res[nb] = d1;
                    indRes[nb] = i3;
                }
                ++i3;
            }
            ++nb;
        }
        return indRes;
    }

    public int[] indiceKnnDifferentLabel(int j, int t) {
        float[] res = new float[this.k];
        int i = 0;
        while (i < this.k) {
            res[i] = -1.0f;
            ++i;
        }
        int[] indRes = new int[this.k];
        float d1 = 0.0f;
        int LabelJ = this.dd.getClassIndice(j);
        int i2 = 0;
        while (i2 < this.nbObjects) {
            if (this.actifs[i2] && i2 != j && this.dd.getClassIndice(i2) != LabelJ) {
                d1 = t == 0 ? this.distProjected(j, i2, this.NbDims, this.dataOrigine) : this.distProjected(j, i2, this.NbDims, this.dataProjected);
                if (res[0] == -1.0f || res[0] > d1) {
                    res[0] = d1;
                    indRes[0] = i2;
                }
            }
            ++i2;
        }
        int nb = 1;
        while (nb < this.k) {
            int i3 = 0;
            while (i3 < this.nbActifs) {
                if (i3 != j && this.actifs[i3] && (d1 = t == 0 ? this.distProjected(j, i3, this.NbDims, this.dataOrigine) : this.distProjected(j, i3, this.NbDims, this.dataProjected)) >= res[nb - 1] && (res[nb] > d1 || res[nb] == -1.0f) && this.dd.getClassIndice(i3) != LabelJ && i3 != indRes[nb - 1]) {
                    res[nb] = d1;
                    indRes[nb] = i3;
                }
                ++i3;
            }
            ++nb;
        }
        return indRes;
    }

    public void knn_calcul(Common parent, double e, int k, int[] cross, int nbg, int T, int nbd) {
    }

    public void creerProjection(int t) {
        if (this.dataProjected == null) {
            this.dataProjected = new float[this.nbObjects][this.nbTermes];
        }
        double[][] vp = this.ed.getV2();
        int i = 0;
        while (i < this.nbActifs) {
            int j = 0;
            while (j < this.NbDims) {
                float ss = 0.0f;
                int k = 0;
                while (k < this.NbDims) {
                    ss = t == 0 ? (ss += (float)vp[k][j] * this.dataOrigine[i][k]) : (ss += (float)vp[k][j] * this.dataProjected[i][k]);
                    ++k;
                }
                this.dataProjected[i][j] = ss;
                ++j;
            }
            ++i;
        }
    }
}

