/*
 * Decompiled with CFR 0.152.
 */
package explorer.compute.compute.projection;

import Jama.EigenvalueDecomposition;
import Jama.LUDecomposition;
import Jama.Matrix;
import explorer.compute.compute.projection.PMAttrVal;
import explorer.compute.compute.projection.PMFactory;
import explorer.compute.kernels.Kernel;
import explorer.data.Common;
import explorer.data.SourceAttrVal;
import lib3d4j.compute.tools.OutilsAlgebre;

public class PMLLE
extends PMAttrVal {
    private float[][] matriceScalaireBase = null;
    private int nbNeighbors = 3;
    private float epsilon = 0.1f;
    private float[][] matriceDistanceBase = null;
    private Matrix M1 = null;
    private Common parent = null;

    public PMLLE(SourceAttrVal src) {
        super(src, PMFactory.LLE);
    }

    @Override
    public void retourPremiereProjection3D(int[] axes) {
    }

    private static float[][] createScalaireMatrix(float[][] distance) {
        float val;
        int j;
        float moy = 0.0f;
        float[] moyLigne = new float[distance.length];
        int i = 0;
        while (i < distance.length) {
            moyLigne[i] = 0.0f;
            j = 0;
            while (j < distance.length) {
                if (i != j) {
                    val = distance[i][j];
                    moy -= val * val / 2.0f;
                    int n = i;
                    moyLigne[n] = moyLigne[n] - val * val / 2.0f;
                }
                ++j;
            }
            moyLigne[i] = moyLigne[i] / (float)distance.length;
            ++i;
        }
        moy /= (float)(distance.length * distance.length);
        float[][] matrice = new float[distance.length][distance.length];
        i = 0;
        while (i < distance.length) {
            j = i;
            while (j < distance.length) {
                val = distance[i][j];
                matrice[i][j] = -val * val / 2.0f - moyLigne[i] - moyLigne[j] + moy;
                matrice[j][i] = matrice[i][j];
                ++j;
            }
            ++i;
        }
        return matrice;
    }

    private int[][] searchVoisin(float[][] distance) {
        int[][] indexVoisin = new int[this.nbObjects][this.nbNeighbors];
        float[] dist = new float[this.nbObjects];
        int[] index = new int[this.nbObjects];
        int i = 0;
        while (i < this.nbObjects) {
            int j = 0;
            while (j < this.nbObjects) {
                dist[j] = distance[i][j];
                index[j] = j;
                ++j;
            }
            Kernel.quicksort(dist, index, 0, this.nbObjects - 1);
            j = 0;
            while (j < this.nbNeighbors) {
                indexVoisin[i][j] = index[j + 1];
                ++j;
            }
            ++i;
        }
        return indexVoisin;
    }

    private void createMatrixDistanceBase() {
        this.matriceDistanceBase = new float[this.nbObjects][this.nbObjects];
        int i = 0;
        while (i < this.nbObjects) {
            int j = 0;
            while (j < this.nbObjects) {
                this.matriceDistanceBase[i][j] = OutilsAlgebre.distance(this.dataOrigine[i], this.dataOrigine[j]);
                ++j;
            }
            ++i;
        }
    }

    @Override
    public void calculer() {
        this.initDataOrigine();
        this.condition.condition(this.dataOrigine);
        this.calculerMoyennes();
        this.parent = this.parent;
        if (this.matriceDistanceBase == null) {
            this.createMatrixDistanceBase();
        }
        this.matriceScalaireBase = PMLLE.createScalaireMatrix(this.matriceDistanceBase);
        int[][] indexVoisin = this.searchVoisin(this.matriceDistanceBase);
        float[][] W = new float[this.nbObjects][this.nbObjects];
        Matrix G = new Matrix(this.nbNeighbors, this.nbNeighbors);
        Matrix ident = Matrix.identity(this.nbNeighbors, this.nbNeighbors);
        ident = ident.times(this.epsilon);
        int x = 0;
        while (x < this.nbObjects) {
            Matrix G1;
            int i = 0;
            while (i < this.nbNeighbors) {
                int j = 0;
                while (j < this.nbNeighbors) {
                    float somme = this.matriceScalaireBase[x][x] - this.matriceScalaireBase[x][indexVoisin[x][j]] - this.matriceScalaireBase[indexVoisin[x][i]][x] + this.matriceScalaireBase[indexVoisin[x][i]][indexVoisin[x][j]];
                    G.set(i, j, somme);
                    ++j;
                }
                ++i;
            }
            LUDecomposition test = new LUDecomposition(G);
            if (test.isNonsingular()) {
                G1 = G.inverse();
            } else {
                G = G.plus(ident);
                G1 = G.inverse();
            }
            Matrix w = new Matrix(this.nbNeighbors, 1, 0.0);
            Matrix un = new Matrix(this.nbNeighbors, 1, 1.0);
            w = G1.times(un);
            float somme3 = 0.0f;
            int i2 = 0;
            while (i2 < this.nbNeighbors) {
                somme3 = (float)((double)somme3 + w.get(i2, 0));
                ++i2;
            }
            i2 = 0;
            while (i2 < this.nbObjects) {
                W[x][i2] = 0.0f;
                int j = 0;
                while (j < this.nbNeighbors) {
                    if (indexVoisin[x][j] == i2) {
                        W[x][i2] = (float)w.get(j, 0) / somme3;
                    }
                    ++j;
                }
                ++i2;
            }
            ++x;
        }
        this.M1 = new Matrix(this.nbObjects, this.nbObjects);
        Matrix ident2 = Matrix.identity(this.nbObjects, this.nbObjects);
        int i = 0;
        while (i < this.nbObjects) {
            int j = 0;
            while (j < this.nbObjects) {
                float somme = 0.0f;
                int k = 0;
                while (k < this.nbObjects) {
                    somme += W[k][i] * W[k][j];
                    ++k;
                }
                this.M1.set(i, j, ident2.get(i, j) - (double)W[i][j] - (double)W[j][i] + (double)somme);
                ++j;
            }
            ++i;
        }
    }

    @Override
    public void creerProjection() {
        this.ed = new EigenvalueDecomposition(this.M1, this.parent);
        double[][] eigenVector = this.ed.getV2();
        int size = eigenVector[0].length;
        this.dataProjected3D = new float[this.nbObjects][3];
        int i = 0;
        while (i < this.nbObjects) {
            this.dataProjected3D[i][0] = (float)eigenVector[i][size - 2];
            this.dataProjected3D[i][1] = (float)eigenVector[i][size - 3];
            this.dataProjected3D[i][2] = (float)eigenVector[i][size - 4];
            ++i;
        }
    }

    @Override
    public float[] getAxisProjection(int rank) {
        float[] axisProj = new float[this.nbObjects];
        double[][] eigenVector = this.ed.getV2();
        int size = eigenVector[0].length;
        int i = 0;
        while (i < this.nbObjects) {
            axisProj[i] = 0.0f;
            int k = 0;
            while (k < this.nbTermes) {
                int n = i;
                axisProj[n] = axisProj[n] + (float)eigenVector[i][size - 2 - rank];
                ++k;
            }
            ++i;
        }
        return axisProj;
    }

    @Override
    public float[][] creerProjection3D(int[] axes) {
        this.creerProjection();
        return this.dataProjected3D;
    }

    @Override
    public int getNbDimensions() {
        return this.nbObjects;
    }

    @Override
    public float[] getPointVariable(int var, int[] dims) {
        int j;
        int nbterme = ((SourceAttrVal)this.src).getNbAttACP();
        double[] iv = this.ed.getRealEigenvalues();
        double[][] vp = this.ed.getV2();
        float[] res = new float[dims.length];
        double[][] vecteur = new double[dims.length][nbterme];
        int i = 0;
        while (i < dims.length) {
            j = 0;
            while (j < nbterme) {
                double somex = 0.0;
                int k = 0;
                while (k < this.dataOrigine.length) {
                    somex += vp[k][dims[i]] * (double)this.dataOrigine[k][j];
                    ++k;
                }
                vecteur[i][j] = somex / Math.sqrt(iv[dims[i]]);
                ++j;
            }
            ++i;
        }
        j = 0;
        while (j < dims.length) {
            res[j] = 0.0f;
            ++j;
        }
        j = 0;
        while (j < dims.length) {
            int n = j;
            res[n] = (float)((double)res[n] + Math.sqrt(iv[dims[j]]) * vecteur[var][dims[j]]);
            ++j;
        }
        return res;
    }

    @Override
    public float[] projection(int rank, int[] dims) {
        int k;
        int j;
        int nbterme = ((SourceAttrVal)this.src).getNbAttACP();
        double[] iv = this.ed.getRealEigenvalues();
        double[][] vp = this.ed.getV2();
        float[] res = new float[dims.length];
        double[][] vecteur = new double[dims.length][nbterme];
        int i = 0;
        while (i < dims.length) {
            j = 0;
            while (j < nbterme) {
                double somex = 0.0;
                k = 0;
                while (k < this.dataOrigine.length) {
                    somex += vp[k][dims[i]] * (double)this.dataOrigine[k][j];
                    ++k;
                }
                vecteur[i][j] = somex / Math.sqrt(iv[dims[i]]);
                ++j;
            }
            ++i;
        }
        j = 0;
        while (j < dims.length) {
            float ss = 0.0f;
            k = 0;
            while (k < nbterme) {
                ss = (float)((double)ss + vecteur[j][k] * (double)this.dataOrigine[rank][k]);
                ++k;
            }
            res[j] = ss;
            ++j;
        }
        return res;
    }

    @Override
    public float[] projection(float[] coord, int[] dims) {
        int k;
        int j;
        int nbterme = ((SourceAttrVal)this.src).getNbAttACP();
        double[] iv = this.ed.getRealEigenvalues();
        double[][] vp = this.ed.getV2();
        float[] res = new float[dims.length];
        double[][] vecteur = new double[dims.length][nbterme];
        int i = 0;
        while (i < dims.length) {
            j = 0;
            while (j < nbterme) {
                double somex = 0.0;
                k = 0;
                while (k < this.dataOrigine.length) {
                    somex += vp[k][dims[i]] * (double)this.dataOrigine[k][j];
                    ++k;
                }
                vecteur[i][j] = somex / Math.sqrt(iv[dims[i]]);
                ++j;
            }
            ++i;
        }
        j = 0;
        while (j < dims.length) {
            float ss = 0.0f;
            k = 0;
            while (k < nbterme) {
                ss = (float)((double)ss + vecteur[j][k] * (double)coord[k]);
                ++k;
            }
            res[j] = ss;
            ++j;
        }
        return res;
    }

    public void setNbNeighbors(int nbnbg) {
        this.nbNeighbors = nbnbg;
    }

    public int getNbNeighbors() {
        return this.nbNeighbors;
    }
}

