/*
 * Decompiled with CFR 0.152.
 */
package explorer.compute.compute.projection;

import Jama.EigenvalueDecomposition;
import Jama.Matrix;
import explorer.compute.compute.projection.PMFactory;
import explorer.compute.compute.projection.ProjectiveMethod;
import explorer.compute.kernels.Kernel;
import explorer.data.Common;
import explorer.data.SourceDist;

public class PMMDS
extends ProjectiveMethod {
    private double[][] matrice;
    protected Kernel noyau;

    public PMMDS(SourceDist src) {
        super(src, PMFactory.MDS);
        this.src = src;
        this.nbTermes = 3;
    }

    @Override
    public void calculer() {
        if (this.noyau != null) {
            this.noyau.setMatriceDistance(((SourceDist)this.src).getMatrix());
            this.matrice = this.noyau.getScalaireMatrix();
        } else {
            float val;
            int j;
            float moy = 0.0f;
            float[] moyLigne = new float[this.nbObjects];
            int i = 0;
            while (i < this.nbObjects) {
                boolean oki = true;
                if (oki) {
                    moyLigne[i] = 0.0f;
                    j = 0;
                    while (j < this.nbObjects) {
                        boolean okj;
                        if (i != j && (okj = true)) {
                            val = ((SourceDist)this.src).getValue(i, j);
                            moy -= val * val / 2.0f;
                            int n = i;
                            moyLigne[n] = moyLigne[n] - val * val / 2.0f;
                        }
                        ++j;
                    }
                    moyLigne[i] = moyLigne[i] / (float)this.nbObjects;
                }
                ++i;
            }
            moy /= (float)(this.nbObjects * this.nbObjects);
            this.matrice = new double[this.nbObjects][this.nbObjects];
            i = 0;
            while (i < this.nbObjects) {
                j = i;
                while (j < this.nbObjects) {
                    val = ((SourceDist)this.src).getValue(i, j);
                    this.matrice[i][j] = -val * val / 2.0f - moyLigne[i] - moyLigne[j] + moy;
                    if (((SourceDist)this.src).isComplete()) {
                        val = ((SourceDist)this.src).getValue(j, i);
                        this.matrice[j][i] = -val * val / 2.0f - moyLigne[i] - moyLigne[j] + moy;
                    } else {
                        this.matrice[j][i] = this.matrice[i][j];
                    }
                    ++j;
                }
                ++i;
            }
        }
        Matrix M = new Matrix(this.matrice);
        this.ed = new EigenvalueDecomposition(M, Common.getSingleton());
    }

    @Override
    public float[][] creerProjection3D(int[] axes) {
        int nbtot = this.src.getNbObjects();
        double[] iv = this.ed.getRealEigenvalues();
        double[][] vp = this.ed.getV2();
        double[] v = new double[3];
        int nbeffectif = nbtot;
        if (axes.length != 3) {
            return null;
        }
        int nbind = Math.min(3, iv.length);
        int j = 0;
        while (j < nbind) {
            v[j] = Math.sqrt(iv[axes[j]]);
            ++j;
        }
        this.dataProjected3D = new float[nbeffectif][3];
        int i = 0;
        while (i < nbeffectif) {
            j = 0;
            while (j < nbind) {
                this.dataProjected3D[i][j] = (float)(v[j] * vp[i][axes[j]]);
                ++j;
            }
            ++i;
        }
        this.dataProjected = this.dataProjected3D;
        return this.dataProjected3D;
    }

    @Override
    public void retourPremiereProjection3D(int[] axes) {
    }

    @Override
    public void creerProjection() {
        int nbtot = this.src.getNbObjects();
        double[] iv = this.ed.getRealEigenvalues();
        double[][] vp = this.ed.getV2();
        double[] v = new double[3];
        int nbeffectif = nbtot;
        int nbind = Math.min(3, iv.length);
        int j = 0;
        while (j < nbind) {
            v[j] = Math.sqrt(iv[j]);
            ++j;
        }
        this.dataProjected3D = new float[nbeffectif][3];
        int i = 0;
        while (i < nbeffectif) {
            j = 0;
            while (j < nbind) {
                float ss = 0.0f;
                this.dataProjected3D[i][j] = ss = (float)(v[j] * vp[i][j]);
                ++j;
            }
            ++i;
        }
        this.dataProjected = this.dataProjected3D;
    }

    @Override
    public float[] getAxisProjection(int rank) {
        float[] axisProj = new float[this.nbObjects];
        double[] iv = this.ed.getRealEigenvalues();
        double[][] vp = this.ed.getV2();
        double v = Math.sqrt(iv[rank]);
        int i = 0;
        while (i < this.nbObjects) {
            axisProj[i] = (float)(v * vp[i][rank]);
            ++i;
        }
        return axisProj;
    }

    @Override
    public float[] projection(int rank, int[] dims) {
        return null;
    }

    @Override
    public float[] projection(float[] coord, int[] dims) {
        return null;
    }

    @Override
    public float[] getPointVariable(int var, int[] dims) {
        return null;
    }

    @Override
    public int getNbDimensions() {
        return 3;
    }

    @Override
    public float getDistance(int a, int b) {
        return (float)this.matrice[a][b];
    }

    public void setKernel(Kernel k) {
        this.noyau = k;
    }
}

