/*
 * Decompiled with CFR 0.152.
 */
package explorer.compute.compute.projection.conditionning;

import explorer.compute.compute.projection.conditionning.Conditioning;
import java.util.Arrays;

public class CenterConditioning
implements Conditioning {
    protected boolean centered;
    protected float[] offset;
    protected float[][] data;
    protected int nbattr;
    protected int nbobj;

    public CenterConditioning(boolean c) {
        this.centered = c;
    }

    public boolean isCentered() {
        return this.centered;
    }

    @Override
    public float[][] condition(float[][] d) {
        this.data = d;
        this.nbobj = d.length;
        this.nbattr = d[0].length;
        this.computeOffset();
        this.center();
        this.doCondition();
        return this.data;
    }

    protected void center() {
        if (this.centered) {
            int i = 0;
            while (i < this.nbattr) {
                int j = 0;
                while (j < this.nbobj) {
                    float[] fArray = this.data[j];
                    int n = i;
                    fArray[n] = fArray[n] - this.offset[i];
                    ++j;
                }
                ++i;
            }
        }
    }

    protected void computeOffset() {
        this.offset = new float[this.nbattr];
        Arrays.fill(this.offset, 0.0f);
        if (this.centered) {
            int i = 0;
            while (i < this.nbattr) {
                int j = 0;
                while (j < this.nbobj) {
                    if (j % 500 == 0) {
                        // empty if block
                    }
                    int n = i;
                    this.offset[n] = this.offset[n] + this.data[j][i];
                    ++j;
                }
                int n = i++;
                this.offset[n] = this.offset[n] / (float)this.nbobj;
            }
        }
    }

    protected void doCondition() {
    }

    @Override
    public float[] getConditionedValue(float[] obj) {
        float[] res = new float[this.nbattr];
        int i = 0;
        while (i < this.nbattr) {
            res[i] = obj[i] - this.offset[i];
            ++i;
        }
        return res;
    }

    @Override
    public int getType() {
        return 0;
    }
}

