/*
 * Decompiled with CFR 0.152.
 */
package explorer.compute.compute.projection.conditionning;

import explorer.compute.compute.projection.conditionning.CenterConditioning;
import explorer.compute.compute.projection.conditionning.Conditioning;
import explorer.compute.compute.projection.conditionning.NoConditioning;
import explorer.compute.compute.projection.conditionning.NormalizedConditioning;
import explorer.compute.compute.projection.conditionning.ReduceConditioning;
import java.util.ArrayList;
import java.util.List;
import lib3d4j.international.Messages;

public class ConditioningFactory {
    public static final int RAW = 0;
    public static final int NORMALIZE = 1;
    public static final int REDUCE = 2;
    public static final String STR_RAW = Messages.getString("tpgpre_rawdata");
    public static final String STR_NORMALIZE = Messages.getString("tpgpre_normdist");
    public static final String STR_REDUCE = Messages.getString("tpgpre_reduced");
    private static List<String> condmeths = null;

    public static synchronized List<String> getCondMeths() {
        if (condmeths == null) {
            condmeths = new ArrayList<String>(3);
            condmeths.add(STR_RAW);
            condmeths.add(STR_NORMALIZE);
            condmeths.add(STR_REDUCE);
        }
        return condmeths;
    }

    public static Conditioning createConditioning(String name, boolean c) {
        if (name.equals(Messages.getString("tpgpre_rawdata"))) {
            return new CenterConditioning(c);
        }
        if (name.equals(Messages.getString("tpgpre_normdist"))) {
            return new NormalizedConditioning(c);
        }
        if (name.equals(Messages.getString("tpgpre_reduced"))) {
            return new ReduceConditioning(c);
        }
        return new NoConditioning();
    }

    public static Conditioning createConditioning(int rank, boolean c) {
        switch (rank) {
            case 0: {
                return new CenterConditioning(c);
            }
            case 1: {
                return new NormalizedConditioning(c);
            }
            case 2: {
                return new ReduceConditioning(c);
            }
        }
        return new NoConditioning();
    }
}

