/*
 * Decompiled with CFR 0.152.
 */
package explorer.compute.compute.projection.conditionning;

import explorer.compute.compute.projection.conditionning.CenterConditioning;

public class NormalizedConditioning
extends CenterConditioning {
    protected float[] factor;

    public NormalizedConditioning(boolean c) {
        super(c);
    }

    @Override
    protected void computeOffset() {
        this.offset = new float[this.nbattr];
        int k = 0;
        int i = 0;
        while (i < this.nbattr) {
            float inf = this.data[k][i];
            float sup = this.data[k][i];
            int j = k + 1;
            while (j < this.nbobj) {
                if (this.data[j][i] < inf) {
                    inf = this.data[j][i];
                }
                if (this.data[j][i] > sup) {
                    sup = this.data[j][i];
                }
                ++j;
            }
            this.offset[i] = (inf + sup) / 2.0f;
            ++i;
        }
    }

    @Override
    protected void doCondition() {
        int k = 0;
        this.factor = new float[this.nbattr];
        int i = 0;
        while (i < this.nbattr) {
            float inf = this.data[k][i];
            float sup = this.data[k][i];
            int j = k + 1;
            while (j < this.nbobj) {
                if (this.data[j][i] < inf) {
                    inf = this.data[j][i];
                }
                if (this.data[j][i] > sup) {
                    sup = this.data[j][i];
                }
                ++j;
            }
            float coef = (sup - inf) / 2.0f;
            if (coef == 0.0f) {
                coef = 1.0f;
                System.out.println("Unique value for attribute " + i);
            }
            j = 0;
            while (j < this.nbobj) {
                this.data[j][i] = this.data[j][i] / coef;
                ++j;
            }
            this.factor[i] = coef;
            ++i;
        }
    }

    @Override
    public float[] getConditionedValue(float[] obj) {
        float[] res = new float[this.nbattr];
        int i = 0;
        while (i < this.nbattr) {
            res[i] = (obj[i] - this.offset[i]) / this.factor[i];
            ++i;
        }
        return res;
    }

    @Override
    public int getType() {
        return 1;
    }
}

