/*
 * Decompiled with CFR 0.152.
 */
package explorer.compute.compute.projection.conditionning;

import explorer.compute.compute.projection.conditionning.CenterConditioning;

public class ReduceConditioning
extends CenterConditioning {
    protected float[] factor;

    public ReduceConditioning(boolean c) {
        super(c);
    }

    @Override
    protected void doCondition() {
        this.factor = new float[this.nbattr];
        int i = 0;
        while (i < this.nbattr) {
            int j;
            float coef = 0.0f;
            if (this.centered) {
                j = 0;
                while (j < this.nbobj) {
                    coef += this.data[j][i] * this.data[j][i];
                    ++j;
                }
            } else {
                j = 0;
                while (j < this.nbobj) {
                    coef += (this.data[j][i] - this.offset[i]) * (this.data[j][i] - this.offset[i]);
                    ++j;
                }
            }
            Double d = new Double(Math.sqrt(coef / (float)this.nbobj));
            coef = d.floatValue();
            if (coef == 0.0f) {
                coef = 1.0f;
                System.out.println("Null value for variance of attribute " + i);
            }
            j = 0;
            while (j < this.nbobj) {
                float[] fArray = this.data[j];
                int n = i;
                fArray[n] = fArray[n] / coef;
                ++j;
            }
            this.factor[i] = coef;
            ++i;
        }
    }

    @Override
    public float[] getConditionedValue(float[] obj) {
        float[] res = new float[this.nbattr];
        int i = 0;
        while (i < this.nbattr) {
            res[i] = (obj[i] - this.offset[i]) / this.factor[i];
            ++i;
        }
        return res;
    }

    @Override
    public int getType() {
        return 2;
    }
}

