/*
 * Decompiled with CFR 0.152.
 */
package explorer.compute.kernels;

import explorer.compute.kernels.Dijkstra;
import explorer.compute.kernels.Kernel;

public class ISOMAP
extends Kernel {
    private int nbVoisin = 3;
    private float[][] matriceScalaire = null;
    private float[][] voisin = null;

    public ISOMAP() {
    }

    public ISOMAP(int nbVoisin) {
        this.nbVoisin = nbVoisin;
    }

    public void setNbVoisin(int nbVoisin) {
        this.nbVoisin = nbVoisin;
    }

    private float[][] createGraphVoisin(float[][] distance) {
        int j;
        float[][] matriceGraph = new float[this.nbObjets][this.nbObjets];
        float[] dist = new float[this.nbObjets];
        int[] index = new int[this.nbObjets];
        int i = 0;
        while (i < this.nbObjets) {
            j = 0;
            while (j < this.nbObjets) {
                matriceGraph[i][j] = -1.0f;
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < this.nbObjets) {
            j = 0;
            while (j < this.nbObjets) {
                dist[j] = distance[i][j];
                index[j] = j;
                ++j;
            }
            ISOMAP.quicksort(dist, index, 0, this.nbObjets - 1);
            int k = 0;
            int j2 = 0;
            while (j2 < this.nbObjets && k < this.nbVoisin) {
                if (index[j2] != i) {
                    matriceGraph[i][index[j2]] = dist[j2];
                    ++k;
                }
                ++j2;
            }
            ++i;
        }
        return matriceGraph;
    }

    private float[][] createGraphVoisin2(float[][] distance) {
        int j;
        float[][] matriceGraph = new float[this.nbObjets][this.nbObjets];
        float[] dist = new float[this.nbObjets];
        int[] index = new int[this.nbObjets];
        int i = 0;
        while (i < this.nbObjets) {
            j = 0;
            while (j < this.nbObjets) {
                matriceGraph[i][j] = this.voisin[i][j];
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < this.nbObjets) {
            j = 0;
            while (j < this.nbObjets) {
                dist[j] = distance[i][j] == Float.POSITIVE_INFINITY ? this.matriceDistanceBase[i][j] : Float.POSITIVE_INFINITY;
                index[j] = j;
                ++j;
            }
            ISOMAP.quicksort(dist, index, 0, this.nbObjets - 1);
            int k = 0;
            int j2 = 0;
            while (j2 < this.nbObjets) {
                if (index[j2] != i && k < 1) {
                    matriceGraph[i][index[j2]] = dist[j2];
                    ++k;
                }
                ++j2;
            }
            ++i;
        }
        i = 0;
        while (i < this.nbObjets) {
            j = 0;
            while (j < this.nbObjets) {
                if ((double)this.voisin[i][j] != -1.0) {
                    matriceGraph[i][j] = this.voisin[i][j];
                }
                ++j;
            }
            ++i;
        }
        return matriceGraph;
    }

    private void createGraphVoisin3(float[][] distance, float[][] voisin) {
        float mini = -1.0f;
        int imin = 0;
        int jmin = 0;
        int i = 0;
        while (i < this.nbObjets) {
            int j = 0;
            while (j < this.nbObjets) {
                if (distance[i][j] == Float.POSITIVE_INFINITY) {
                    float dd = this.matriceDistanceBase[i][j];
                    if (mini == -1.0f || dd < mini) {
                        mini = dd;
                        imin = i;
                        jmin = j;
                    }
                }
                ++j;
            }
            ++i;
        }
        voisin[imin][jmin] = mini;
    }

    private static float[][] createScalaireMatrix(float[][] distance) {
        float val;
        int j;
        float moy = 0.0f;
        float[] moyLigne = new float[distance.length];
        int i = 0;
        while (i < distance.length) {
            moyLigne[i] = 0.0f;
            j = 0;
            while (j < distance.length) {
                if (i != j) {
                    val = distance[i][j];
                    moy -= val * val / 2.0f;
                    int n = i;
                    moyLigne[n] = moyLigne[n] - val * val / 2.0f;
                }
                ++j;
            }
            moyLigne[i] = moyLigne[i] / (float)distance.length;
            ++i;
        }
        moy /= (float)(distance.length * distance.length);
        float[][] matrice = new float[distance.length][distance.length];
        i = 0;
        while (i < distance.length) {
            j = i;
            while (j < distance.length) {
                val = distance[i][j];
                matrice[i][j] = -val * val / 2.0f - moyLigne[i] - moyLigne[j] + moy;
                matrice[j][i] = matrice[i][j];
                ++j;
            }
            ++i;
        }
        return matrice;
    }

    private void createISOMAP() {
        float[][] distanceISOMAP = null;
        if (this.matriceDistanceBase == null) {
            this.createMatrixDistanceBase();
        }
        this.voisin = this.createGraphVoisin(this.matriceDistanceBase);
        distanceISOMAP = Dijkstra.createMatriceDistance(this.voisin);
        while (!Dijkstra.isComplet(this.voisin)) {
            this.createGraphVoisin3(distanceISOMAP, this.voisin);
            distanceISOMAP = Dijkstra.createMatriceDistance(this.voisin);
        }
        this.matriceScalaire = ISOMAP.createScalaireMatrix(distanceISOMAP);
    }

    private void createMatrixDistanceBase() {
        this.matriceDistanceBase = new float[this.nbObjets][this.nbObjets];
        int i = 0;
        while (i < this.nbObjets) {
            int j = 0;
            while (j < this.nbObjets) {
                this.matriceDistanceBase[i][j] = ISOMAP.distance(this.data[i], this.data[j]);
                ++j;
            }
            ++i;
        }
    }

    @Override
    public float k(int x1, int x2) {
        if (this.matriceScalaire == null) {
            this.createISOMAP();
        }
        return this.matriceScalaire[x1][x2];
    }

    @Override
    public double[][] getScalaireMatrix() {
        if (this.matriceScalaire == null) {
            this.createISOMAP();
        }
        double[][] matriceDouble = new double[this.matriceScalaire.length][this.matriceScalaire.length];
        int i = 0;
        while (i < this.matriceScalaire.length) {
            int j = 0;
            while (j < this.matriceScalaire.length) {
                matriceDouble[i][j] = this.matriceScalaire[i][j];
                ++j;
            }
            ++i;
        }
        return matriceDouble;
    }

    @Override
    public boolean[][] getProjections() {
        boolean[][] res = null;
        if (this.voisin != null) {
            res = new boolean[this.voisin.length][this.voisin.length];
            int i = 0;
            while (i < this.voisin.length) {
                int j = 0;
                while (j < this.voisin.length) {
                    res[i][j] = this.voisin[i][j] >= 0.0f;
                    ++j;
                }
                ++i;
            }
        }
        return res;
    }
}

