/*
 * Decompiled with CFR 0.152.
 */
package explorer.compute.scripts;

import explorer.compute.scripts.Ex3dScript;
import explorer.compute.scripts.Ex3dScriptContext;
import explorer.data.Common;
import explorer.data.DataManager;
import explorer.data.Source3DCoord;
import explorer.data.SourceAttrVal;
import explorer.data.SourceDist;
import java.net.MalformedURLException;
import java.net.URL;
import json.JSONArray;
import json.JSONException;
import json.JSONObject;
import lib3d4j.data.Source;

public class DataSourceScript
implements Ex3dScript {
    @Override
    public JSONObject write(Object o) {
        Source s = null;
        if (!(o instanceof Source)) {
            return null;
        }
        s = (Source)o;
        JSONObject jos = new JSONObject();
        try {
            jos.put("msg", "data-source");
            jos.put("data-type", s.getType());
            if (s.getParent() != null) {
                jos.put("croped-from", s.getParent().getId());
                jos.put("real-indices", this.getRealIndices(s));
            } else if (s.getUrl() != null) {
                jos.put("url", s.getUrl());
            } else {
                JSONArray ja = null;
                if (s instanceof Source3DCoord) {
                    ja = new JSONArray(((Source3DCoord)s).getCoords());
                } else if (s instanceof SourceAttrVal) {
                    ja = new JSONArray(((SourceAttrVal)s).getTable());
                } else if (s instanceof SourceDist) {
                    ja = new JSONArray(((SourceDist)s).getMatrix());
                }
                jos.put("data-set", ja);
            }
            jos.put("id", s.getId());
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return jos;
    }

    @Override
    public void read(JSONObject jos, Ex3dScriptContext sc) {
        try {
            String cmdName = jos.getString("msg");
            if (cmdName.equals("data-source")) {
                Source src = null;
                int datatype = jos.getInt("data-type");
                if (jos.has("url")) {
                    src = Common.getSingleton().load(datatype, new URL(jos.getString("url")));
                } else if (jos.has("croped-from")) {
                    JSONArray jscrop = jos.getJSONArray("real-indices");
                    int size = jscrop.length();
                    int[] crop = new int[size];
                    int i = 0;
                    while (i < size) {
                        crop[i] = jscrop.getInt(i);
                        ++i;
                    }
                    String from = jos.getString("croped-from");
                    Source s = (Source)sc.get(from);
                    src = DataManager.getSingleton().createCropedSource(s, crop);
                } else if (jos.has("data-set")) {
                    JSONArray jsdata = jos.getJSONArray("data-set");
                    int nbrows = jsdata.length();
                    int nbcols = jsdata.getJSONArray(0).length();
                    float[][] data = new float[nbrows][nbcols];
                    int i = 0;
                    while (i < nbrows) {
                        JSONArray line = jsdata.getJSONArray(i);
                        int j = 0;
                        while (j < nbcols) {
                            data[i][j] = (float)line.getDouble(j);
                            ++j;
                        }
                        ++i;
                    }
                    src = DataManager.getSingleton().createSource(datatype, data);
                }
                sc.add(jos.getString("id"), src);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }

    private JSONArray getRealIndices(Source s) throws JSONException {
        int nbo = s.getNbObjects();
        int[] ri = new int[nbo];
        int i = 0;
        while (i < nbo) {
            ri[i] = s.getRealIndex(i);
            ++i;
        }
        return new JSONArray(ri);
    }
}

