/*
 * Decompiled with CFR 0.152.
 */
package explorer.compute.scripts;

import explorer.compute.scripts.Ex3dScript;
import explorer.compute.scripts.Ex3dScriptContext;
import explorer.data.DataManager;
import explorer.data.DatasetParamsExplorer;
import java.lang.reflect.InvocationTargetException;
import javax.swing.SwingUtilities;
import json.JSONException;
import json.JSONObject;

public class DatasetParamsExplorerScript
implements Ex3dScript {
    @Override
    public JSONObject write(Object o) {
        DatasetParamsExplorer params = DataManager.getSingleton().getParams();
        JSONObject jos = new JSONObject();
        try {
            jos.put("msg", "visual-attributes");
            jos.put("form-att", params.getFormCol());
            jos.put("label-att", params.getLabelCol());
            jos.put("pict-att", params.getAssocDataCol());
            jos.put("class-att", params.getClassCol());
            jos.put("color-att", params.getColorCol());
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return jos;
    }

    @Override
    public void read(JSONObject jos, Ex3dScriptContext sc) {
        try {
            String cmdName = jos.getString("msg");
            if (cmdName.equals("visual-attributes")) {
                DSPESRunnable runnable = new DSPESRunnable(jos, DataManager.getSingleton().getParams());
                if (SwingUtilities.isEventDispatchThread()) {
                    runnable.run();
                } else {
                    try {
                        SwingUtilities.invokeAndWait(runnable);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    catch (InvocationTargetException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    private class DSPESRunnable
    implements Runnable {
        private JSONObject jos;
        private DatasetParamsExplorer params;

        public DSPESRunnable(JSONObject jos, DatasetParamsExplorer params) {
            this.jos = jos;
            this.params = params;
        }

        @Override
        public void run() {
            try {
                this.params.setFormCol(this.jos.getInt("form-att"));
                this.params.setLabelCol(this.jos.getInt("label-att"));
                this.params.setAssocDataCol(this.jos.getInt("pict-att"));
                this.params.setClassCol(this.jos.getInt("class-att"));
                this.params.setColorCol(this.jos.getInt("color-att"));
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
    }
}

