/*
 * Decompiled with CFR 0.152.
 */
package explorer.compute.scripts;

import explorer.compute.compute.projection.Projection;
import explorer.compute.scripts.Ex3dScript;
import explorer.compute.scripts.Ex3dScriptContext;
import explorer.display3D.DisplayExplorer;
import explorer.display3D.javafx.DisplayJFXExplorer;
import java.lang.reflect.InvocationTargetException;
import javax.swing.SwingUtilities;
import json.JSONException;
import json.JSONObject;

public class DisplayScript
implements Ex3dScript {
    @Override
    public JSONObject write(Object o) {
        if (!(o instanceof DisplayExplorer)) {
            return null;
        }
        DisplayExplorer display = (DisplayExplorer)o;
        JSONObject jos = new JSONObject();
        try {
            jos.put("msg", "display");
            jos.put("display-id", display.getId());
            jos.put("proj", display.getProjection().getId());
            jos.put("specific-picture-attribute", display.getSpecificPictureAttribute());
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return jos;
    }

    @Override
    public void read(JSONObject jos, Ex3dScriptContext sc) {
        try {
            String cmdName = jos.getString("msg");
            if (cmdName.equals("display")) {
                String id = jos.getString("display-id");
                String projid = jos.getString("proj");
                Projection proj = (Projection)sc.get(projid);
                int pa = jos.has("specific-picture-attribute") ? jos.getInt("specific-picture-attribute") : -1;
                DSRunnable dsr = new DSRunnable(proj, id, sc, pa);
                if (SwingUtilities.isEventDispatchThread()) {
                    dsr.run();
                } else {
                    SwingUtilities.invokeAndWait(dsr);
                }
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    private class DSRunnable
    implements Runnable {
        private Projection proj;
        private String id;
        private Ex3dScriptContext sc;
        private int pictatt;

        public DSRunnable(Projection proj, String id, Ex3dScriptContext sc, int pa) {
            this.proj = proj;
            this.id = id;
            this.sc = sc;
            this.pictatt = pa;
        }

        @Override
        public void run() {
            DisplayJFXExplorer display = new DisplayJFXExplorer(this.proj);
            if (this.pictatt != -1) {
                display.setSpecificPictureAttribute(this.pictatt);
            }
            display.setVisible(true);
            this.sc.add(this.id, display);
        }
    }
}

