/*
 * Decompiled with CFR 0.152.
 */
package explorer.compute.scripts;

import explorer.compute.compute.projection.BasicProjection;
import explorer.compute.compute.projection.PMAttrVal;
import explorer.compute.compute.projection.Projection;
import explorer.compute.compute.projection.ProjectionFactory;
import explorer.compute.compute.projection.ProjectiveMethod;
import explorer.compute.compute.projection.StandardProjection;
import explorer.compute.compute.projection.WeightedProjection;
import explorer.compute.scripts.Ex3dScript;
import explorer.compute.scripts.Ex3dScriptContext;
import json.JSONArray;
import json.JSONException;
import json.JSONObject;

public class ProjectionScript
implements Ex3dScript {
    @Override
    public JSONObject write(Object o) {
        if (!(o instanceof Projection)) {
            return null;
        }
        Projection proj = (Projection)o;
        JSONObject jos = new JSONObject();
        try {
            jos.put("msg", "projection");
            jos.put("proj-meth", proj.getProjectiveMethod().getId());
            jos.put("proj-id", proj.getId());
            if (proj instanceof StandardProjection) {
                jos.put("proj-type", "standard");
                jos.put("proj-axes", new JSONArray(((StandardProjection)proj).getAxes()));
            } else {
                jos.put("proj-type", "weighted");
                jos.put("proj-weighted-axes", new JSONArray(((WeightedProjection)proj).getWeights()));
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return jos;
    }

    @Override
    public void read(JSONObject jos, Ex3dScriptContext sc) {
        try {
            String cmdName = jos.getString("msg");
            if (cmdName.equals("projection")) {
                BasicProjection proj = null;
                ProjectiveMethod pm = (ProjectiveMethod)sc.get(jos.getString("proj-meth"));
                String type = jos.getString("proj-type");
                String id = jos.getString("proj-id");
                if (type.equals("standard")) {
                    JSONArray array = jos.getJSONArray("proj-axes");
                    int[] axes = new int[array.length()];
                    int i = 0;
                    while (i < array.length()) {
                        axes[i] = array.getInt(i);
                        ++i;
                    }
                    proj = ProjectionFactory.createStandardProjection(pm, axes);
                } else {
                    JSONArray array = jos.getJSONArray("proj-weighted-axes");
                    int nrows = array.length();
                    int ncols = array.getJSONArray(0).length();
                    float[][] weights = new float[nrows][ncols];
                    int i = 0;
                    while (i < nrows) {
                        JSONArray line = array.getJSONArray(i);
                        int j = 0;
                        while (j < ncols) {
                            weights[i][j] = line.getLong(j);
                            ++j;
                        }
                        ++i;
                    }
                    proj = ProjectionFactory.createWeightedProjection((PMAttrVal)pm, weights);
                }
                sc.add(id, proj);
            }
        }
        catch (JSONException jse) {
            jse.printStackTrace();
        }
    }
}

