/*
 * Decompiled with CFR 0.152.
 */
package explorer.compute.scripts;

import explorer.compute.compute.projection.PMFactory;
import explorer.compute.compute.projection.Projection;
import explorer.compute.compute.projection.ProjectionFactory;
import explorer.compute.compute.projection.ProjectiveMethod;
import explorer.compute.scripts.DataSourceScript;
import explorer.compute.scripts.DatasetParamsExplorerScript;
import explorer.compute.scripts.DisplayScript;
import explorer.compute.scripts.Ex3dScriptContext;
import explorer.compute.scripts.ProjectionScript;
import explorer.compute.scripts.ProjectiveMethodScript;
import explorer.data.Common;
import explorer.data.DataManager;
import explorer.data.DatasetParamsExplorer;
import explorer.data.OptionsExplorer;
import explorer.data.ViewManager;
import explorer.display3D.DisplayExplorer;
import explorer.windows.w2D.utils.GView;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import json.JSONException;
import json.JSONObject;
import lib3d4j.data.Source;
import lib3d4j.international.Messages;

public class ScriptControler {
    public void doWrite() {
        try {
            ProjectFilter pf = new ProjectFilter();
            DatasetParamsExplorer params = DataManager.getSingleton().getParams();
            JFileChooser jfc = params.getProtocol() == 1 ? new JFileChooser(DataManager.getSingleton().getParams().getCurrentPath().getPath()) : new JFileChooser();
            jfc.setDialogTitle(Messages.getString("save_project"));
            jfc.setApproveButtonText(Messages.getString("save"));
            jfc.setApproveButtonToolTipText(Messages.getString("save_project_button_tooltip"));
            jfc.addChoosableFileFilter(pf);
            int returnVal = jfc.showOpenDialog(null);
            if (returnVal != 0) {
                return;
            }
            File f = jfc.getSelectedFile();
            if (!f.getName().contains(".")) {
                f = new File(f.getParentFile(), String.valueOf(f.getName()) + pf.extension);
            }
            PrintWriter out = new PrintWriter(f);
            DataSourceScript dss = new DataSourceScript();
            for (Source s : DataManager.getSingleton().getSources()) {
                out.println(dss.write(s));
            }
            ProjectiveMethodScript pms = new ProjectiveMethodScript();
            for (ProjectiveMethod pm : PMFactory.getSingleton().getMethods()) {
                out.println(pms.write(pm));
            }
            ProjectionScript ps = new ProjectionScript();
            for (Projection p : ProjectionFactory.getProjs()) {
                out.println(ps.write(p));
            }
            DisplayScript ds = new DisplayScript();
            for (GView gv : ViewManager.getSingleton().getGviews()) {
                if (!(gv instanceof DisplayExplorer)) continue;
                out.println(ds.write(gv));
            }
            out.println(new DatasetParamsExplorerScript().write(null));
            out.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public void doRead() {
        DatasetParamsExplorer params = DataManager.getSingleton().getParams();
        JFileChooser jfc = params.getProtocol() == 1 ? new JFileChooser(DataManager.getSingleton().getParams().getCurrentPath().getPath()) : new JFileChooser();
        jfc.setDialogTitle(Messages.getString("load_project"));
        jfc.setApproveButtonText(Messages.getString("load_project_button"));
        jfc.setApproveButtonToolTipText(Messages.getString("load_project_button_tooltip"));
        jfc.addChoosableFileFilter(new ProjectFilter());
        int returnVal = jfc.showOpenDialog(null);
        if (returnVal != 0) {
            return;
        }
        String name = jfc.getSelectedFile().getAbsolutePath();
        new Thread(new DoReadRunnable(name)).start();
    }

    private class DoReadRunnable
    implements Runnable {
        private String name;

        public DoReadRunnable(String filename) {
            this.name = filename;
        }

        @Override
        public void run() {
            DataManager.getSingleton().reset();
            Common.getSingleton().reinitialiserParametres();
            boolean autocomp = OptionsExplorer.getSingleton().isLoadAndShow();
            OptionsExplorer.getSingleton().setLoadAndShow(false);
            Ex3dScriptContext sc = new Ex3dScriptContext();
            try {
                String nextcmd;
                FileReader fin = new FileReader(this.name);
                BufferedReader in = new BufferedReader(fin);
                DataSourceScript dss = new DataSourceScript();
                ProjectiveMethodScript pms = new ProjectiveMethodScript();
                ProjectionScript ps = new ProjectionScript();
                DisplayScript ds = new DisplayScript();
                while ((nextcmd = in.readLine()) != null) {
                    JSONObject jso = new JSONObject(nextcmd);
                    String cmdName = jso.getString("msg");
                    if (cmdName.equals("data-source")) {
                        dss.read(jso, sc);
                        continue;
                    }
                    if (cmdName.equals("projective-method")) {
                        pms.read(jso, sc);
                        continue;
                    }
                    if (cmdName.equals("projection")) {
                        ps.read(jso, sc);
                        continue;
                    }
                    if (cmdName.equals("display")) {
                        ds.read(jso, sc);
                        continue;
                    }
                    if (!cmdName.equals("visual-attributes")) continue;
                    new DatasetParamsExplorerScript().read(jso, sc);
                }
                in.close();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            OptionsExplorer.getSingleton().setLoadAndShow(autocomp);
        }
    }

    private class ProjectFilter
    extends FileFilter {
        public String extension = ".e3d";

        private ProjectFilter() {
        }

        @Override
        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            String name = f.getName();
            return name.endsWith(this.extension);
        }

        @Override
        public String getDescription() {
            return "E3D Files";
        }
    }
}

