/*
 * Decompiled with CFR 0.152.
 */
package explorer.compute.svm;

import explorer.compute.kernels.Kernel;

public class SVM {
    protected float[] w;
    float omega = 0.0f;
    float b;
    protected float[] alpha;
    protected float[] errors;
    protected float[][] points;
    protected float constant = 1.0f;
    protected float epsilone = 0.001f;
    protected float[] targets;
    protected float tol = 0.001f;
    private int nbAlpha0;
    private int nbAlphaC;
    private int nbObjects;
    private int nbTerms;
    private Kernel kernel = null;
    private float[] hx;

    public SVM(float[] targets, float[][] data) {
        this.points = data;
        this.targets = targets;
        this.nbObjects = data.length;
        this.nbTerms = data[0].length;
        this.initErrors();
    }

    public int takeStep(int i1, int i2) {
        float a2;
        float k22;
        float H;
        if (i1 == i2) {
            return 0;
        }
        if (this.targets[i1] == 0.0f || this.targets[i2] == 0.0f) {
            return 0;
        }
        float s = this.targets[i1] * this.targets[i2];
        float L = this.computeL(i1, i2);
        if (L == (H = this.computeH(i1, i2))) {
            return 0;
        }
        float k11 = this.produitScalaire(i1, i1);
        float k12 = this.produitScalaire(i1, i2);
        float eta = 2.0f * k12 - k11 - (k22 = this.produitScalaire(i2, i2));
        if (eta < 0.0f) {
            a2 = this.alpha[i2] - this.targets[i2] * (this.errors[i1] - this.errors[i2]) / eta;
            if (a2 < L) {
                a2 = L;
            } else if (a2 > H) {
                a2 = H;
            }
        } else {
            float Hobj;
            float Lobj = this.correctedObjectiveFunction(i2, L);
            a2 = Lobj > (Hobj = this.correctedObjectiveFunction(i2, H)) + this.epsilone ? L : (Lobj < Hobj - this.epsilone ? H : this.alpha[i2]);
        }
        if (Math.abs(a2 - this.alpha[i2]) < this.epsilone * (a2 + this.alpha[i2] + this.epsilone)) {
            return 0;
        }
        float a1 = this.alpha[i1] + s * (this.alpha[i2] - a2);
        float bOld = this.b;
        if (this.alpha[i1] != 0.0f && this.alpha[i1] != this.constant) {
            this.b = this.errors[i1] + this.targets[i1] * (a1 - this.alpha[i1]) * k11 + this.targets[i2] * (a2 - this.alpha[i2]) * k12 + bOld;
        } else if (this.alpha[i2] != 0.0f && this.alpha[i2] != this.constant) {
            this.b = this.errors[i2] + this.targets[i1] * (a1 - this.alpha[i1]) * k12 + this.targets[i2] * (a2 - this.alpha[i2]) * k22 + bOld;
        } else {
            float b1 = this.errors[i1] + this.targets[i1] * (a1 - this.alpha[i1]) * k11 + this.targets[i2] * (a2 - this.alpha[i2]) * k12 + bOld;
            float b2 = this.errors[i2] + this.targets[i1] * (a1 - this.alpha[i1]) * k12 + this.targets[i2] * (a2 - this.alpha[i2]) * k22 + bOld;
            this.b = (b1 + b2) / 2.0f;
        }
        int i = 0;
        while (i < this.nbObjects) {
            this.errors[i] = this.errors[i] + this.targets[i1] * (a1 - this.alpha[i1]) * this.produitScalaire(i1, i) + this.targets[i2] * (a2 - this.alpha[i2]) * this.produitScalaire(i2, i) + bOld - this.b;
            ++i;
        }
        this.omega = this.correctedObjectiveFunction(i2, a2);
        this.alpha[i1] = a1;
        this.alpha[i2] = a2;
        return 1;
    }

    public int examineExample(int i2) {
        float r2 = this.errors[i2] * this.targets[i2];
        if (r2 < -this.tol && this.alpha[i2] < this.constant || r2 > this.tol && this.alpha[i2] > 0.0f) {
            this.countAlpha0AndC();
            if (this.nbAlpha0 > 1 && this.nbAlphaC > 1) {
                int i1 = this.secondChoixHeuristic(i2);
                if (this.targets[i1] == 0.0f && this.targets[i2] == 0.0f) {
                    return 0;
                }
                if (this.takeStep(i1, i2) == 1) {
                    return 1;
                }
            }
            int i = 0;
            while (i < this.nbObjects) {
                if (this.alpha[i] > 0.0f && this.alpha[i] < this.constant && i != i2 && this.takeStep(i, i2) == 1) {
                    return 1;
                }
                ++i;
            }
            i = 0;
            while (i < this.nbObjects) {
                if ((this.alpha[i] == 0.0f || this.alpha[i] == this.constant) && i != i2 && this.takeStep(i, i2) == 1) {
                    return 1;
                }
                ++i;
            }
        }
        return 0;
    }

    public void computeSVM() {
        long time = System.currentTimeMillis();
        this.initAlphaAllZero();
        this.b = 0.0f;
        int numChanged = 0;
        int maxIter = 100;
        boolean examineAll = true;
        while ((numChanged > 0 || examineAll) && maxIter > 0) {
            int i;
            numChanged = 0;
            --maxIter;
            if (examineAll) {
                i = 0;
                while (i < this.nbObjects) {
                    numChanged += this.examineExample(i);
                    ++i;
                }
            } else {
                i = 0;
                while (i < this.nbObjects) {
                    if (this.alpha[i] != 0.0f && this.alpha[i] != this.constant) {
                        numChanged += this.examineExample(i);
                    }
                    ++i;
                }
            }
            if (examineAll) {
                examineAll = false;
                continue;
            }
            if (numChanged != 0) continue;
            examineAll = true;
        }
        long newTime = System.currentTimeMillis();
        System.out.println("Time cost = " + (double)(newTime - time) * 1.0 / 1000.0);
    }

    private float computeH(int i1, int i2) {
        if (this.targets[i1] == this.targets[i2]) {
            float res = this.alpha[i1] + this.alpha[i2];
            if (res < this.constant) {
                return res;
            }
            return this.constant;
        }
        float res = this.constant + this.alpha[i2] - this.alpha[i1];
        if (res < this.constant) {
            return res;
        }
        return this.constant;
    }

    private float computeL(int i1, int i2) {
        if (this.targets[i1] != this.targets[i2]) {
            float res = this.alpha[i2] - this.alpha[i1];
            if (res > 0.0f) {
                return res;
            }
            return 0.0f;
        }
        float res = this.alpha[i1] + this.alpha[i2] - this.constant;
        if (res > 0.0f) {
            return res;
        }
        return 0.0f;
    }

    private float produitScalaire(int i1, int i2) {
        if (this.kernel == null) {
            float sum = 0.0f;
            int i = 0;
            while (i < this.nbTerms) {
                sum += this.points[i1][i] * this.points[i2][i];
                ++i;
            }
            return sum;
        }
        return this.kernel.k(i1, i2);
    }

    private float correctedObjectiveFunction(int i2, float a2) {
        return this.omega - this.modifedObjectiveFunction(i2, this.alpha[i2]) + this.modifedObjectiveFunction(i2, a2);
    }

    private float modifedObjectiveFunction(int i2, float a2) {
        float sum = a2 - this.targets[i2] * this.targets[i2] * this.produitScalaire(i2, i2) * a2 * a2 / 2.0f;
        int i = 0;
        while (i < this.nbObjects) {
            if (i != i2) {
                sum += this.targets[i] * this.targets[i2] * this.produitScalaire(i, i2) * this.alpha[i] * this.alpha[i2];
            }
            ++i;
        }
        return sum;
    }

    private int secondChoixHeuristic(int i2) {
        int i = 0;
        float max = 0.0f;
        int j = 0;
        while (j < this.nbObjects) {
            if (Math.abs(this.errors[j] - this.errors[i2]) > max) {
                i = j;
                max = Math.abs(this.errors[j] - this.errors[i2]);
            }
            ++j;
        }
        return i;
    }

    private void countAlpha0AndC() {
        int i = 0;
        while (i < this.nbObjects) {
            if (this.alpha[i] == 0.0f) {
                ++this.nbAlpha0;
            }
            if (this.alpha[i] == this.constant) {
                ++this.nbAlphaC;
            }
            ++i;
        }
    }

    public void computeW() {
        this.w = new float[this.nbTerms];
        int i = 0;
        while (i < this.nbTerms) {
            this.w[i] = 0.0f;
            int j = 0;
            while (j < this.nbObjects) {
                int n = i;
                this.w[n] = this.w[n] + this.alpha[j] * this.targets[j] * this.points[j][i];
                ++j;
            }
            ++i;
        }
    }

    public void computeHx() {
        this.hx = new float[this.nbObjects];
        int i = 0;
        while (i < this.nbObjects) {
            this.hx[i] = this.hxi(i);
            ++i;
        }
    }

    private float hxi(int k) {
        float sum = 0.0f;
        if (this.kernel == null) {
            this.computeW();
            int i = 0;
            while (i < this.nbTerms) {
                sum += this.w[i] * this.points[k][i];
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.nbObjects) {
                sum += this.alpha[i] * this.targets[i] * this.kernel.k(k, i);
                ++i;
            }
        }
        return sum -= this.b;
    }

    private void initErrors() {
        this.errors = new float[this.nbObjects];
        int i = 0;
        while (i < this.nbObjects) {
            this.errors[i] = -this.targets[i];
            ++i;
        }
    }

    private void initAlphaAllZero() {
        this.alpha = new float[this.nbObjects];
        int i = 0;
        while (i < this.nbObjects) {
            this.alpha[i] = 0.0f;
            ++i;
        }
    }

    public float getB() {
        return this.b;
    }

    public float getWi(int i) {
        return this.w[i];
    }

    public void setConstant(float c) {
        this.constant = c;
    }

    public void setKernel(Kernel kernel2, float[] moyenne) {
        this.kernel = kernel2;
        this.kernel.setData(this.points);
        this.kernel.setMoyennes(moyenne);
    }

    public float[] getHx() {
        return this.hx;
    }

    public float getHxAt(int i) {
        return this.hx[i];
    }

    public void displayPoints() {
        System.out.print("Points : ");
        System.out.print(" nbTerms: " + this.nbTerms);
        System.out.print(" nbObjects: " + this.nbObjects);
        int i = 0;
        while (i < this.nbTerms) {
            int j = 0;
            while (j < this.nbObjects) {
                System.out.print(" " + this.points[j][i] + " ");
                ++j;
            }
            System.out.println();
            ++i;
        }
    }

    public void displayAlpha() {
        System.out.print("alpha: ");
        int i = 0;
        while (i < this.nbObjects) {
            System.out.print(" " + i + " " + this.alpha[i]);
            ++i;
        }
        System.out.println();
    }

    public void displayTargets() {
        System.out.print("targets : ");
        int i = 0;
        while (i < this.nbObjects) {
            System.out.print(String.valueOf(this.targets[i]) + " ");
            ++i;
        }
        System.out.println();
    }

    public void displayW() {
        System.out.println("affiche w :");
        int i = 0;
        while (i < this.w.length) {
            System.out.print(String.valueOf(this.w[i]) + " ");
            ++i;
        }
    }

    public void displayHx() {
        System.out.println("hx : ");
        int i = 0;
        while (i < this.nbObjects) {
            System.out.print(" " + this.hx[i] + " ");
            ++i;
        }
        System.out.println();
    }
}

