/*
 * Decompiled with CFR 0.152.
 */
package explorer.compute.tools;

import explorer.compute.tools.GViewTool;
import explorer.data.DataManager;
import explorer.display3D.DisplayExplorer;
import explorer.windows.w2D.icview.ICVAlongAxis;
import explorer.windows.w2D.utils.CaracTable;
import explorer.windows.w2D.utils.GView;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Observable;
import java.util.Observer;
import java.util.TreeMap;
import lib3d4j.compute.tools.OutilsAlgebre;
import lib3d4j.data.DescriptionData;
import lib3d4j.international.Messages;
import lib3d4j.w2d.ImageDisplayer;
import lib3d4j.w2d.ImageDisplayerException;

public class AlongAxisTool
extends GViewTool
implements Observer {
    private ICVAlongAxis axes;
    private int[] indices;
    private int[] targets;
    protected HashMap<Integer, AxisData> axesData;
    private static int idGen = 1;
    private DescriptionData dd = DataManager.getSingleton().getCompAttr();

    public AlongAxisTool() {
        this.init();
    }

    @Override
    public void activeViewChanged(GView gv) {
        super.activeViewChanged(gv);
        if (this.f3d != null) {
            this.f3d.addObserver(this);
        }
    }

    @Override
    public void update(Observable o, Object arg) {
        int index = (Integer)arg;
        this.axes.clickedObject(index);
    }

    private void init() {
        this.targets = new int[]{-1, -1};
        this.indices = new int[]{-1, -1};
        this.axesData = new HashMap();
    }

    public void setAxes(ICVAlongAxis tpg) {
        this.axes = tpg;
        this.axes.maj();
    }

    public void updateLists() {
        this.axes.maj();
    }

    public void buildAxis() {
        this.indices[0] = this.axes.getT1();
        this.indices[1] = this.axes.getT2();
        this.updateTargets(this.indices);
    }

    public void createAxis() {
        int nbpts = this.axes.getNbPts();
        float[][] projcoords = this.f3d.getProjection().getCoordinates();
        AxisData ad = new AxisData(this.indices[0], this.indices[1]);
        ad.segmentId = this.f3d.addLine(projcoords[this.indices[0]], projcoords[this.indices[1]]);
        ad.nearests = this.pointsProches(projcoords[this.indices[0]], projcoords[this.indices[1]], projcoords, nbpts);
        if (this.dd.isPictureAttrGiven()) {
            ImageDisplayer idImg = new ImageDisplayer(0, 0);
            idImg.setTitle(String.valueOf(Messages.getString("tpgpaxesobservations_images")) + " " + ad.toString());
            idImg.setLocation(660, 0);
            ad.display = idImg;
        } else {
            ad.display = null;
        }
        ad.setSelected(true);
        ad.carTable = new CaracTable(ad.nearests, ad.toString());
        this.axesData.put(ad.axisId, ad);
        this.axes.addAxis(ad.toString());
    }

    public void dropAxis(String id) {
        AxisData ad = this.axesData.get(this.extractId(id));
        ad.setSelected(false);
        ad.carTable.dispose();
        if (ad.display != null) {
            ad.display.dispose();
        }
        this.f3d.removeObject(ad.segmentId);
        this.axes.removeAxis(ad.toString());
    }

    public void displayAxis(String id, boolean display) {
        AxisData ad = this.axesData.get(this.extractId(id));
        ad.setSelected(display);
        ad.carTable.setVisible(display);
        if (ad.display != null) {
            ad.display.setVisible(display);
        }
    }

    private int extractId(String name) {
        return Integer.parseInt(name.substring(0, name.indexOf(32)));
    }

    private void updateTargets(int[] indices) {
        float[][] projcoord = this.f3d.getProjection().getCoordinates();
        int i = 0;
        while (i < 2) {
            if (this.targets[i] != -1) {
                this.f3d.removeObject(this.targets[i]);
            }
            if (indices[i] != -1) {
                this.targets[i] = this.f3d.setTarget(projcoord[indices[i]], DisplayExplorer.TARGET_COLORS[i]);
            }
            ++i;
        }
    }

    private int[] pointsProches(float[] coord1, float[] coord2, float[][] points, int nb) {
        double dAH;
        double dPointA;
        double dPointDroite;
        ArrayList pProches = new ArrayList();
        TreeMap<Double, ArrayList<Integer>> listeDistance = new TreeMap<Double, ArrayList<Integer>>();
        double dAB = OutilsAlgebre.distance(coord1, coord2);
        dAB *= dAB;
        int i = 0;
        while (i < points.length) {
            double dPointB;
            double dBH;
            dPointDroite = OutilsAlgebre.distanceToABLine(coord1, coord2, points[i]);
            dPointA = OutilsAlgebre.distance(coord1, points[i]);
            dAH = dPointA * dPointA - dPointDroite * dPointDroite;
            if (dAH + (dBH = (dPointB = (double)OutilsAlgebre.distance(points[i], coord2)) * dPointB - dPointDroite * dPointDroite) < dAB) {
                this.ajoutPointMap(listeDistance, dPointDroite, i);
            }
            ++i;
        }
        while (!listeDistance.isEmpty() && pProches.size() < nb) {
            pProches.addAll((Collection)listeDistance.get(listeDistance.firstKey()));
            listeDistance.remove(listeDistance.firstKey());
        }
        listeDistance = new TreeMap();
        while (!pProches.isEmpty()) {
            dPointDroite = OutilsAlgebre.distanceToABLine(coord1, coord2, points[(Integer)pProches.get(0)]);
            dPointA = OutilsAlgebre.distance(coord1, points[(Integer)pProches.get(0)]);
            dAH = Math.sqrt(Math.abs(dPointA * dPointA - dPointDroite * dPointDroite));
            this.ajoutPointMap(listeDistance, dAH, (Integer)pProches.remove(0));
        }
        while (!listeDistance.isEmpty()) {
            pProches.addAll((Collection)listeDistance.get(listeDistance.firstKey()));
            listeDistance.remove(listeDistance.firstKey());
        }
        int[] nn = new int[pProches.size()];
        int i2 = 0;
        while (i2 < nn.length) {
            nn[i2] = (Integer)pProches.get(i2);
            ++i2;
        }
        return nn;
    }

    private void ajoutPointMap(TreeMap<Double, ArrayList<Integer>> map, double distance, int point) {
        ArrayList<Integer> alF = map.get(distance);
        if (alF == null) {
            alF = new ArrayList();
        }
        alF.add(point);
        map.put(distance, alF);
    }

    private void select(AxisData ad, Boolean select) {
        boolean ok = true;
        int[] nArray = ad.nearests;
        int n = ad.nearests.length;
        int n2 = 0;
        while (n2 < n) {
            int adobj = nArray[n2];
            if (!select.booleanValue()) {
                for (AxisData adit : this.axesData.values()) {
                    if (adit.axisId != ad.axisId && adit.selected) {
                        int[] nArray2 = adit.nearests;
                        int n3 = adit.nearests.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            int aditobj = nArray2[n4];
                            if (aditobj == adobj) {
                                ok = false;
                                break;
                            }
                            ++n4;
                        }
                    }
                    if (!ok) break;
                }
            }
            if (ok) {
                this.f3d.setSelected(adobj, select);
            }
            if (this.dd.isPictureAttrGiven() && select.booleanValue() && ad.display != null) {
                String imgFile = (String)this.dd.getAssocDataValue(adobj);
                try {
                    ad.display.addImage(imgFile, DataManager.getSingleton().getParams().getImagePath(), imgFile, adobj);
                }
                catch (ImageDisplayerException e) {
                    e.printStackTrace();
                }
            }
            ok = true;
            ++n2;
        }
    }

    private class AxisData {
        public int axisId;
        public int objA;
        public int objB;
        public ImageDisplayer display = null;
        public CaracTable carTable = null;
        public int segmentId = -1;
        public boolean selected = false;
        public int[] nearests = null;

        public AxisData(int a, int b) {
            int n = idGen;
            idGen = n + 1;
            this.axisId = n;
            this.objA = a;
            this.objB = b;
        }

        public String toString() {
            return String.valueOf(this.axisId) + " : " + this.objA + " - " + this.objB;
        }

        public void setSelected(boolean sel) {
            this.selected = sel;
            AlongAxisTool.this.select(this, sel);
        }
    }
}

