/*
 * Decompiled with CFR 0.152.
 */
package explorer.compute.tools;

import explorer.compute.compute.projection.BasicProjection;
import explorer.compute.compute.projection.ProjectionFactory;
import explorer.compute.compute.projection.StandardProjection;
import explorer.compute.tools.GViewTool;
import explorer.data.DataManager;
import explorer.data.ViewManager;
import explorer.display3D.DisplayExplorer;
import explorer.windows.w2D.icview.ICVCurrentAxes;
import explorer.windows.w2D.utils.GView;
import lib3d4j.data.DescriptionData;

public class CurrentAxesTool
extends GViewTool {
    private static int OFFSET = 1;
    private static String PREFIX = "PRAXIS_";
    private ICVCurrentAxes view;
    private int colorAxisRank = -1;
    private DisplayExplorer colorAxisDisplay = null;
    private DescriptionData dd;

    public CurrentAxesTool() {
        ViewManager.getSingleton().addViewObserver(this);
        this.dd = DataManager.getSingleton().getCompAttr();
    }

    public void setView(ICVCurrentAxes v) {
        this.view = v;
    }

    public void normalizationChanged(boolean n) {
        DataManager.getSingleton().getParams().setNormalize(n);
    }

    public void centerChanged(boolean c) {
        DataManager.getSingleton().getParams().setCentre(c);
    }

    public void projectionChanged() {
        int[] currAxes;
        int[] axes = this.view.getProjectionAxes();
        if (axes[0] != (currAxes = ((BasicProjection)this.f3d.getProjection()).getAxes())[0] || axes[1] != currAxes[1] || axes[2] != currAxes[2]) {
            StandardProjection p = ProjectionFactory.createStandardProjection(this.f3d.getProjectiveMethod(), axes);
            this.f3d.updateProjection(p);
        }
    }

    public void colorChanged() {
        if (this.colorAxisRank != -1) {
            this.removeAxisColor();
        }
        if (this.view.isColorSet()) {
            this.colorAxisRank = this.view.getColorIndice();
            String name = String.valueOf(PREFIX) + (this.colorAxisRank + OFFSET);
            DescriptionData dd = DataManager.getSingleton().getCompAttr();
            float[] values = this.f3d.getProjectiveMethod().getAxisProjection(this.colorAxisRank);
            dd.addColumn(values, name);
            DataManager.getSingleton().setColorAttribute(name);
            this.colorAxisDisplay = this.f3d;
        }
    }

    private void removeAxisColor() {
        String name = String.valueOf(PREFIX) + (this.colorAxisRank + OFFSET);
        this.colorAxisRank = -1;
        this.colorAxisDisplay = null;
        this.dd.dropColumn(name);
    }

    public boolean isColorAxisDisplay(GView v) {
        return v == this.colorAxisDisplay;
    }

    public int getColorAxisRank() {
        return this.colorAxisRank;
    }
}

