/*
 * Decompiled with CFR 0.152.
 */
package explorer.compute.tools;

import explorer.compute.compute.projection.PMAttrVal;
import explorer.compute.compute.projection.Projection;
import explorer.compute.compute.projection.ProjectionFactory;
import explorer.compute.compute.projection.StandardProjection;
import explorer.compute.compute.projection.WeightedProjection;
import explorer.compute.tools.GViewTool;
import explorer.data.DataManager;
import explorer.windows.w2D.icview.ICVDimensionsTravel;
import explorer.windows.w2D.utils.GView;
import lib3d4j.data.DatasetParams;

public class DimensionTravelTool
extends GViewTool {
    private WeightedProjection proj;
    private ICVDimensionsTravel view;
    private boolean todate = false;
    private DatasetParams param;

    public DimensionTravelTool() {
        this.name = "Outils Dimension Travel";
        this.param = DataManager.getSingleton().getParams();
    }

    @Override
    public void activeViewChanged(GView gv) {
        super.activeViewChanged(gv);
        this.todate = false;
        this.setDimensions();
    }

    public void setView(ICVDimensionsTravel v) {
        this.view = v;
        this.setDimensions();
    }

    public void setVecteursProjection(float[][] weights) {
        this.proj = ProjectionFactory.createWeightedProjection((PMAttrVal)this.f3d.getProjectiveMethod(), weights);
    }

    public void reinitialiser() {
    }

    public void setDimensions() {
        if (this.view != null && this.view.isShowing()) {
            float[][] coords = null;
            if (this.f3d != null) {
                Projection startingProj = this.f3d.getProjection();
                if (startingProj instanceof StandardProjection) {
                    int nbd = this.f3d.getProjectiveMethod().getNbDimensions();
                    int[] axes = ((StandardProjection)startingProj).getAxes();
                    coords = new float[3][nbd];
                    int i = 0;
                    while (i < 3) {
                        coords[i][axes[i]] = 1.0f;
                        ++i;
                    }
                } else if (startingProj instanceof WeightedProjection) {
                    coords = ((WeightedProjection)startingProj).getWeights();
                }
            }
            this.view.setDimensions(coords);
        }
    }

    public void dimensionsChanged() {
        if (this.f3d != null) {
            if (this.view.isDisplayLines()) {
                this.setVecteursProjection(this.view.getDimensions());
                this.f3d.drawDimensionTravelLines(this.proj.getCoordinates());
                this.todate = true;
            } else {
                this.f3d.removeDimensionTravelLines();
                this.todate = false;
            }
        }
    }

    public void move() {
        if (!this.todate) {
            this.setVecteursProjection(this.view.getDimensions());
        }
        this.f3d.updateProjection(this.proj);
    }

    public void showingChanged() {
        this.setDimensions();
    }
}

