/*
 * Decompiled with CFR 0.152.
 */
package explorer.compute.tools;

import explorer.compute.compute.projection.PMAttrVal;
import explorer.compute.compute.projection.PMMDS;
import explorer.compute.compute.projection.Projection;
import explorer.compute.compute.projection.ProjectiveMethod;
import explorer.compute.compute.projection.StandardProjection;
import explorer.compute.tools.GViewTool;
import explorer.data.DataManager;
import explorer.windows.w2D.icview.ICVObservations;
import explorer.windows.w2D.utils.Courbes2D;
import explorer.windows.w2D.utils.GView;
import java.util.Observable;
import java.util.Observer;
import lib3d4j.international.Messages;

public class ObservationsTool
extends GViewTool
implements Observer {
    ProjectiveMethod currentPM = null;
    ICVObservations tpg = null;

    public ObservationsTool() {
        DataManager.getSingleton().getParams().addObserver(this);
    }

    public void setTPG(ICVObservations t) {
        this.tpg = t;
    }

    @Override
    public void activeViewChanged(GView gv) {
        super.activeViewChanged(gv);
        if (this.f3d == null) {
            this.currentPM = null;
        } else {
            this.currentPM = this.f3d.getProjectiveMethod();
            Projection proj = this.f3d.getProjection();
            if (this.currentPM instanceof PMAttrVal || this.currentPM instanceof PMMDS) {
                int[] axes = null;
                axes = ((StandardProjection)proj).getAxes();
                double[] ev = this.currentPM.getED().getRealEigenvalues();
                double sum = 0.0;
                double[] dArray = ev;
                int n = ev.length;
                int n2 = 0;
                while (n2 < n) {
                    double elt = dArray[n2];
                    sum += elt;
                    ++n2;
                }
                double va = 0.0;
                int[] nArray = axes;
                int n3 = axes.length;
                n = 0;
                while (n < n3) {
                    int axe = nArray[n];
                    if (axe != -1) {
                        va += ev[axe];
                    }
                    ++n;
                }
                va = va * 100.0 / sum;
                this.tpg.draw(ev, axes[0], axes[1], axes[2], va);
            } else {
                this.tpg.unset();
            }
            if (DataManager.getSingleton().getParams().getClassCol() != -1 && this.currentPM instanceof PMAttrVal) {
                this.tpg.setQual(this.currentPM.getDunnIndice());
            } else {
                this.tpg.unsetQual();
            }
        }
    }

    @Override
    public void update(Observable o, Object arg) {
        int changed = (Integer)arg;
        if ((changed & 2) != 0) {
            if (DataManager.getSingleton().getParams().getClassCol() != -1 && this.currentPM != null && this.currentPM instanceof PMAttrVal) {
                this.tpg.setQual(this.currentPM.getDunnIndice());
            } else {
                this.tpg.unsetQual();
            }
        }
    }

    public void drawHistogram() {
        new Courbes2D(Messages.getString("common_eigenvalues"), 1, this.currentPM.getED().getRealEigenvalues(), this.f3d.getProjection());
    }
}

