/*
 * Decompiled with CFR 0.152.
 */
package explorer.compute.tools;

import explorer.compute.classification.klustaKwik.KlustaKwik;
import explorer.data.Common;
import java.util.LinkedList;
import lib3d4j.compute.tools.OutilsAlgebre;
import lib3d4j.compute.tools.OutilsTableaux;

public class OutilsCalculMalPlaces {
    private Common parent;
    KlustaKwik kk;
    int[] numeroPointsMalPlaces;
    int[] numeroDestPointsMalPlaces;

    public OutilsCalculMalPlaces(float[][] points, int[] classes) {
        this(points, classes, 1);
    }

    public OutilsCalculMalPlaces(float[][] points, int[] classes, int k) {
        int[][] res = OutilsCalculMalPlaces.pointsMalPlaces(points, classes, k);
        this.numeroPointsMalPlaces = res[0];
        this.numeroDestPointsMalPlaces = res[1];
        if (this.numeroPointsMalPlaces.length == 0) {
            return;
        }
        this.kk = new KlustaKwik();
        float[][] pointsMalPlaces = new float[this.numeroPointsMalPlaces.length][];
        int i = 0;
        while (i < res[0].length) {
            pointsMalPlaces[i] = points[this.numeroPointsMalPlaces[i]];
            ++i;
        }
        this.kk.Klusta(pointsMalPlaces);
    }

    public int nbPointsMalPlaces() {
        return this.numeroPointsMalPlaces.length;
    }

    public int getNumeroPointMalPlace(int i) {
        return this.numeroPointsMalPlaces[i];
    }

    public int getNumeroPointDestinationMalPlace(int i) {
        return this.numeroDestPointsMalPlaces[i];
    }

    public int[] getNumeroPointsDuCluster(int numeroCluster) {
        int cpt = 0;
        int i = 0;
        while (i < this.nbPointsMalPlaces()) {
            if (this.kk.clusterDuPoint(i) == numeroCluster) {
                ++cpt;
            }
            ++i;
        }
        int[] res = new int[cpt];
        cpt = 0;
        int i2 = 0;
        while (i2 < this.nbPointsMalPlaces()) {
            if (this.kk.clusterDuPoint(i2) == numeroCluster) {
                res[cpt] = this.getNumeroPointMalPlace(i2);
                ++cpt;
            }
            ++i2;
        }
        return res;
    }

    public int nbGroupes() {
        if (!this.groupesCoherents() || this.kk.centreCluster == null) {
            return 0;
        }
        return this.kk.centreCluster.length;
    }

    public boolean groupesCoherents() {
        return this.kk != null;
    }

    public float getMaximumCluster(int i) {
        return OutilsAlgebre.probDensityMultinormal(this.kk.centreCluster[i], this.kk.centreCluster[i], OutilsTableaux.doubleToFloat(this.kk.clusterCovariance[i].getArray()));
    }

    public int nbPointsGroupe(int i) {
        return this.kk.clustersReindexes[i].length;
    }

    public boolean isPresCluster(float[] pt, float densiteMax, int numeroCluster) {
        float[] centre = this.kk.centreCluster[numeroCluster];
        float proba = OutilsAlgebre.probDensityMultinormal(pt, centre, OutilsTableaux.doubleToFloat(this.kk.clusterCovariance[numeroCluster].getArray()));
        return proba > densiteMax;
    }

    public float densiteToDistance(float densite, float[] axe, int numeroCluster) {
        float[][] sigma = OutilsTableaux.doubleToFloat(this.kk.clusterCovariance[numeroCluster].getArray());
        return OutilsAlgebre.distanceDensityMultinormal(sigma, axe, densite);
    }

    public float[][] axesPrincipaux(int numeroCluster) {
        return OutilsAlgebre.mainAxesCovariance(this.kk.clusterCovariance[numeroCluster]);
    }

    public float densite(float[] point, int groupe) {
        return OutilsAlgebre.probDensityMultinormal(point, this.kk.centreCluster[groupe], OutilsTableaux.doubleToFloat(this.kk.clusterCovariance[groupe].getArray()));
    }

    public void supprimerGroupe(int numeroAEffacer) {
        this.kk.supprimerGroupe(numeroAEffacer);
    }

    public static int[][] pointsMalPlaces(float[][] points, int[] classe) {
        if (classe.length != points.length) {
            System.out.println("OutilsCalculs.voisins : MalPlaces mauvais tableau");
        }
        LinkedList<Integer> dep = new LinkedList<Integer>();
        LinkedList<Integer> dest = new LinkedList<Integer>();
        int i = 0;
        while (i < points.length) {
            int ppp = OutilsAlgebre.indexNN(points, i);
            if (classe[i] != classe[ppp]) {
                dep.add(i);
                dest.add(ppp);
            }
            ++i;
        }
        Integer[][] r = new Integer[2][dep.size()];
        dep.toArray(r[0]);
        dest.toArray(r[1]);
        int[][] res = new int[2][r[0].length];
        int i2 = 0;
        while (i2 < res.length) {
            int j = 0;
            while (j < res[i2].length) {
                res[i2][j] = r[i2][j];
                ++j;
            }
            ++i2;
        }
        return res;
    }

    public static int[][] pointsMalPlaces(float[][] points, int[] classe, int k) {
        int j;
        if (k == 1) {
            return OutilsCalculMalPlaces.pointsMalPlaces(points, classe);
        }
        if (classe.length != points.length) {
            System.out.println("OutilsCalculs.voisins : MalPlaces mauvais tableau");
        }
        LinkedList<Integer> dep = new LinkedList<Integer>();
        LinkedList<Integer> dest = new LinkedList<Integer>();
        int i = 0;
        while (i < points.length) {
            int[] ppp = OutilsAlgebre.kNearestNeighbors(k, i, points);
            int[] classeV = new int[classe.length];
            j = 0;
            while (j < classeV.length) {
                classeV[j] = 0;
                ++j;
            }
            int[] nArray = ppp;
            int n = ppp.length;
            int n2 = 0;
            while (n2 < n) {
                j = nArray[n2];
                int n3 = classe[j];
                classeV[n3] = classeV[n3] + 1;
                ++n2;
            }
            int max = 0;
            int classePpv = 0;
            int j2 = 0;
            while (j2 < classeV.length) {
                if (classeV[j2] > max) {
                    max = classeV[j2];
                    classePpv = j2;
                }
                ++j2;
            }
            if (classe[i] != classePpv) {
                dep.add(i);
                dest.add(ppp[0]);
            }
            ++i;
        }
        Integer[][] r = new Integer[2][dep.size()];
        dep.toArray(r[0]);
        dest.toArray(r[1]);
        int[][] res = new int[2][r[0].length];
        int i2 = 0;
        while (i2 < res.length) {
            j = 0;
            while (j < res[i2].length) {
                res[i2][j] = r[i2][j];
                ++j;
            }
            ++i2;
        }
        return res;
    }

    public boolean isMalPlace(int num) {
        return OutilsTableaux.isIn(this.numeroPointsMalPlaces, num);
    }
}

