/*
 * Decompiled with CFR 0.152.
 */
package explorer.compute.tools;

import explorer.compute.tools.Tool;
import explorer.data.DataManager;
import explorer.data.ViewManager;
import explorer.windows.w2D.icview.ICVSampling;
import java.util.Arrays;
import java.util.Random;
import lib3d4j.data.Source;

public class SamplingTool
extends Tool {
    private ICVSampling view;

    public SamplingTool(ICVSampling v) {
        this.name = "Sampling";
        this.view = v;
    }

    public void doSample() {
        int rate = this.view.getRate();
        Source s = ViewManager.getSingleton().getActiveSource();
        int nbobj = s.getNbObjects();
        boolean[] samp = new boolean[nbobj];
        Arrays.fill(samp, false);
        Random rand = new Random();
        int nbt = 0;
        int nbexp = (int)((float)nbobj * (float)rate / 100.0f);
        int i = 0;
        while (nbt < nbexp) {
            if (!samp[i] && rand.nextInt(100) < rate) {
                samp[i] = true;
                ++nbt;
            }
            int n = i = i == nbobj - 1 ? 0 : i + 1;
        }
        int[] crop = new int[nbexp];
        nbt = 0;
        i = 0;
        while (i < nbobj) {
            if (samp[i]) {
                crop[nbt] = s.getRealIndex(i);
                ++nbt;
            }
            ++i;
        }
        DataManager.getSingleton().createCropedSource(s, crop);
        this.view.close();
    }

    public void doCancel() {
        this.view.close();
    }
}

