/*
 * Decompiled with CFR 0.152.
 */
package explorer.compute.tools.classification;

import explorer.compute.classification.KMean;
import explorer.compute.tools.classification.ClassifTool;
import explorer.data.DataManager;
import explorer.windows.w2D.icview.classification.ClassificationView;
import explorer.windows.w2D.icview.classification.KMeanView;
import java.util.List;
import lib3d4j.data.DescriptionData;

public class OutilsClassifKmeans
extends ClassifTool {
    public static int DEF_NB_CLASS = 5;
    public static int DEF_NB_STEPS = 20;
    private KMeanView kmd = null;
    KMean km = null;
    int nbclasses = DEF_NB_CLASS;
    DescriptionData dd = DataManager.getSingleton().getCompAttr();

    public OutilsClassifKmeans() {
        this.name = "Outils Classe";
    }

    @Override
    public void setView(ClassificationView view) {
        if (view instanceof KMeanView) {
            this.kmd = (KMeanView)view;
            this.kmd.setNbClasses(DEF_NB_CLASS);
        }
    }

    public void afficherKMeans(int nbc) {
        this.nbclasses = nbc;
        this.afficherKMeans();
    }

    @Override
    public void activate(boolean aFlag) {
        if (aFlag) {
            this.afficherKMeans();
        } else {
            this.effacerKMeans();
        }
    }

    private void afficherKMeans() {
        float[][] coord = this.f3d.getPoints();
        this.km = new KMean(coord, this.nbclasses);
        this.km.compute(DEF_NB_STEPS);
        int[] res = this.km.getClasses();
        float[] fres = this.completeClassif(res, this.nbclasses);
        List<Object> classes = this.listClasses(this.nbclasses, res.length);
        this.dd.dropColumn("AUTO_KMEANS");
        this.dd.addColumn(fres, classes, "AUTO_KMEANS");
        DataManager.getSingleton().setClassAttribute("AUTO_KMEANS");
        DataManager.getSingleton().setColorAttribute("AUTO_KMEANS");
    }

    private void effacerKMeans() {
        this.dd.dropColumnStartWith("AUTO_KMEANS");
    }
}

