/*
 * Decompiled with CFR 0.152.
 */
package explorer.compute.tools.classification;

import explorer.compute.classification.Minkowski;
import explorer.compute.tools.classification.ClassifTool;
import explorer.data.DataManager;
import explorer.display3D.DisplayExplorer;
import explorer.windows.w2D.icview.classification.ClassificationView;
import explorer.windows.w2D.icview.classification.MinkowskiView;
import java.util.List;
import lib3d4j.data.DescriptionData;

public class OutilsClassifMinkowski
extends ClassifTool {
    public static int DEF_NB_CLASS = 5;
    public static int DEF_NB_STEPS = 20;
    private MinkowskiView minkd;
    Minkowski mink = null;
    int nbclasses = DEF_NB_CLASS;
    DescriptionData dd = DataManager.getSingleton().getCompAttr();

    public OutilsClassifMinkowski() {
        this.name = "Outils Classe";
    }

    @Override
    public void setView(ClassificationView view) {
        if (view instanceof MinkowskiView) {
            this.minkd = (MinkowskiView)view;
            this.minkd.setNbClasses(DEF_NB_CLASS);
        }
    }

    @Override
    public void activate(boolean aFlag) {
        if (aFlag) {
            this.afficherMinkowski();
        } else {
            this.effacerMinkowski();
        }
    }

    public void setF3D(DisplayExplorer f) {
        this.f3d = f;
    }

    public void afficherMinkowski(int nbc) {
        this.nbclasses = nbc;
        this.afficherMinkowski();
    }

    public void afficherMinkowski() {
        float[][] coord = this.f3d.getPoints();
        this.mink = new Minkowski(coord, this.nbclasses);
        this.nbclasses = this.mink.getNbClasses();
        int[] res = this.mink.getClasses();
        float[] fres = this.completeClassif(res, this.nbclasses);
        List<Object> classes = this.listClasses(this.nbclasses, res.length);
        this.dd.dropColumn("AUTO_MINK");
        this.dd.addColumn(fres, classes, "AUTO_MINK");
        DataManager.getSingleton().setClassAttribute("AUTO_MINK");
        DataManager.getSingleton().setColorAttribute("AUTO_MINK");
    }

    public void effacerMinkowski() {
        this.dd.dropColumnStartWith("AUTO_MINK");
    }
}

