/*
 * Decompiled with CFR 0.152.
 */
package explorer.compute.tools.classification;

import explorer.compute.classification.klustaKwik.KlustaKwik;
import explorer.compute.tools.classification.ClassifTool;
import explorer.data.DataManager;
import explorer.display3D.DisplayExplorer;
import explorer.windows.w2D.icview.classification.ClassificationView;
import explorer.windows.w2D.icview.classification.GaussianMixtureView;
import java.util.List;
import lib3d4j.compute.tools.OutilsAlgebre;
import lib3d4j.compute.tools.OutilsTableaux;
import lib3d4j.data.DescriptionData;

public class OutilsClassifMixture
extends ClassifTool {
    private GaussianMixtureView view = null;
    private KlustaKwik kk;
    int numeroSelectionne;
    int nbClusters;
    boolean ellipsesAffichees = false;
    boolean afficher = false;
    float[] densiteParEllipse;
    float[] maximum;
    private DescriptionData dd = DataManager.getSingleton().getCompAttr();

    public OutilsClassifMixture() {
        this.name = "Outils Classe";
        this.reinitialiser();
    }

    @Override
    public void setView(ClassificationView view) {
        if (view instanceof GaussianMixtureView) {
            this.view = (GaussianMixtureView)view;
        }
    }

    @Override
    public void activate(boolean aFlag) {
        if (aFlag) {
            this.afficherMixture();
        } else {
            this.effacerMixture();
        }
    }

    public void setF3D(DisplayExplorer f) {
        this.f3d = f;
        this.reinitialiser();
    }

    private void reinitialiser() {
        this.numeroSelectionne = -1;
        this.nbClusters = -1;
        this.ellipsesAffichees = false;
        this.afficher = false;
    }

    public void effacerMixture() {
        if (this.f3d != null) {
            this.f3d.removeClusterEllipsoids();
        }
    }

    public void afficherMixture() {
        if (this.f3d != null) {
            this.effacerMixture();
            this.ellipsesAffichees = true;
            this.f3d.getProjection().getCoordinates();
            float[][] a = this.f3d.getPoints();
            int nbPoints = a.length;
            int nbDim = a[0].length;
            float[] maxs = new float[nbDim];
            float[][] fArray = a;
            int n = a.length;
            int n2 = 0;
            while (n2 < n) {
                float[] point = fArray[n2];
                int i = 0;
                while (i < nbDim) {
                    if (maxs[i] < Math.abs(point[i])) {
                        maxs[i] = Math.abs(point[i]);
                    }
                    ++i;
                }
                ++n2;
            }
            float max = 0.0f;
            float[] i = maxs;
            int n3 = maxs.length;
            n = 0;
            while (n < n3) {
                float elem = i[n];
                max = Math.max(max, elem);
                ++n;
            }
            float[][] reda = new float[a.length][3];
            int i2 = 0;
            while (i2 < a.length) {
                reda[i2] = new float[]{a[i2][0] / max, a[i2][1] / max, a[i2][2] / max};
                ++i2;
            }
            this.kk = new KlustaKwik();
            this.kk.Klusta(reda);
            float[][][] pointsParClusters = this.kk.pointsParCluster;
            this.nbClusters = pointsParClusters.length;
            int[][] byCluster = this.kk.getClusters();
            int cptClust = 0;
            while (cptClust < this.nbClusters) {
                int cptPoint = 0;
                while (cptPoint < pointsParClusters[cptClust].length) {
                    int cptDim = 0;
                    while (cptDim < nbDim) {
                        pointsParClusters[cptClust][cptPoint][cptDim] = pointsParClusters[cptClust][cptPoint][cptDim] * max;
                        ++cptDim;
                    }
                    ++cptPoint;
                }
                ++cptClust;
            }
            this.dd.dropColumn("AUTO_KMEANS");
            int[] res = new int[nbPoints];
            int numCluster = 0;
            int[][] nArray = byCluster;
            int n4 = byCluster.length;
            int n5 = 0;
            while (n5 < n4) {
                int[] inCluster;
                int[] nArray2 = inCluster = nArray[n5];
                int n6 = inCluster.length;
                int n7 = 0;
                while (n7 < n6) {
                    int rank = nArray2[n7];
                    res[rank] = numCluster;
                    ++n7;
                }
                ++numCluster;
                ++n5;
            }
            List<Object> classes = this.listClasses(this.nbClusters, nbPoints);
            float[] fres = this.completeClassif(res, this.nbClusters);
            this.dd.addColumn(fres, classes, "AUTO_KMEANS");
            DataManager.getSingleton().setClassAttribute("AUTO_KMEANS");
            DataManager.getSingleton().setColorAttribute("AUTO_KMEANS");
            int i3 = 0;
            while (i3 < pointsParClusters.length) {
                this.f3d.addClusterEllipsoid(pointsParClusters[i3], i3);
                ++i3;
            }
        }
    }

    public void choisirEllipseSuivante() {
    }

    public void choisirEllipsePrecedente() {
    }

    public void setDensiteMinimale(float densite) {
        this.densiteParEllipse[this.numeroSelectionne] = densite;
        float max = this.maximum[this.numeroSelectionne];
        if (max < densite) {
            return;
        }
        float[][] sigma = OutilsTableaux.doubleToFloat(this.kk.clusterCovariance[this.numeroSelectionne].getArray());
        float[] x1 = OutilsAlgebre.mainAxesCovariance(this.kk.clusterCovariance[this.numeroSelectionne])[0];
        float[] x2 = OutilsAlgebre.mainAxesCovariance(this.kk.clusterCovariance[this.numeroSelectionne])[1];
        float longueur = OutilsAlgebre.distanceDensityMultinormal(sigma, x1, densite);
        float largeur = OutilsAlgebre.distanceDensityMultinormal(sigma, x2, densite);
        float cfr_ignored_0 = this.maximum[this.numeroSelectionne];
    }

    public boolean isEllipsesTracees() {
        return this.ellipsesAffichees;
    }
}

