/*
 * Decompiled with CFR 0.152.
 */
package explorer.compute.tools.flatdrawing;

import explorer.compute.compute.projection.Projection;
import explorer.compute.compute.projection.ProjectiveMethod;
import explorer.compute.tools.GViewTool;
import explorer.compute.tools.flatdrawing.ContributionsFDTool;
import explorer.compute.tools.flatdrawing.FlatDrawingTool;
import explorer.compute.tools.flatdrawing.LabelsFDTool;
import explorer.compute.tools.flatdrawing.ShepardSimpleFDTool;
import explorer.compute.tools.flatdrawing.SquareCosFDTool;
import explorer.compute.tools.flatdrawing.SymbolsFDTool;
import explorer.compute.tools.flatdrawing.VoronoiDist2D3DFDTool;
import explorer.compute.tools.flatdrawing.VoronoiDist2DxDFDTool;
import explorer.compute.tools.flatdrawing.VoronoiDist3DxDFDTool;
import explorer.compute.tools.flatdrawing.VoronoiProxy2D3DFDTool;
import explorer.compute.tools.flatdrawing.VoronoiProxy2DxDFDTool;
import explorer.compute.tools.flatdrawing.VoronoiProxy3DxDFDTool;
import explorer.compute.tools.generic.BiLevelParentTool;
import explorer.data.Source3DCoord;
import explorer.data.SourceAttrVal;
import explorer.data.SourceDist;
import explorer.windows.w2D.icview.flatdrawing.EmptyFDView;
import explorer.windows.w2D.icview.flatdrawing.FlatDrawingView;
import explorer.windows.w2D.icview.flatdrawing.NumericalParameterFDView;
import explorer.windows.w2D.icview.generic.BiLevelParentView;
import explorer.windows.w2D.utils.GView;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lib3d4j.data.Source;
import lib3d4j.international.Messages;

public class FlatDrawingParentTool
extends GViewTool
implements BiLevelParentTool {
    protected static final int ATTRVAL = 0;
    protected static final int DIST = 1;
    protected static final int COORD = 2;
    protected static final int UNMANAGED = 3;
    private BiLevelParentView view = null;
    private Projection p;
    private List<List<String>> graphnames = null;
    private Map<String, FlatDrawingView> subviews = null;
    private FlatDrawingView currentsubview = null;

    public FlatDrawingParentTool() {
        this.initNames();
    }

    @Override
    public void activeViewChanged(GView gv) {
        super.activeViewChanged(gv);
        if (gv == null) {
            this.p = null;
        } else if (this.p != gv.getProjection()) {
            this.p = gv.getProjection();
            this.view.setMethodList(this.getGraphs());
        }
    }

    @Override
    public void setBLPView(BiLevelParentView v) {
        this.view = v;
        this.initTools();
    }

    private void addSubView(String fdvtitle, FlatDrawingTool fdt, boolean empty) {
        FlatDrawingView fdv = empty ? new EmptyFDView(fdvtitle, fdt) : new NumericalParameterFDView(fdvtitle, fdt);
        this.view.add(fdv);
        this.subviews.put(fdvtitle, fdv);
    }

    private void initTools() {
        this.subviews = new HashMap<String, FlatDrawingView>();
        this.addSubView(Messages.getString("tpgc2d_shepard_simple"), new ShepardSimpleFDTool(this), true);
        this.addSubView(Messages.getString("tpgc2d_2d_symbol"), new SymbolsFDTool(this), true);
        this.addSubView(Messages.getString("tpgc2d_2d_label"), new LabelsFDTool(this), true);
        this.addSubView(Messages.getString("tpgc2d_contrib"), new ContributionsFDTool(this), false);
        this.addSubView(Messages.getString("tpgc2d_squarecos"), new SquareCosFDTool(this), false);
        this.addSubView(Messages.getString("tpgc2d_voronoi_2d3d"), new VoronoiProxy2D3DFDTool(this), true);
        this.addSubView(Messages.getString("tpgc2d_voronoi_2dxd"), new VoronoiProxy2DxDFDTool(this), true);
        this.addSubView(Messages.getString("tpgc2d_voronoi_3dxd"), new VoronoiProxy3DxDFDTool(this), true);
        this.addSubView(Messages.getString("tpgc2d_distor_2d3d"), new VoronoiDist2D3DFDTool(this), true);
        this.addSubView(Messages.getString("tpgc2d_distor_2dxd"), new VoronoiDist2DxDFDTool(this), true);
        this.addSubView(Messages.getString("tpgc2d_distor_3dxd"), new VoronoiDist3DxDFDTool(this), true);
    }

    private void initNames() {
        this.graphnames = new ArrayList<List<String>>();
        ArrayList<String> lav = new ArrayList<String>();
        lav.add(Messages.getString("tpgc2d_shepard_simple"));
        lav.add(Messages.getString("tpgc2d_2d_symbol"));
        lav.add(Messages.getString("tpgc2d_2d_label"));
        lav.add(Messages.getString("tpgc2d_contrib"));
        lav.add(Messages.getString("tpgc2d_squarecos"));
        lav.add(Messages.getString("tpgc2d_voronoi_2d3d"));
        lav.add(Messages.getString("tpgc2d_voronoi_2dxd"));
        lav.add(Messages.getString("tpgc2d_voronoi_3dxd"));
        lav.add(Messages.getString("tpgc2d_distor_2d3d"));
        lav.add(Messages.getString("tpgc2d_distor_2dxd"));
        lav.add(Messages.getString("tpgc2d_distor_3dxd"));
        this.graphnames.add(0, lav);
        ArrayList<String> ld = new ArrayList<String>();
        ld.add(Messages.getString("tpgc2d_shepard_simple"));
        ld.add(Messages.getString("tpgc2d_2d_symbol"));
        ld.add(Messages.getString("tpgc2d_2d_label"));
        ld.add(Messages.getString("tpgc2d_contrib"));
        ld.add(Messages.getString("tpgc2d_squarecos"));
        ld.add(Messages.getString("tpgc2d_voronoi_2d3d"));
        ld.add(Messages.getString("tpgc2d_voronoi_2dxd"));
        ld.add(Messages.getString("tpgc2d_voronoi_3dxd"));
        ld.add(Messages.getString("tpgc2d_distor_2d3d"));
        ld.add(Messages.getString("tpgc2d_distor_2dxd"));
        ld.add(Messages.getString("tpgc2d_distor_3dxd"));
        this.graphnames.add(1, ld);
        this.graphnames.add(2, new ArrayList());
        this.graphnames.add(3, new ArrayList());
    }

    private List<String> getGraphs() {
        Source src = this.p.getProjectiveMethod().getSource();
        if (src instanceof SourceAttrVal) {
            return this.graphnames.get(0);
        }
        if (src instanceof SourceDist) {
            return this.graphnames.get(1);
        }
        if (src instanceof Source3DCoord) {
            return this.graphnames.get(2);
        }
        return this.graphnames.get(3);
    }

    @Override
    public void toolChanged() {
        String ms = this.view.getMethod();
        if (this.currentsubview != null) {
            this.currentsubview.setVisible(false);
        }
        if (ms != null) {
            this.currentsubview = this.subviews.get(ms);
            this.currentsubview.setVisible(true);
        }
    }

    public Source getSource() {
        return this.p.getProjectiveMethod().getSource();
    }

    public ProjectiveMethod getPM() {
        return this.p.getProjectiveMethod();
    }

    public Projection getProj() {
        return this.p;
    }
}

